/*
 * Decompiled with CFR 0.152.
 */
package marketo.push;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.marketo.Marketo;
import com.marketo.MarketoActivity;
import com.marketo.MarketoConfig;
import com.marketo.errors.MktoException;
import marketo.utils.MktoUtils;
import org.json.JSONObject;

public class MktoPushMessage {
    private String title;
    private String message;
    private long time;
    private int defaultIcon = 17301651;
    private String action;

    public MktoPushMessage(JSONObject object) {
        this.setTitle(object.optString("title"));
        this.setMessage(object.optString("message"));
        this.setTime(System.currentTimeMillis());
        this.setAction(object.optString("action"));
    }

    long getTime() {
        return this.time;
    }

    void setTime(long time) {
        this.time = time;
    }

    public String getAction() {
        return this.action;
    }

    void setAction(String action) {
        this.action = action;
    }

    int getDefaultIcon() {
        return this.defaultIcon;
    }

    void setDefaultIcon(int defaultIcon) {
        if (defaultIcon > 0) {
            this.defaultIcon = defaultIcon;
        }
    }

    String getTitle() {
        return this.title;
    }

    void setTitle(CharSequence charSequence) {
        if (TextUtils.isEmpty((CharSequence)this.title) && charSequence != null) {
            this.title = charSequence.toString();
        }
    }

    String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    @SuppressLint(value={"NewApi"})
    private Notification runBuilder(Notification.Builder builder) {
        if (Build.VERSION.SDK_INT < 16) {
            return builder.getNotification();
        }
        return builder.build();
    }

    private PendingIntent getMarketoBroadcastIntent(Context context, String actionName, String action, long campaignId) {
        Intent broadcast = new Intent(context, MarketoActivity.class);
        if (!TextUtils.isEmpty((CharSequence)action)) {
            broadcast.putExtra(actionName, action);
        }
        broadcast.putExtra("mkto.campaignId", campaignId);
        broadcast.setAction("mkto.dummyAction");
        broadcast.setFlags(0x20000000);
        return PendingIntent.getActivity((Context)context, (int)((int)campaignId), (Intent)broadcast, (int)0x10000000);
    }

    public void showNotification(Context context, long campaignId) throws MktoException {
        try {
            PackageManager manager = context.getPackageManager();
            ApplicationInfo appInfo = manager.getApplicationInfo(context.getPackageName(), 0);
            this.setTitle(manager.getApplicationLabel(appInfo));
            this.setDefaultIcon(appInfo.icon);
        }
        catch (PackageManager.NameNotFoundException e) {
            MktoUtils.writeError("Failed to get application info");
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.showPushJellyBeanAndAbove(context, campaignId);
        } else {
            MktoUtils.writeError("Marketo SDK supports devices having Android Version ICE_CREAM_SANDWICH and Above.");
        }
    }

    @SuppressLint(value={"NewApi"})
    public void showPushJellyBeanAndAbove(Context context, long campaignId) throws MktoException {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            Notification notification = this.getNotification(context, campaignId);
            notificationManager.notify((int)campaignId, notification);
            MktoUtils.writeInfo("Push notification shown to the user.");
        }
        catch (Exception ex) {
            throw new MktoException("Failed to show push notification");
        }
    }

    public Notification getNotification(Context context, long campaignId) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        PendingIntent pendingIntent = this.getMarketoBroadcastIntent(context, "mkto.primary", this.action, campaignId);
        Notification.Builder builder = new Notification.Builder(context).setWhen(System.currentTimeMillis()).setContentIntent(pendingIntent);
        String chanelName = MktoUtils.readPreference(context, "mkto.channel_name");
        if (TextUtils.isEmpty((CharSequence)chanelName)) {
            chanelName = "MKTO";
        }
        MktoUtils.writeInfo("Push Notification Channel Name :- " + chanelName);
        if (Build.VERSION.SDK_INT > 25) {
            NotificationChannel chan1 = new NotificationChannel("default", (CharSequence)chanelName, 3);
            notificationManager.createNotificationChannel(chan1);
            builder = new Notification.Builder(context, "default").setWhen(System.currentTimeMillis()).setContentIntent(pendingIntent);
        }
        if (Build.VERSION.SDK_INT > 16) {
            builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)this.getMessage()));
        }
        Uri uri = RingtoneManager.getDefaultUri((int)2);
        builder.setSound(uri);
        if (this.getTitle() != null) {
            builder.setContentTitle((CharSequence)this.getTitle());
            builder.setTicker((CharSequence)this.getTitle());
        }
        if (this.getMessage() != null) {
            builder.setContentText((CharSequence)this.getMessage());
        }
        MarketoConfig.Notification configuration = Marketo.getInstance(context).getNotificationConfig();
        int smallNotificationIcon = -1;
        if (configuration != null) {
            MktoUtils.writeInfo("Applying notification configuration");
            smallNotificationIcon = configuration.getNotificationSmallIcon();
            Bitmap largeIcon = configuration.getNotificationLargeIcon();
            if (largeIcon != null) {
                builder.setLargeIcon(largeIcon);
            }
        }
        int defaults = 0;
        defaults |= 4;
        defaults |= 1;
        builder.setDefaults(defaults |= 2);
        if (smallNotificationIcon < 0) {
            smallNotificationIcon = this.getDefaultIcon();
        }
        builder.setSmallIcon(smallNotificationIcon);
        builder.setAutoCancel(true);
        Notification notification = this.runBuilder(builder);
        notification.flags |= 0x10;
        return notification;
    }

    static enum MktoPushType {
        NORMALVIEW,
        BIGVIEW;

    }

    static enum MktoPushStyle {
        NORMAL;

    }
}

