/*
 * Decompiled with CFR 0.152.
 */
package marketo.collector;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import java.util.Locale;
import marketo.utils.MktoUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MktoCollector {
    public static JSONObject getProfile(Context mCtx) {
        JSONObject profile = new JSONObject();
        if (mCtx != null) {
            try {
                Resources resources = mCtx.getResources();
                profile.put("manufacturer", (Object)Build.MANUFACTURER);
                profile.put("model", (Object)Build.MODEL);
                profile.put("hardware", (Object)MktoCollector.getHWProfile(mCtx, resources));
                profile.put("software", (Object)MktoUtils.getBuildInfo());
                profile.put("network_info", (Object)MktoUtils.haveInternet(mCtx));
                profile.put("location", (Object)MktoUtils.getLocationJSON(mCtx));
                profile.put("new_install", MktoUtils.readPreference(mCtx, "mkto.newuser", false));
            }
            catch (Exception e) {
                MktoUtils.writelog("Failed to capture device state");
            }
        }
        return profile;
    }

    private static JSONObject getHWProfile(Context mCtx, Resources resources) throws JSONException {
        JSONObject hw = new JSONObject();
        JSONObject screen = new JSONObject();
        Configuration config = resources.getConfiguration();
        screen.put("screen-size", (Object)MktoCollector.getScreenSize(config));
        screen.put("device_type", (Object)MktoCollector.getDeviceType(config));
        hw.put("screen", (Object)screen);
        return hw;
    }

    public static String getScreenSize(Configuration config) {
        String screenSize = "";
        switch (config.screenLayout & 0xF) {
            case 1: {
                screenSize = "small";
                break;
            }
            case 2: {
                screenSize = "normal";
                break;
            }
            case 3: {
                screenSize = "large";
                break;
            }
            case 4: {
                screenSize = "xlarge";
                break;
            }
        }
        return screenSize;
    }

    static JSONObject getHWProfile(Configuration config, DisplayMetrics metrics) throws Exception {
        JSONObject hw = new JSONObject();
        hw.put("fontScale", (double)config.fontScale);
        if (config.mcc != 0) {
            hw.put("mcc", (double)config.fontScale);
        }
        if (config.mnc != 0) {
            hw.put("mnc", config.mnc);
        }
        JSONObject screen = new JSONObject();
        screen.put("screen-size", (Object)MktoCollector.getScreenSize(config));
        screen.put("diagonal-length", (Object)MktoCollector.getDigLgth(metrics));
        screen.put("xdpi", (Object)Double.toString(metrics.xdpi));
        screen.put("ydpi", (Object)Double.toString(metrics.ydpi));
        screen.put("pixel-density", (Object)MktoCollector.getScreenDensity(metrics));
        hw.put("screen", (Object)screen);
        switch (config.keyboard) {
            case 1: {
                hw.put("keyboard", (Object)"nokeys");
                break;
            }
            case 3: {
                hw.put("keyboard", (Object)"12key");
                break;
            }
            case 2: {
                hw.put("keyboard", (Object)"qwerty");
                break;
            }
            default: {
                hw.put("keyboard", (Object)"unknown");
            }
        }
        switch (config.navigation) {
            case 2: {
                hw.put("nav", (Object)"dpad");
                break;
            }
            case 3: {
                hw.put("nav", (Object)"trackball");
                break;
            }
            case 4: {
                hw.put("nav", (Object)"wheel");
                break;
            }
            case 1: {
                hw.put("nav", (Object)"nonav");
                break;
            }
            default: {
                hw.put("nav", (Object)"unknown");
            }
        }
        switch (config.orientation) {
            case 0: {
                hw.put("orientation", (Object)"unknown");
                break;
            }
            case 2: {
                hw.put("orientation", (Object)"landscape");
                break;
            }
            case 1: {
                hw.put("orientation", (Object)"portrait");
            }
        }
        hw.put("touch", (Object)MktoCollector.getTouchMech(config));
        return hw;
    }

    private static String getDigLgth(DisplayMetrics metrics) {
        double xin = (float)metrics.widthPixels / metrics.xdpi;
        double yin = (float)metrics.heightPixels / metrics.ydpi;
        double diag = Math.sqrt(Math.pow(xin, 2.0) + Math.pow(yin, 2.0));
        return String.format(Locale.US, "%1$.2f", diag);
    }

    private static String getScreenDensity(DisplayMetrics metrics) {
        String pixelDensityText = "";
        switch (metrics.densityDpi) {
            case 120: {
                pixelDensityText = "ldpi";
                break;
            }
            case 160: {
                pixelDensityText = "mdpi";
                break;
            }
            case 213: {
                pixelDensityText = "tvdpi";
                break;
            }
            case 240: {
                pixelDensityText = "hdpi";
                break;
            }
            case 320: {
                pixelDensityText = "xhdpi";
            }
        }
        return pixelDensityText;
    }

    public static String getTouchMech(Configuration config) {
        String mechanism = "unknown";
        switch (config.touchscreen) {
            case 2: {
                mechanism = "stylus";
                break;
            }
            case 3: {
                mechanism = "finger";
                break;
            }
            case 1: {
                mechanism = "notouch";
            }
        }
        return mechanism;
    }

    public static String getDeviceType(Configuration config) {
        String screenSize = "unknown";
        switch (config.screenLayout & 0xF) {
            case 1: 
            case 2: 
            case 3: {
                screenSize = "android_phone";
                break;
            }
            case 4: {
                screenSize = "android_tablet";
                break;
            }
            case 0: {
                screenSize = "unknown";
            }
        }
        return screenSize;
    }
}

