/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.marketo.R;
import com.marketo.inapp.models.InAppImage;

public final class ScalableImageView
extends ImageView {
    private InAppImage.Scale scale;
    private float ratio;

    public ScalableImageView(Context context) {
        this(context, null);
    }

    public ScalableImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScalableImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.ScalableImageView, 0, 0);
        this.scale = InAppImage.Scale.values()[a.getInt(R.styleable.ScalableImageView_scale, 0)];
        this.ratio = a.getFloat(R.styleable.ScalableImageView_ratio, 0.0f);
        a.recycle();
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public InAppImage.Scale getScale() {
        return this.scale;
    }

    public void setScale(InAppImage.Scale scale) {
        this.scale = scale;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int drawableWidth = drawable2.getIntrinsicWidth();
            int drawableHeight = drawable2.getIntrinsicHeight();
            float drawableRatio = drawableWidth > 0 ? (float)drawableHeight / (float)drawableWidth : 1.0f;
            float drawableScale = 1.0f;
            if (this.ratio > 0.0f) {
                heightSize = (int)((float)widthSize * this.ratio);
            }
            switch (this.scale) {
                case WIDTH: {
                    heightSize = Math.min((int)((float)widthSize * drawableRatio), heightSize);
                    drawableScale = (float)widthSize / (float)drawableWidth;
                    break;
                }
                case HEIGHT: {
                    widthSize = Math.min((int)((float)heightSize / drawableRatio), widthSize);
                    drawableScale = (float)heightSize / (float)drawableHeight;
                    break;
                }
                case BOTH: {
                    widthSize = Math.min((int)((float)heightSize / drawableRatio), widthSize);
                    heightSize = Math.min((int)((float)widthSize * drawableRatio), heightSize);
                    drawableScale = Math.min((float)widthSize / (float)drawableWidth, (float)heightSize / (float)drawableHeight);
                }
            }
            Matrix matrix = this.getImageMatrix();
            matrix.reset();
            matrix.setTranslate((float)Math.round(((float)widthSize - (float)drawableWidth * drawableScale) * 0.5f), 0.0f);
            matrix.setScale(drawableScale, drawableScale);
            this.setImageMatrix(matrix);
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }
}

