/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.views;

import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.widget.ImageView;
import java.util.HashSet;

public final class MktoDrawable
extends Drawable {
    public static final int DEFAULT_BORDER_COLOR = -16777216;
    private final RectF mBounds = new RectF();
    private final RectF mDrawableRect = new RectF();
    private final RectF mBitmapRect = new RectF();
    private Bitmap mBitmap;
    private Paint mBitmapPaint;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private final RectF mBorderRect = new RectF();
    private Paint mBorderPaint;
    private final Matrix mShaderMatrix = new Matrix();
    private final RectF mSquareCornersRect = new RectF();
    private Shader.TileMode mTileModeX = Shader.TileMode.CLAMP;
    private Shader.TileMode mTileModeY = Shader.TileMode.CLAMP;
    private boolean mRebuildShader = true;
    private float mCornerRadius = 0.0f;
    private final boolean[] mCornersRounded = new boolean[]{true, true, true, true};
    private boolean mOval = false;
    private float mBorderWidth = 0.0f;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;

    public MktoDrawable(Bitmap bitmap) {
        if (bitmap != null) {
            this.mBitmap = bitmap;
            this.mBitmapWidth = bitmap.getWidth();
            this.mBitmapHeight = bitmap.getHeight();
            this.mBitmapRect.set(0.0f, 0.0f, (float)this.mBitmapWidth, (float)this.mBitmapHeight);
            this.mBitmapPaint = new Paint();
            this.mBitmapPaint.setStyle(Paint.Style.FILL);
            this.mBitmapPaint.setAntiAlias(true);
            this.mBorderPaint = new Paint();
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setAntiAlias(true);
            this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -16777216));
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        }
    }

    public static MktoDrawable fromBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            return new MktoDrawable(bitmap);
        }
        return null;
    }

    public static Drawable fromDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            if (drawable2 instanceof MktoDrawable) {
                return drawable2;
            }
            if (drawable2 instanceof LayerDrawable) {
                LayerDrawable ld = (LayerDrawable)drawable2;
                int num = ld.getNumberOfLayers();
                for (int i = 0; i < num; ++i) {
                    Drawable d = ld.getDrawable(i);
                    ld.setDrawableByLayerId(ld.getId(i), MktoDrawable.fromDrawable(d));
                }
                return ld;
            }
            Bitmap bm = MktoDrawable.drawableToBitmap(drawable2);
            if (bm != null) {
                return new MktoDrawable(bm);
            }
        }
        return drawable2;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Bitmap bitmap;
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int width = Math.max(drawable2.getIntrinsicWidth(), 2);
        int height = Math.max(drawable2.getIntrinsicHeight(), 2);
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    public Bitmap getSourceBitmap() {
        return this.mBitmap;
    }

    public boolean isStateful() {
        return this.mBorderColor.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        int newColor = this.mBorderColor.getColorForState(state, 0);
        if (this.mBorderPaint.getColor() != newColor) {
            this.mBorderPaint.setColor(newColor);
            return true;
        }
        return super.onStateChange(state);
    }

    private void updateShaderMatrix() {
        switch (this.mScaleType) {
            case CENTER: {
                this.mBorderRect.set(this.mBounds);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.reset();
                this.mShaderMatrix.setTranslate((float)((int)((this.mBorderRect.width() - (float)this.mBitmapWidth) * 0.5f + 0.5f)), (float)((int)((this.mBorderRect.height() - (float)this.mBitmapHeight) * 0.5f + 0.5f)));
                break;
            }
            case CENTER_CROP: {
                float scale;
                this.mBorderRect.set(this.mBounds);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.reset();
                float dx = 0.0f;
                float dy = 0.0f;
                if ((float)this.mBitmapWidth * this.mBorderRect.height() > this.mBorderRect.width() * (float)this.mBitmapHeight) {
                    scale = this.mBorderRect.height() / (float)this.mBitmapHeight;
                    dx = (this.mBorderRect.width() - (float)this.mBitmapWidth * scale) * 0.5f;
                } else {
                    scale = this.mBorderRect.width() / (float)this.mBitmapWidth;
                    dy = (this.mBorderRect.height() - (float)this.mBitmapHeight * scale) * 0.5f;
                }
                this.mShaderMatrix.setScale(scale, scale);
                this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.mBorderWidth / 2.0f, (float)((int)(dy + 0.5f)) + this.mBorderWidth / 2.0f);
                break;
            }
            case CENTER_INSIDE: {
                this.mShaderMatrix.reset();
                float scale = (float)this.mBitmapWidth <= this.mBounds.width() && (float)this.mBitmapHeight <= this.mBounds.height() ? 1.0f : Math.min(this.mBounds.width() / (float)this.mBitmapWidth, this.mBounds.height() / (float)this.mBitmapHeight);
                float dx = (int)((this.mBounds.width() - (float)this.mBitmapWidth * scale) * 0.5f + 0.5f);
                float dy = (int)((this.mBounds.height() - (float)this.mBitmapHeight * scale) * 0.5f + 0.5f);
                this.mShaderMatrix.setScale(scale, scale);
                this.mShaderMatrix.postTranslate(dx, dy);
                this.mBorderRect.set(this.mBitmapRect);
                this.mShaderMatrix.mapRect(this.mBorderRect);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBorderRect, Matrix.ScaleToFit.FILL);
                break;
            }
            default: {
                this.mBorderRect.set(this.mBitmapRect);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBounds, Matrix.ScaleToFit.CENTER);
                this.mShaderMatrix.mapRect(this.mBorderRect);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBorderRect, Matrix.ScaleToFit.FILL);
                break;
            }
            case FIT_END: {
                this.mBorderRect.set(this.mBitmapRect);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBounds, Matrix.ScaleToFit.END);
                this.mShaderMatrix.mapRect(this.mBorderRect);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBorderRect, Matrix.ScaleToFit.FILL);
                break;
            }
            case FIT_START: {
                this.mBorderRect.set(this.mBitmapRect);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBounds, Matrix.ScaleToFit.START);
                this.mShaderMatrix.mapRect(this.mBorderRect);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBorderRect, Matrix.ScaleToFit.FILL);
                break;
            }
            case FIT_XY: {
                this.mBorderRect.set(this.mBounds);
                this.mBorderRect.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
                this.mShaderMatrix.reset();
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBorderRect, Matrix.ScaleToFit.FILL);
            }
        }
        this.mDrawableRect.set(this.mBorderRect);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mBounds.set(bounds);
        this.updateShaderMatrix();
    }

    public void draw(Canvas canvas) {
        if (this.mRebuildShader) {
            BitmapShader bitmapShader = new BitmapShader(this.mBitmap, this.mTileModeX, this.mTileModeY);
            if (this.mTileModeX == Shader.TileMode.CLAMP && this.mTileModeY == Shader.TileMode.CLAMP) {
                bitmapShader.setLocalMatrix(this.mShaderMatrix);
            }
            this.mBitmapPaint.setShader((Shader)bitmapShader);
            this.mRebuildShader = false;
        }
        if (this.mOval) {
            if (this.mBorderWidth > 0.0f) {
                canvas.drawOval(this.mDrawableRect, this.mBitmapPaint);
                canvas.drawOval(this.mBorderRect, this.mBorderPaint);
            } else {
                canvas.drawOval(this.mDrawableRect, this.mBitmapPaint);
            }
        } else if (MktoDrawable.any(this.mCornersRounded)) {
            float radius = this.mCornerRadius;
            if (this.mBorderWidth > 0.0f) {
                canvas.drawRoundRect(this.mDrawableRect, radius, radius, this.mBitmapPaint);
                canvas.drawRoundRect(this.mBorderRect, radius, radius, this.mBorderPaint);
                this.redrawBitmapForSquareCorners(canvas);
                this.redrawBorderForSquareCorners(canvas);
            } else {
                canvas.drawRoundRect(this.mDrawableRect, radius, radius, this.mBitmapPaint);
                this.redrawBitmapForSquareCorners(canvas);
            }
        } else {
            canvas.drawRect(this.mDrawableRect, this.mBitmapPaint);
            if (this.mBorderWidth > 0.0f) {
                canvas.drawRect(this.mBorderRect, this.mBorderPaint);
            }
        }
    }

    private void redrawBitmapForSquareCorners(Canvas canvas) {
        if (MktoDrawable.all(this.mCornersRounded)) {
            return;
        }
        if (this.mCornerRadius == 0.0f) {
            return;
        }
        float left = this.mDrawableRect.left;
        float top = this.mDrawableRect.top;
        float right = left + this.mDrawableRect.width();
        float bottom = top + this.mDrawableRect.height();
        float radius = this.mCornerRadius;
        if (!this.mCornersRounded[0]) {
            this.mSquareCornersRect.set(left, top, left + radius, top + radius);
            canvas.drawRect(this.mSquareCornersRect, this.mBitmapPaint);
        }
        if (!this.mCornersRounded[1]) {
            this.mSquareCornersRect.set(right - radius, top, right, radius);
            canvas.drawRect(this.mSquareCornersRect, this.mBitmapPaint);
        }
        if (!this.mCornersRounded[2]) {
            this.mSquareCornersRect.set(right - radius, bottom - radius, right, bottom);
            canvas.drawRect(this.mSquareCornersRect, this.mBitmapPaint);
        }
        if (!this.mCornersRounded[3]) {
            this.mSquareCornersRect.set(left, bottom - radius, left + radius, bottom);
            canvas.drawRect(this.mSquareCornersRect, this.mBitmapPaint);
        }
    }

    private void redrawBorderForSquareCorners(Canvas canvas) {
        if (MktoDrawable.all(this.mCornersRounded)) {
            return;
        }
        if (this.mCornerRadius == 0.0f) {
            return;
        }
        float left = this.mDrawableRect.left;
        float top = this.mDrawableRect.top;
        float right = left + this.mDrawableRect.width();
        float bottom = top + this.mDrawableRect.height();
        float radius = this.mCornerRadius;
        float offset = this.mBorderWidth / 2.0f;
        if (!this.mCornersRounded[0]) {
            canvas.drawLine(left - offset, top, left + radius, top, this.mBorderPaint);
            canvas.drawLine(left, top - offset, left, top + radius, this.mBorderPaint);
        }
        if (!this.mCornersRounded[1]) {
            canvas.drawLine(right - radius - offset, top, right, top, this.mBorderPaint);
            canvas.drawLine(right, top - offset, right, top + radius, this.mBorderPaint);
        }
        if (!this.mCornersRounded[2]) {
            canvas.drawLine(right - radius - offset, bottom, right + offset, bottom, this.mBorderPaint);
            canvas.drawLine(right, bottom - radius, right, bottom, this.mBorderPaint);
        }
        if (!this.mCornersRounded[3]) {
            canvas.drawLine(left - offset, bottom, left + radius, bottom, this.mBorderPaint);
            canvas.drawLine(left, bottom - radius, left, bottom, this.mBorderPaint);
        }
    }

    public int getOpacity() {
        return -3;
    }

    public int getAlpha() {
        return this.mBitmapPaint.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.mBitmapPaint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public ColorFilter getColorFilter() {
        return this.mBitmapPaint.getColorFilter();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mBitmapPaint.setColorFilter(cf);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        this.mBitmapPaint.setDither(dither);
        this.invalidateSelf();
    }

    public void setFilterBitmap(boolean filter) {
        this.mBitmapPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public float getCornerRadius(@Corner int corner) {
        return this.mCornersRounded[corner] ? this.mCornerRadius : 0.0f;
    }

    public MktoDrawable setCornerRadius(float radius) {
        this.setCornerRadius(radius, radius, radius, radius);
        return this;
    }

    public MktoDrawable setCornerRadius(@Corner int corner, float radius) {
        if (radius != 0.0f && this.mCornerRadius != 0.0f && this.mCornerRadius != radius) {
            throw new IllegalArgumentException("Multiple nonzero corner radii not yet supported.");
        }
        if (radius == 0.0f) {
            if (MktoDrawable.only(corner, this.mCornersRounded)) {
                this.mCornerRadius = 0.0f;
            }
            this.mCornersRounded[corner] = false;
        } else {
            if (this.mCornerRadius == 0.0f) {
                this.mCornerRadius = radius;
            }
            this.mCornersRounded[corner] = true;
        }
        return this;
    }

    public MktoDrawable setCornerRadius(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        HashSet<Float> radiusSet = new HashSet<Float>(4);
        radiusSet.add(Float.valueOf(topLeft));
        radiusSet.add(Float.valueOf(topRight));
        radiusSet.add(Float.valueOf(bottomRight));
        radiusSet.add(Float.valueOf(bottomLeft));
        radiusSet.remove(Float.valueOf(0.0f));
        if (radiusSet.size() > 1) {
            throw new IllegalArgumentException("Multiple nonzero corner radii not yet supported.");
        }
        if (!radiusSet.isEmpty()) {
            float radius = ((Float)radiusSet.iterator().next()).floatValue();
            if (Float.isInfinite(radius) || Float.isNaN(radius) || radius < 0.0f) {
                throw new IllegalArgumentException("Invalid radius value: " + radius);
            }
            this.mCornerRadius = radius;
        } else {
            this.mCornerRadius = 0.0f;
        }
        this.mCornersRounded[0] = topLeft > 0.0f;
        this.mCornersRounded[1] = topRight > 0.0f;
        this.mCornersRounded[2] = bottomRight > 0.0f;
        this.mCornersRounded[3] = bottomLeft > 0.0f;
        return this;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public MktoDrawable setBorderWidth(float width) {
        this.mBorderWidth = width;
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        return this;
    }

    public int getBorderColor() {
        return this.mBorderColor.getDefaultColor();
    }

    public MktoDrawable setBorderColor(int color2) {
        return this.setBorderColor(ColorStateList.valueOf((int)color2));
    }

    public ColorStateList getBorderColors() {
        return this.mBorderColor;
    }

    public MktoDrawable setBorderColor(ColorStateList colors) {
        this.mBorderColor = colors != null ? colors : ColorStateList.valueOf((int)0);
        this.mBorderPaint.setColor(this.mBorderColor.getColorForState(this.getState(), -16777216));
        return this;
    }

    public boolean isOval() {
        return this.mOval;
    }

    public MktoDrawable setOval(boolean oval) {
        this.mOval = oval;
        return this;
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public MktoDrawable setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.updateShaderMatrix();
        }
        return this;
    }

    public Shader.TileMode getTileModeX() {
        return this.mTileModeX;
    }

    public MktoDrawable setTileModeX(Shader.TileMode tileModeX) {
        if (this.mTileModeX != tileModeX) {
            this.mTileModeX = tileModeX;
            this.mRebuildShader = true;
            this.invalidateSelf();
        }
        return this;
    }

    public Shader.TileMode getTileModeY() {
        return this.mTileModeY;
    }

    public MktoDrawable setTileModeY(Shader.TileMode tileModeY) {
        if (this.mTileModeY != tileModeY) {
            this.mTileModeY = tileModeY;
            this.mRebuildShader = true;
            this.invalidateSelf();
        }
        return this;
    }

    private static boolean only(int index, boolean[] booleans) {
        int len = booleans.length;
        for (int i = 0; i < len; ++i) {
            if (booleans[i] == (i == index)) continue;
            return false;
        }
        return true;
    }

    private static boolean any(boolean[] booleans) {
        for (boolean b : booleans) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static boolean all(boolean[] booleans) {
        for (boolean b : booleans) {
            if (!b) continue;
            return false;
        }
        return true;
    }

    public Bitmap toBitmap() {
        return MktoDrawable.drawableToBitmap(this);
    }

    public static @interface Corner {
        public static final int TOP_LEFT = 0;
        public static final int TOP_RIGHT = 1;
        public static final int BOTTOM_RIGHT = 2;
        public static final int BOTTOM_LEFT = 3;
    }
}

