/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ScrollView;
import com.marketo.R;

public class InAppScrollView
extends ScrollView {
    private float layoutWidthFraction;
    private float layoutWidthProportion;

    public InAppScrollView(Context context) {
        this(context, null);
    }

    public InAppScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InAppScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.InAppScrollView, 0, 0);
        this.layoutWidthFraction = a.getFraction(R.styleable.InAppScrollView_layoutWidthPercent, 1, 1, 1.0f);
        this.layoutWidthProportion = a.getFraction(R.styleable.InAppScrollView_layoutWidthProportion, 1, 1, 0.0f);
        a.recycle();
        this.setFillViewport(false);
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        this.measureChildWithMargins(child, parentWidthMeasureSpec, 0, parentHeightMeasureSpec, 0);
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int widthProportionSize;
        int parentWidthSize = View.MeasureSpec.getSize((int)parentWidthMeasureSpec);
        int parentHeightSize = View.MeasureSpec.getSize((int)parentHeightMeasureSpec);
        int widthSize = (int)((float)parentWidthSize * this.layoutWidthFraction);
        if (this.layoutWidthProportion > 0.0f && widthSize > (widthProportionSize = (int)((float)parentHeightSize * this.layoutWidthProportion))) {
            widthSize = widthProportionSize;
        }
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)parentHeightMeasureSpec), (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        if (child.getMeasuredHeight() < parentHeightSize) {
            child.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)parentHeightSize, (int)0x40000000));
        }
    }
}

