/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class InAppLinearLayout
extends LinearLayout {
    private static final int MEASURED_SIZE_MASK = 0xFFFFFF;

    public InAppLinearLayout(Context context) {
        super(context);
    }

    public InAppLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @TargetApi(value=11)
    public InAppLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int totalLength = 0;
        int paddingStart = this.getPaddingLeft();
        int paddingEnd = this.getPaddingRight();
        int maxWidth = 0;
        int childState = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getChildCount();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean skippedMeasure = false;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            if (heightMode == 0x40000000 && lp.height == 0 && lp.weight > 0.0f) {
                totalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
                skippedMeasure = true;
            } else {
                int oldHeight = Integer.MIN_VALUE;
                if (lp.height == 0 && lp.weight > 0.0f) {
                    oldHeight = 0;
                    lp.height = -2;
                }
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, totalWeight == 0.0f ? totalLength : 0);
                if (oldHeight != Integer.MIN_VALUE) {
                    lp.height = oldHeight;
                }
                int childHeight = child.getMeasuredHeight();
                totalLength = Math.max(totalLength, totalLength + childHeight + lp.topMargin + lp.bottomMargin);
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            if (Build.VERSION.SDK_INT >= 11) {
                childState = InAppLinearLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            }
            boolean bl = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
                continue;
            }
            alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
        }
        int heightSize = totalLength;
        heightSize = Math.max(heightSize, this.getSuggestedMinimumHeight());
        int heightSizeAndState = this.resolveSizeAndStateCompat(heightSize, heightMeasureSpec, 0);
        heightSize = heightSizeAndState & 0xFFFFFF;
        if (skippedMeasure || heightSize > totalLength && totalWeight > 0.0f) {
            float weightSum = this.getWeightSum() > 0.0f ? this.getWeightSum() : totalWeight;
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                float childWeight = lp.weight;
                if (childWeight > 0.0f) {
                    int childWeighedHeight = (int)(childWeight * (float)heightSize / weightSum);
                    int childWidthMeasureSpec = InAppLinearLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(paddingStart + paddingEnd + lp.leftMargin + lp.rightMargin), (int)lp.width);
                    if (lp.height != 0 || heightMode != 0x40000000) {
                        int childHeight = Math.max(child.getMeasuredHeight(), childWeighedHeight);
                        if (childHeight < 0) {
                            childHeight = 0;
                        }
                        child.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
                    } else {
                        child.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(childWeighedHeight > 0 ? childWeighedHeight : 0), (int)0x40000000));
                    }
                    if (Build.VERSION.SDK_INT >= 11) {
                        childState = InAppLinearLayout.combineMeasuredStates((int)childState, (int)(child.getMeasuredState() & 0xFFFFFF00));
                    }
                }
                int margin = lp.leftMargin + lp.rightMargin;
                int measuredWidth = child.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp.width == -1;
            }
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += paddingStart + paddingEnd;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(this.resolveSizeAndStateCompat(maxWidth, widthMeasureSpec, childState), heightSizeAndState);
    }

    private int resolveSizeAndStateCompat(int size, int measureSpec, int childMeasuredSpec) {
        if (Build.VERSION.SDK_INT >= 11) {
            return InAppLinearLayout.resolveSizeAndState((int)size, (int)measureSpec, (int)childMeasuredSpec);
        }
        return InAppLinearLayout.resolveSize((int)size, (int)measureSpec);
    }
}

