/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import com.marketo.R;
import com.marketo.inapp.models.InAppCloseButton;
import java.util.EnumSet;

public class CloseButton
extends View {
    private static final EnumSet stylesWithPadding = EnumSet.of(InAppCloseButton.Style.STYLE1, InAppCloseButton.Style.STYLE2);
    private static final EnumSet stylesWithGradient = EnumSet.of(InAppCloseButton.Style.STYLE4, InAppCloseButton.Style.STYLE2);
    private static final EnumSet stylesWithCrossOnly = EnumSet.of(InAppCloseButton.Style.STYLE5);
    private InAppCloseButton.Style style;
    private int tint;
    private Paint backgroundPaint;
    private Paint circlePaint;
    private Paint crossPaint;
    private RectF backgroundBounds;
    private RectF circleBounds;
    private LinearGradient gradient;
    private float centerX;
    private float centerY;
    private float padding;
    private float crossSize;
    private float crossWidth;
    private int gradientStart;
    private int gradientEnd;

    public CloseButton(Context context) {
        this(context, null);
    }

    public CloseButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CloseButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.CloseButton, 0, 0);
        this.style = InAppCloseButton.Style.values()[a.getInt(R.styleable.CloseButton_close_button_style, 0)];
        this.tint = a.getColor(R.styleable.CloseButton_close_button_tint, -16777216);
        a.recycle();
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setAntiAlias(true);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.backgroundPaint.setColor(-1);
        this.circlePaint = new Paint();
        this.circlePaint.setAntiAlias(true);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.circlePaint.setColor(-12303292);
        this.crossPaint = new Paint();
        this.crossPaint.setAntiAlias(true);
        this.crossPaint.setStyle(Paint.Style.STROKE);
        this.crossPaint.setColor(-1);
        this.backgroundBounds = new RectF();
        this.circleBounds = new RectF();
        this.updateTint();
    }

    public InAppCloseButton.Style getStyle() {
        return this.style;
    }

    public void setStyle(InAppCloseButton.Style style2) {
        this.style = style2;
        this.invalidate();
    }

    public int getTint() {
        return this.tint;
    }

    public void setTint(int tint) {
        this.tint = tint;
        this.updateTint();
        this.invalidate();
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CloseButton.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CloseButton.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int spacingTop = this.getPaddingTop();
        int spacingBottom = this.getPaddingBottom();
        int spacingLeft = this.getPaddingLeft();
        int spacingRight = this.getPaddingRight();
        int size = Math.max(Math.min(width - spacingLeft - spacingRight, height - spacingTop - spacingBottom), 0);
        int radius = size / 2;
        this.centerX = spacingLeft + (width - spacingLeft - spacingRight) / 2;
        this.centerY = spacingTop + (height - spacingTop - spacingBottom) / 2;
        this.padding = stylesWithPadding.contains((Object)this.style) ? (float)size * 0.125f : 0.0f;
        this.crossSize = stylesWithCrossOnly.contains((Object)this.style) ? (float)size * 0.7f : (float)size * 0.5f;
        this.crossWidth = stylesWithCrossOnly.contains((Object)this.style) ? this.crossSize * 0.175f : this.crossSize * 0.125f;
        this.backgroundBounds.set(this.centerX - (float)radius, this.centerY - (float)radius, this.centerX + (float)radius, this.centerY + (float)radius);
        this.circleBounds.set(this.centerX - (float)radius + this.padding, this.centerY - (float)radius + this.padding, this.centerX + (float)radius - this.padding, this.centerY + (float)radius - this.padding);
        if (stylesWithGradient.contains((Object)this.style)) {
            this.gradient = new LinearGradient(0.0f, this.circleBounds.top, 0.0f, this.circleBounds.bottom, this.gradientStart, this.gradientEnd, Shader.TileMode.CLAMP);
        } else {
            this.gradient = null;
            this.circlePaint.setColor(this.tint);
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.padding > 0.0f) {
            canvas.drawArc(this.backgroundBounds, 0.0f, 360.0f, false, this.backgroundPaint);
        }
        if (!stylesWithCrossOnly.contains((Object)this.style)) {
            this.circlePaint.setShader((Shader)this.gradient);
            canvas.drawArc(this.circleBounds, 0.0f, 360.0f, false, this.circlePaint);
        }
        this.crossPaint.setStrokeWidth(this.crossWidth);
        if (stylesWithCrossOnly.contains((Object)this.style)) {
            this.crossPaint.setColor(this.tint);
        }
        canvas.save();
        canvas.rotate(45.0f, this.centerX, this.centerY);
        canvas.drawLine(this.centerX - this.crossSize / 2.0f, this.centerY, this.centerX + this.crossSize / 2.0f, this.centerY, this.crossPaint);
        canvas.drawLine(this.centerX, this.centerY - this.crossSize / 2.0f, this.centerX, this.centerY + this.crossSize / 2.0f, this.crossPaint);
        canvas.restore();
    }

    private void updateTint() {
        float hue = CloseButton.hue(this.tint);
        float saturation = CloseButton.saturation(this.tint);
        float brightness = Math.max(Math.min(CloseButton.brightness(this.tint), 0.85f), 0.15f);
        this.gradientStart = CloseButton.HSBtoColor(hue, saturation, brightness + 0.15f);
        this.gradientEnd = CloseButton.HSBtoColor(hue, saturation, brightness - 0.15f);
    }

    private static float hue(int color2) {
        float H;
        int temp;
        int b = color2 & 0xFF;
        int r = color2 >> 16 & 0xFF;
        int g = color2 >> 8 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        if (V == (temp = Math.min(b, Math.min(r, g)))) {
            H = 0.0f;
        } else {
            float vtemp = V - temp;
            float cr = (float)(V - r) / vtemp;
            float cg = (float)(V - g) / vtemp;
            float cb = (float)(V - b) / vtemp;
            H = r == V ? cb - cg : (g == V ? 2.0f + cr - cb : 4.0f + cg - cr);
            if ((H /= 6.0f) < 0.0f) {
                H += 1.0f;
            }
        }
        return H;
    }

    private static float saturation(int color2) {
        int temp;
        int b = color2 & 0xFF;
        int r = color2 >> 16 & 0xFF;
        int g = color2 >> 8 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        float S = V == (temp = Math.min(b, Math.min(r, g))) ? 0.0f : (float)(V - temp) / (float)V;
        return S;
    }

    private static float brightness(int color2) {
        int r = color2 >> 16 & 0xFF;
        int g = color2 >> 8 & 0xFF;
        int b = color2 & 0xFF;
        int V = Math.max(b, Math.max(r, g));
        return (float)V / 255.0f;
    }

    private static int HSBtoColor(float h, float s, float b) {
        h = Math.min(Math.max(h, 0.0f), 1.0f);
        s = Math.min(Math.max(s, 0.0f), 1.0f);
        b = Math.min(Math.max(b, 0.0f), 1.0f);
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float hf = (h - (float)((int)h)) * 6.0f;
        int ihf = (int)hf;
        float f = hf - (float)ihf;
        float pv = b * (1.0f - s);
        float qv = b * (1.0f - s * f);
        float tv = b * (1.0f - s * (1.0f - f));
        switch (ihf) {
            case 0: {
                red = b;
                green = tv;
                blue = pv;
                break;
            }
            case 1: {
                red = qv;
                green = b;
                blue = pv;
                break;
            }
            case 2: {
                red = pv;
                green = b;
                blue = tv;
                break;
            }
            case 3: {
                red = pv;
                green = qv;
                blue = b;
                break;
            }
            case 4: {
                red = tv;
                green = pv;
                blue = b;
                break;
            }
            case 5: {
                red = b;
                green = pv;
                blue = qv;
            }
        }
        return 0xFF000000 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }
}

