/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.models;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppText
implements Parcelable {
    private final String text;
    private int size;
    private final String color;
    private final String alignment;
    private final boolean italic;
    private final boolean bold;
    private final boolean underline;
    private final String action;
    public static final Parcelable.Creator<InAppText> CREATOR = new Parcelable.Creator<InAppText>(){

        public InAppText createFromParcel(Parcel source) {
            return new InAppText(source);
        }

        public InAppText[] newArray(int size) {
            return new InAppText[size];
        }
    };

    public InAppText(JSONObject textJsonObject) throws JSONException {
        this.text = textJsonObject.getString("text");
        this.size = textJsonObject.getInt("size");
        this.color = textJsonObject.getString("color");
        this.alignment = textJsonObject.getString("alignment");
        this.bold = textJsonObject.getBoolean("bold");
        this.italic = textJsonObject.getBoolean("italic");
        this.underline = textJsonObject.getBoolean("underline");
        this.action = textJsonObject.has("action") ? textJsonObject.getJSONObject("action").getString("android") : null;
    }

    public InAppText(Parcel source) {
        boolean[] arr = new boolean[]{false, false, false};
        this.size = source.readInt();
        this.text = source.readString();
        this.action = source.readString();
        this.color = source.readString();
        this.alignment = source.readString();
        source.readBooleanArray(arr);
        this.bold = arr[0];
        this.italic = arr[1];
        this.underline = arr[2];
    }

    public String getText() {
        return this.text;
    }

    public int getSize() {
        return this.size;
    }

    public String getColor() {
        return this.color;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public String getAction() {
        return this.action;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.size);
        dest.writeString(this.text);
        dest.writeString(this.action);
        dest.writeString(this.color);
        dest.writeString(this.alignment);
        dest.writeBooleanArray(new boolean[]{this.bold, this.italic, this.underline});
    }
}

