/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.marketo.Marketo;
import com.marketo.ab.MktoDataManager;
import com.marketo.errors.MktoException;
import com.marketo.inapp.controlers.InAppMessageView;
import com.marketo.inapp.models.InAppBackground;
import com.marketo.inapp.models.InAppButton;
import com.marketo.inapp.models.InAppCloseButton;
import com.marketo.inapp.models.InAppImage;
import com.marketo.inapp.models.InAppText;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import marketo.utils.MktoIOManager;
import org.json.JSONException;
import org.json.JSONObject;

public final class InAppMessage
implements Parcelable {
    public static final int ENABLED = 1;
    public static final int DISABLED = 0;
    public static final int PERMANENT_DISABLED = -1;
    public static final int PAUSED = 1;
    private static final int ACTIVE = 0;
    private int version;
    private String inAppJsonString;
    private String campaignId;
    private String endTime;
    private String startTime;
    private String displayTrigger;
    private Frequency displayFrequency;
    private InAppMessageView.LayoutType type;
    private Context context;
    private Status status;
    InAppBackground background;
    InAppImage inAppImage;
    InAppCloseButton closeButton;
    InAppText primaryText;
    InAppText secondaryText;
    InAppButton primaryButton;
    InAppButton secondaryButton;
    public static final Parcelable.Creator<InAppMessage> CREATOR = new Parcelable.Creator<InAppMessage>(){

        public InAppMessage createFromParcel(Parcel source) {
            InAppMessage inAppMessage = new InAppMessage();
            inAppMessage.version = source.readInt();
            inAppMessage.campaignId = source.readString();
            inAppMessage.displayTrigger = source.readString();
            inAppMessage.displayFrequency = Frequency.valueOf(source.readString());
            inAppMessage.endTime = source.readString();
            inAppMessage.startTime = source.readString();
            inAppMessage.type = InAppMessageView.LayoutType.valueOf(source.readString());
            inAppMessage.background = (InAppBackground)source.readParcelable(InAppBackground.class.getClassLoader());
            inAppMessage.inAppImage = (InAppImage)source.readParcelable(InAppImage.class.getClassLoader());
            inAppMessage.closeButton = (InAppCloseButton)source.readParcelable(InAppCloseButton.class.getClassLoader());
            inAppMessage.primaryButton = (InAppButton)source.readParcelable(InAppButton.class.getClassLoader());
            inAppMessage.secondaryButton = (InAppButton)source.readParcelable(InAppButton.class.getClassLoader());
            inAppMessage.primaryText = (InAppText)source.readParcelable(InAppText.class.getClassLoader());
            inAppMessage.secondaryText = (InAppText)source.readParcelable(InAppText.class.getClassLoader());
            return inAppMessage;
        }

        public InAppMessage[] newArray(int size) {
            return new InAppMessage[size];
        }
    };

    public InAppMessage() {
    }

    public InAppMessage(JSONObject inAppMessage, Context context) throws ParseException, JSONException {
        if (null != inAppMessage && inAppMessage.length() != 0 && context != null) {
            this.context = context;
            this.inAppJsonString = inAppMessage.toString();
            this.campaignId = inAppMessage.getString("cid");
            this.status = this.parseStatus(inAppMessage.getString("status"));
            this.setStatus(this.status);
            if (this.status == Status.ACTIVE) {
                this.version = inAppMessage.getInt("version");
                this.displayTrigger = inAppMessage.getString("display_trigger");
                this.displayFrequency = this.getDisplayFrequency(inAppMessage.getString("display_frequency"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.startTime = String.valueOf(sdf.parse(inAppMessage.getString("start_time")).getTime());
                this.endTime = String.valueOf(sdf.parse(inAppMessage.getString("end_time")).getTime());
                JSONObject layout2 = inAppMessage.getJSONObject("layout");
                this.type = this.getLayoutType(layout2.getString("type"));
                this.parseLayout(this.type, layout2);
            }
        }
    }

    private InAppMessageView.LayoutType getLayoutType(String layout2) throws JSONException {
        if (layout2.equalsIgnoreCase("layout1")) {
            return InAppMessageView.LayoutType.LAYOUT_1;
        }
        if (layout2.equalsIgnoreCase("layout2")) {
            return InAppMessageView.LayoutType.LAYOUT_2;
        }
        if (layout2.equalsIgnoreCase("layout3")) {
            return InAppMessageView.LayoutType.LAYOUT_3;
        }
        if (layout2.equalsIgnoreCase("layout4")) {
            return InAppMessageView.LayoutType.LAYOUT_4;
        }
        if (layout2.equalsIgnoreCase("layout5")) {
            return InAppMessageView.LayoutType.LAYOUT_5;
        }
        if (layout2.equalsIgnoreCase("layout6")) {
            return InAppMessageView.LayoutType.LAYOUT_6;
        }
        throw new JSONException("'layout type' having invalid values");
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public InAppMessageView.LayoutType getType() {
        return this.type;
    }

    public boolean isAssetsAvailable() {
        if (this.type == InAppMessageView.LayoutType.LAYOUT_1 || this.type == InAppMessageView.LayoutType.LAYOUT_2 || this.type == InAppMessageView.LayoutType.LAYOUT_3) {
            if (null == this.background) {
                return false;
            }
            if (!TextUtils.isEmpty((CharSequence)this.background.getUrl()) ? !this.checkIfFileAvailable(this.background.getUrl()) : TextUtils.isEmpty((CharSequence)this.background.getColor())) {
                return false;
            }
        }
        if (this.type == InAppMessageView.LayoutType.LAYOUT_1 || this.type == InAppMessageView.LayoutType.LAYOUT_2 || this.type == InAppMessageView.LayoutType.LAYOUT_4 || this.type == InAppMessageView.LayoutType.LAYOUT_5 || this.type == InAppMessageView.LayoutType.LAYOUT_6) {
            if (null == this.inAppImage) {
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)this.inAppImage.getUrl())) {
                return false;
            }
            if (!this.checkIfFileAvailable(this.inAppImage.getUrl())) {
                return false;
            }
        }
        if (null != this.primaryButton && !TextUtils.isEmpty((CharSequence)this.primaryButton.getUrl()) && !this.checkIfFileAvailable(this.primaryButton.getUrl())) {
            return false;
        }
        return null == this.secondaryButton || TextUtils.isEmpty((CharSequence)this.secondaryButton.getUrl()) || this.checkIfFileAvailable(this.secondaryButton.getUrl());
    }

    private boolean checkIfFileAvailable(String url) {
        return MktoIOManager.getIOManager(this.context.getPackageName()).isFileAvailable(url, this.campaignId);
    }

    private void parseLayout(InAppMessageView.LayoutType type, JSONObject layout2) throws JSONException {
        switch (type) {
            case LAYOUT_1: {
                this.background = this.setBackground(layout2);
                this.closeButton = this.setCloseButton(layout2);
                this.inAppImage = this.setImageView(layout2);
                this.primaryButton = this.setPrimaryButton(layout2);
                this.primaryText = this.setPrimaryText(layout2);
                this.secondaryText = this.setSecondaryText(layout2);
                break;
            }
            case LAYOUT_2: {
                this.background = this.setBackground(layout2);
                this.inAppImage = this.setImageView(layout2);
                this.closeButton = this.setCloseButton(layout2);
                this.primaryButton = this.setPrimaryButton(layout2);
                break;
            }
            case LAYOUT_3: {
                this.background = this.setBackground(layout2);
                this.closeButton = this.setCloseButton(layout2);
                this.primaryButton = this.setPrimaryButton(layout2);
                this.secondaryButton = this.setSecondaryButton(layout2);
                this.primaryText = this.setPrimaryText(layout2);
                this.secondaryText = this.setSecondaryText(layout2);
                break;
            }
            case LAYOUT_4: {
                this.background = this.setBackground(layout2);
                this.inAppImage = this.setImageView(layout2);
                this.closeButton = this.setCloseButton(layout2);
                break;
            }
            case LAYOUT_5: {
                this.background = this.setBackground(layout2);
                this.inAppImage = this.setImageView(layout2);
                this.closeButton = this.setCloseButton(layout2);
                this.primaryButton = this.setPrimaryButton(layout2);
                this.primaryText = this.setPrimaryText(layout2);
                this.secondaryText = this.setSecondaryText(layout2);
                break;
            }
            case LAYOUT_6: {
                this.background = this.setBackground(layout2);
                this.inAppImage = this.setImageView(layout2);
                this.closeButton = this.setCloseButton(layout2);
                this.primaryButton = this.setPrimaryButton(layout2);
                this.secondaryButton = this.setSecondaryButton(layout2);
                this.primaryText = this.setPrimaryText(layout2);
                this.secondaryText = this.setSecondaryText(layout2);
            }
        }
    }

    private Status parseStatus(String status) throws JSONException {
        if (status.equalsIgnoreCase("pause")) {
            return Status.PAUSE;
        }
        if (status.equalsIgnoreCase("stop")) {
            return Status.STOP;
        }
        if (status.equalsIgnoreCase("active")) {
            return Status.ACTIVE;
        }
        throw new JSONException("'status' having invalid values");
    }

    private void setStatus(Status status) {
        switch (status) {
            case PAUSE: {
                this.pauseInApp();
                break;
            }
            case STOP: {
                this.deleteInApp();
            }
        }
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public Frequency getDisplayFrequency(String displayFrequency) throws JSONException {
        if (displayFrequency.equals("once")) {
            return Frequency.ONCE;
        }
        if (displayFrequency.equals("everytime")) {
            return Frequency.EVERY_TIME;
        }
        if (displayFrequency.equals("once_per_session")) {
            return Frequency.ONCE_PER_SESSION;
        }
        if (displayFrequency.equals("everytime_until_cta")) {
            return Frequency.EVERY_TIME_UNTIL_ACTION;
        }
        if (displayFrequency.equals("once_per_session_until_cta")) {
            return Frequency.ONCE_PER_SESSION_UNTIL_ACTION;
        }
        throw new JSONException("'displayFrequency' having invalid values");
    }

    public synchronized void saveInAppMessageInDB() {
        if (null != this.context && null != this.displayFrequency && null != this.inAppJsonString && null != this.campaignId && null != this.displayTrigger && null != this.startTime && null != this.endTime) {
            MktoDataManager mktoDataManager = MktoDataManager.getSharedInstance(this.context);
            mktoDataManager.saveInAppMessage(this.inAppJsonString, this.campaignId, this.displayTrigger, this.startTime, this.endTime, 1, 0, this.displayFrequency.name());
        }
    }

    public void pauseInApp() {
        if (null != this.context) {
            MktoDataManager mktoDataManager = MktoDataManager.getSharedInstance(this.context);
            mktoDataManager.pauseInApp(this.campaignId);
        }
    }

    public void deleteInApp() {
        if (null != this.context) {
            MktoDataManager mktoDataManager = MktoDataManager.getSharedInstance(this.context);
            mktoDataManager.deleteInApp(this.campaignId);
            MktoIOManager.getIOManager(this.context.getPackageName()).clearAllFilesOfCampaign(this.campaignId);
        }
    }

    public void updateStateOnInAppAction() {
        if (null != this.context && (this.displayFrequency == Frequency.ONCE_PER_SESSION_UNTIL_ACTION || this.displayFrequency == Frequency.EVERY_TIME_UNTIL_ACTION)) {
            MktoDataManager mktoDataManager = MktoDataManager.getSharedInstance(this.context);
            mktoDataManager.markInAppPermanentDisable(this.campaignId);
            Marketo.updateInAppList(this.context);
        }
    }

    public void updateStateOnInAppShown() {
        if (null != this.context) {
            MktoDataManager mktoDataManager = MktoDataManager.getSharedInstance(this.context);
            if (this.displayFrequency == Frequency.ONCE_PER_SESSION_UNTIL_ACTION || this.displayFrequency == Frequency.ONCE_PER_SESSION) {
                mktoDataManager.markInAppDisable(this.campaignId);
            }
            if (this.displayFrequency == Frequency.ONCE) {
                mktoDataManager.markInAppPermanentDisable(this.campaignId);
            }
            Marketo.updateInAppList(this.context);
        }
    }

    public void fetchFiles() throws Exception, MktoException {
        JSONObject inAppMessage = new JSONObject(this.inAppJsonString);
        JSONObject layout2 = inAppMessage.getJSONObject("layout");
        if (!layout2.isNull("background")) {
            this.fetchFile(layout2.getJSONObject("background"));
        }
        if (!layout2.isNull("image")) {
            this.fetchFile(layout2.getJSONObject("image"));
        }
        if (!layout2.isNull("primary_button")) {
            this.fetchFile(layout2.getJSONObject("primary_button"));
        }
        if (!layout2.isNull("secondary_button")) {
            this.fetchFile(layout2.getJSONObject("secondary_button"));
        }
    }

    private void fetchFile(JSONObject jsonObject) throws Exception, MktoException {
        if (jsonObject != null) {
            String url = null;
            if (!jsonObject.isNull("uri")) {
                url = jsonObject.getString("uri");
            }
            if (null != url) {
                MktoIOManager.getIOManager(this.context.getPackageName()).getFileFromLocal(url, this.campaignId);
            }
        }
    }

    public boolean isBeforeEndDateRange() {
        if (null == this.endTime) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.endTime)) {
            return false;
        }
        Date endDate = new Date(Long.parseLong(this.endTime) * 1000L);
        Date date = new Date();
        return date.before(endDate);
    }

    public InAppBackground getBackground() {
        return this.background;
    }

    public InAppImage getInAppImage() {
        return this.inAppImage;
    }

    public InAppCloseButton getCloseButton() {
        return this.closeButton;
    }

    public InAppText getPrimaryText() {
        return this.primaryText;
    }

    public InAppButton getPrimaryButton() {
        return this.primaryButton;
    }

    public InAppText getSecondaryText() {
        return this.secondaryText;
    }

    public InAppButton getSecondaryButton() {
        return this.secondaryButton;
    }

    public Status getStatus() {
        return this.status;
    }

    private InAppBackground setBackground(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("background")) {
            return new InAppBackground(layout2.getJSONObject("background"));
        }
        return null;
    }

    private InAppImage setImageView(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("image")) {
            return new InAppImage(layout2.optJSONObject("image"));
        }
        return null;
    }

    private InAppCloseButton setCloseButton(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("close_button")) {
            return new InAppCloseButton(layout2.getJSONObject("close_button"));
        }
        return null;
    }

    private InAppButton setPrimaryButton(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("primary_button")) {
            return new InAppButton(layout2.optJSONObject("primary_button"));
        }
        return null;
    }

    private InAppButton setSecondaryButton(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("secondary_button")) {
            return new InAppButton(layout2.optJSONObject("secondary_button"));
        }
        return null;
    }

    private InAppText setPrimaryText(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("primary_text")) {
            return new InAppText(layout2.optJSONObject("primary_text"));
        }
        return null;
    }

    private InAppText setSecondaryText(JSONObject layout2) throws JSONException {
        if (!layout2.isNull("secondary_text")) {
            return new InAppText(layout2.optJSONObject("secondary_text"));
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.version);
        dest.writeString(this.campaignId);
        dest.writeString(this.displayTrigger);
        dest.writeString(this.displayFrequency.name());
        dest.writeString(this.endTime);
        dest.writeString(this.startTime);
        dest.writeString(this.type.name());
        dest.writeParcelable((Parcelable)this.background, 1);
        dest.writeParcelable((Parcelable)this.inAppImage, 1);
        dest.writeParcelable((Parcelable)this.closeButton, 1);
        dest.writeParcelable((Parcelable)this.primaryButton, 1);
        dest.writeParcelable((Parcelable)this.secondaryButton, 1);
        dest.writeParcelable((Parcelable)this.primaryText, 1);
        dest.writeParcelable((Parcelable)this.secondaryText, 1);
    }

    public static enum Status {
        PAUSE,
        ACTIVE,
        STOP;

    }

    public static enum Frequency {
        ONCE,
        EVERY_TIME,
        ONCE_PER_SESSION,
        EVERY_TIME_UNTIL_ACTION,
        ONCE_PER_SESSION_UNTIL_ACTION;

    }
}

