/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.models;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public final class InAppImage
implements Parcelable {
    private final String url;
    private final Scale scaleType;
    private final int margin;
    private final int radius;
    private final String borderColor;
    private final int borderWidth;
    private final String action;
    public static final Parcelable.Creator<InAppImage> CREATOR = new Parcelable.Creator<InAppImage>(){

        public InAppImage createFromParcel(Parcel source) {
            return new InAppImage(source);
        }

        public InAppImage[] newArray(int size) {
            return new InAppImage[size];
        }
    };

    public InAppImage(JSONObject imageViewJsonObject) throws JSONException {
        if (imageViewJsonObject.isNull("uri")) {
            throw new JSONException("'uri' is null for the image view");
        }
        this.url = imageViewJsonObject.getString("uri");
        this.scaleType = imageViewJsonObject.has("scale_type") ? this.parseScaleType(imageViewJsonObject.getString("scale_type")) : null;
        this.margin = imageViewJsonObject.getInt("margin");
        this.radius = imageViewJsonObject.getInt("radius");
        this.borderColor = imageViewJsonObject.getString("border_color");
        this.borderWidth = imageViewJsonObject.getInt("border_width");
        this.action = imageViewJsonObject.has("action") ? imageViewJsonObject.getJSONObject("action").getString("android") : null;
    }

    private Scale parseScaleType(String scale_type) throws JSONException {
        if (scale_type.equalsIgnoreCase("both")) {
            return Scale.BOTH;
        }
        if (scale_type.equalsIgnoreCase("height")) {
            return Scale.HEIGHT;
        }
        if (scale_type.equalsIgnoreCase("width")) {
            return Scale.WIDTH;
        }
        throw new JSONException("'scale_type' having invalid values");
    }

    public InAppImage(Parcel source) {
        this.url = source.readString();
        this.scaleType = Scale.valueOf(source.readString());
        this.borderColor = source.readString();
        this.action = source.readString();
        this.radius = source.readInt();
        this.margin = source.readInt();
        this.borderWidth = source.readInt();
    }

    public String getUrl() {
        return this.url;
    }

    public Scale getScaleType() {
        return this.scaleType;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public String getAction() {
        return this.action;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.url);
        if (null != this.scaleType) {
            dest.writeString(this.scaleType.name());
        } else {
            dest.writeString(null);
        }
        dest.writeString(this.borderColor);
        dest.writeString(this.action);
        dest.writeInt(this.radius);
        dest.writeInt(this.margin);
        dest.writeInt(this.borderWidth);
    }

    public static enum Scale {
        BOTH,
        WIDTH,
        HEIGHT;

    }
}

