/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.models;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public final class InAppCloseButton
implements Parcelable {
    private final Style style;
    private final String color;
    private final String action;
    private final String layoutAlignment;
    public static final Parcelable.Creator<InAppCloseButton> CREATOR = new Parcelable.Creator<InAppCloseButton>(){

        public InAppCloseButton createFromParcel(Parcel source) {
            return new InAppCloseButton(source);
        }

        public InAppCloseButton[] newArray(int size) {
            return new InAppCloseButton[size];
        }
    };

    public InAppCloseButton(JSONObject closeButtonJsonObject) throws JSONException {
        this.style = this.parseStyle(closeButtonJsonObject.getString("style"));
        this.color = closeButtonJsonObject.getString("color");
        this.action = closeButtonJsonObject.has("action") ? closeButtonJsonObject.getJSONObject("action").getString("android") : "";
        this.layoutAlignment = closeButtonJsonObject.getString("layout_alignment");
    }

    public InAppCloseButton(Parcel source) {
        this.layoutAlignment = source.readString();
        this.color = source.readString();
        this.action = source.readString();
        this.style = Style.valueOf(source.readString());
    }

    private Style parseStyle(String style2) throws JSONException {
        if (style2.equalsIgnoreCase("style1")) {
            return Style.STYLE1;
        }
        if (style2.equalsIgnoreCase("style2")) {
            return Style.STYLE2;
        }
        if (style2.equalsIgnoreCase("style3")) {
            return Style.STYLE3;
        }
        if (style2.equalsIgnoreCase("style4")) {
            return Style.STYLE4;
        }
        if (style2.equalsIgnoreCase("style5")) {
            return Style.STYLE5;
        }
        throw new JSONException("'style' having invalid values");
    }

    public Style getStyle() {
        return this.style;
    }

    public String getColor() {
        return this.color;
    }

    public String getAction() {
        return this.action;
    }

    public String getLayoutAlignment() {
        return this.layoutAlignment;
    }

    public boolean isBorder() {
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.layoutAlignment);
        dest.writeString(this.color);
        dest.writeString(this.action);
        dest.writeString(this.style.name());
    }

    public static enum Style {
        STYLE1,
        STYLE2,
        STYLE3,
        STYLE4,
        STYLE5;

    }
}

