/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.models;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppButton
implements Parcelable {
    public static final int DEFAULT_BORDERCOLOR = -1;
    public static final int DEFAULT_BORDERWIDTH = 2;
    public static final int DEFAULT_CORNER_RADIOUS = 12;
    private String color;
    private final boolean gradient;
    private final boolean border;
    private final String url;
    private final String text;
    private final String textColor;
    private final int size;
    private final Style style;
    private final boolean bold;
    private final boolean italic;
    private final boolean underline;
    private final String action;
    public static final Parcelable.Creator<InAppButton> CREATOR = new Parcelable.Creator<InAppButton>(){

        public InAppButton createFromParcel(Parcel source) {
            return new InAppButton(source);
        }

        public InAppButton[] newArray(int size) {
            return new InAppButton[size];
        }
    };

    public InAppButton(JSONObject buttonJSONObject) throws JSONException {
        if (buttonJSONObject.has("uri") && !buttonJSONObject.isNull("uri")) {
            this.url = buttonJSONObject.getString("uri");
            this.style = null;
            this.color = null;
            this.gradient = false;
            this.border = false;
        } else {
            this.url = null;
            this.style = this.parseStyle(buttonJSONObject.getString("style"));
            this.color = buttonJSONObject.getString("color");
            this.gradient = buttonJSONObject.getBoolean("gradient");
            this.border = buttonJSONObject.getBoolean("border");
        }
        this.text = buttonJSONObject.getString("text");
        this.size = buttonJSONObject.getInt("text_size");
        this.textColor = buttonJSONObject.getString("text_color");
        this.bold = buttonJSONObject.getBoolean("bold");
        this.italic = buttonJSONObject.getBoolean("italic");
        this.underline = buttonJSONObject.getBoolean("underline");
        this.action = buttonJSONObject.has("action") ? buttonJSONObject.getJSONObject("action").getString("android") : null;
    }

    public InAppButton(Parcel source) {
        boolean[] arr = new boolean[]{false, false, false, false, false};
        this.size = source.readInt();
        this.text = source.readString();
        this.color = source.readString();
        this.url = source.readString();
        this.textColor = source.readString();
        this.action = source.readString();
        String styleString = source.readString();
        this.style = styleString != null ? Style.valueOf(styleString) : null;
        source.readBooleanArray(arr);
        this.bold = arr[0];
        this.italic = arr[1];
        this.underline = arr[2];
        this.gradient = arr[3];
        this.border = arr[4];
    }

    public String getColor() {
        return this.color;
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public boolean isBorder() {
        return this.border;
    }

    public String getUrl() {
        return this.url;
    }

    public String getText() {
        return this.text;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public int getSize() {
        return this.size;
    }

    public Style getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public String getAction() {
        return this.action;
    }

    private Style parseStyle(String style2) throws JSONException {
        if (style2.equalsIgnoreCase("style1")) {
            return Style.STYLE1;
        }
        if (style2.equalsIgnoreCase("style2")) {
            return Style.STYLE2;
        }
        if (style2.equalsIgnoreCase("style3")) {
            return Style.STYLE3;
        }
        throw new JSONException("'style' having invalid values");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.size);
        dest.writeString(this.text);
        dest.writeString(this.color);
        dest.writeString(this.url);
        dest.writeString(this.textColor);
        dest.writeString(this.action);
        dest.writeString(this.style != null ? this.style.name() : null);
        dest.writeBooleanArray(new boolean[]{this.bold, this.italic, this.underline, this.gradient, this.border});
    }

    public static enum Style {
        STYLE1,
        STYLE2,
        STYLE3;

    }
}

