/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.models;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public final class InAppBackground
implements Parcelable {
    private final String url;
    private final String color;
    private final String action;
    private final String borderColor;
    private final int radius;
    private final int borderWidth;
    public static final Parcelable.Creator<InAppBackground> CREATOR = new Parcelable.Creator<InAppBackground>(){

        public InAppBackground createFromParcel(Parcel source) {
            return new InAppBackground(source);
        }

        public InAppBackground[] newArray(int size) {
            return new InAppBackground[size];
        }
    };

    public InAppBackground(JSONObject backgroundJsonObject) throws JSONException {
        if (!backgroundJsonObject.isNull("uri")) {
            this.url = backgroundJsonObject.getString("uri");
            this.color = null;
        } else {
            this.url = null;
            this.color = backgroundJsonObject.getString("color");
        }
        this.radius = backgroundJsonObject.getInt("radius");
        this.borderColor = backgroundJsonObject.getString("border_color");
        this.borderWidth = backgroundJsonObject.getInt("border_width");
        this.action = backgroundJsonObject.has("action") ? backgroundJsonObject.getJSONObject("action").getString("android") : null;
    }

    public InAppBackground(Parcel source) {
        this.url = source.readString();
        this.color = source.readString();
        this.borderColor = source.readString();
        this.action = source.readString();
        this.radius = source.readInt();
        this.borderWidth = source.readInt();
    }

    public String getUrl() {
        return this.url;
    }

    public String getColor() {
        return this.color;
    }

    public String getAction() {
        return this.action;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.url);
        dest.writeString(this.color);
        dest.writeString(this.borderColor);
        dest.writeString(this.action);
        dest.writeInt(this.radius);
        dest.writeInt(this.borderWidth);
    }
}

