/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.layout;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.marketo.R;
import com.marketo.errors.MktoException;
import com.marketo.inapp.controlers.InAppEventHandler;
import com.marketo.inapp.controlers.InAppMessageDialogFragment;
import com.marketo.inapp.controlers.InAppMessageView;
import com.marketo.inapp.models.InAppBackground;
import com.marketo.inapp.models.InAppButton;
import com.marketo.inapp.models.InAppCloseButton;
import com.marketo.inapp.models.InAppImage;
import com.marketo.inapp.models.InAppMessage;
import com.marketo.inapp.models.InAppText;
import com.marketo.inapp.views.CloseButton;
import com.marketo.inapp.views.MktoDrawable;
import com.marketo.inapp.views.ScalableImageView;
import java.io.File;
import marketo.utils.MktoIOManager;
import marketo.utils.MktoUtils;

public abstract class PrimaryLayout {
    protected final InAppMessage inAppMessage;
    private final InAppMessageDialogFragment inAppMessageDialogFragment;
    protected Context context;

    public PrimaryLayout(Context context, InAppMessageDialogFragment inAppMessageDialogFragment, InAppMessage inAppMessage) {
        this.context = context;
        this.inAppMessage = inAppMessage;
        this.inAppMessageDialogFragment = inAppMessageDialogFragment;
    }

    public abstract void setView(View var1);

    public abstract View setLayout(LayoutInflater var1);

    protected void setBackgroundView(View parent) {
        final View view = parent.findViewById(R.id.layout_background);
        final InAppBackground background = this.inAppMessage.getBackground();
        if (!TextUtils.isEmpty((CharSequence)background.getColor())) {
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setShape(0);
            gradientDrawable.setColor(Color.parseColor((String)background.getColor()));
            gradientDrawable.setCornerRadius(MktoUtils.dpToPx(background.getRadius()));
            gradientDrawable.setStroke(background.getBorderWidth(), Color.parseColor((String)background.getBorderColor()));
            if (Build.VERSION.SDK_INT >= 16) {
                view.setBackground((Drawable)gradientDrawable);
            } else {
                view.setBackgroundDrawable((Drawable)gradientDrawable);
            }
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)view.getLayoutParams();
            int borderWidth = background.getBorderWidth();
            lp.setMargins(borderWidth, borderWidth, borderWidth, borderWidth);
        }
        if (!TextUtils.isEmpty((CharSequence)background.getUrl())) {
            view.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Bitmap bitmap;
                        File file = MktoIOManager.getIOManager(PrimaryLayout.this.context.getPackageName()).getFileFromLocal(background.getUrl(), PrimaryLayout.this.inAppMessage.getCampaignId());
                        if (file != null && file.exists() && null != (bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath()))) {
                            MktoDrawable mktoDrawable = new MktoDrawable(bitmap);
                            mktoDrawable.setScaleType(ImageView.ScaleType.CENTER_CROP);
                            mktoDrawable.setBorderColor(Color.parseColor((String)background.getBorderColor()));
                            mktoDrawable.setBorderWidth(MktoUtils.dpToPx(background.getBorderWidth()));
                            mktoDrawable.setCornerRadius(MktoUtils.dpToPx(background.getRadius()));
                            if (Build.VERSION.SDK_INT >= 16) {
                                view.setBackground((Drawable)mktoDrawable);
                            } else {
                                view.setBackgroundDrawable((Drawable)mktoDrawable);
                            }
                        }
                    }
                    catch (Exception e) {
                        MktoUtils.writeError(e.getLocalizedMessage());
                    }
                    catch (MktoException e) {
                        MktoUtils.writeError(e.getMessage());
                    }
                }
            });
        }
        if (null != background.getAction()) {
            view.setOnClickListener((View.OnClickListener)new InAppEventHandler(background.getAction(), this.inAppMessage, this.inAppMessageDialogFragment));
        }
    }

    protected void setImageView(View view) {
        final ImageView imageView = (ImageView)view.findViewById(R.id.layout_image);
        final InAppImage inAppImage = this.inAppMessage.getInAppImage();
        int parentMargin = 0;
        if (null != this.inAppMessage.getBackground()) {
            parentMargin = (int)MktoUtils.dpToPx(this.inAppMessage.getBackground().getBorderWidth());
        }
        ViewGroup.MarginLayoutParams subViewLayoutParams = (ViewGroup.MarginLayoutParams)imageView.getLayoutParams();
        int margin = (int)MktoUtils.dpToPx(inAppImage.getMargin()) + parentMargin;
        subViewLayoutParams.setMargins(margin, margin, margin, 0);
        imageView.setLayoutParams((ViewGroup.LayoutParams)subViewLayoutParams);
        imageView.setBackgroundColor(0);
        if (null != inAppImage.getScaleType()) {
            if (imageView instanceof ScalableImageView) {
                ScalableImageView image = (ScalableImageView)imageView;
                image.setScale(inAppImage.getScaleType());
            } else {
                imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
        } else {
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        imageView.post(new Runnable(){

            @Override
            public void run() {
                try {
                    File file = MktoIOManager.getIOManager(PrimaryLayout.this.context.getPackageName()).getFileFromLocal(inAppImage.getUrl(), PrimaryLayout.this.inAppMessage.getCampaignId());
                    if (file != null && file.exists()) {
                        Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
                        if (null != bitmap) {
                            MktoDrawable mktoDrawable = new MktoDrawable(bitmap);
                            mktoDrawable.setScaleType(ImageView.ScaleType.CENTER_CROP);
                            mktoDrawable.setBorderColor(Color.parseColor((String)inAppImage.getBorderColor()));
                            mktoDrawable.setBorderWidth(inAppImage.getBorderWidth());
                            mktoDrawable.setCornerRadius(inAppImage.getRadius());
                            imageView.setImageDrawable((Drawable)mktoDrawable);
                        } else {
                            imageView.setImageDrawable(null);
                        }
                    }
                }
                catch (Exception e) {
                    MktoUtils.writeError(e.getMessage());
                }
                catch (MktoException e) {
                    MktoUtils.writeError(e.getMessage());
                }
            }
        });
        if (null != inAppImage.getAction()) {
            imageView.setOnClickListener((View.OnClickListener)new InAppEventHandler(inAppImage.getAction(), this.inAppMessage, this.inAppMessageDialogFragment));
        }
    }

    protected void setCloseButtonView(View view) {
        CloseButton closeButton = (CloseButton)view.findViewById(R.id.layout_close_button);
        closeButton.setLayoutParams(this.getLayoutParamsForClosebutton(closeButton));
        closeButton.setStyle(this.inAppMessage.getCloseButton().getStyle());
        closeButton.setTint(Color.parseColor((String)this.inAppMessage.getCloseButton().getColor()));
        closeButton.setOnClickListener(new InAppEventHandler(this.inAppMessage.getCloseButton().getAction(), this.inAppMessage, this.inAppMessageDialogFragment));
    }

    protected void setPrimaryTextView(View view) {
        TextView primaryTextView = (TextView)view.findViewById(R.id.layout_primary_text);
        this.setTextView(this.inAppMessage.getPrimaryText(), primaryTextView);
    }

    protected void setSecondaryTextView(View view) {
        TextView secondaryTextView = (TextView)view.findViewById(R.id.layout_secondary_text);
        this.setTextView(this.inAppMessage.getSecondaryText(), secondaryTextView);
    }

    private void setTextView(InAppText textViews, TextView textView) {
        if (textViews.getAlignment().equalsIgnoreCase("start")) {
            textView.setGravity(3);
        } else if (textViews.getAlignment().equalsIgnoreCase("center")) {
            textView.setGravity(17);
        } else if (textViews.getAlignment().equalsIgnoreCase("end")) {
            textView.setGravity(5);
        } else {
            textView.setGravity(17);
        }
        SpannableString spanString = new SpannableString((CharSequence)textViews.getText());
        if (textViews.isUnderline()) {
            spanString.setSpan((Object)new UnderlineSpan(), 0, spanString.length(), 0);
        }
        if (textViews.isBold()) {
            spanString.setSpan((Object)new StyleSpan(1), 0, spanString.length(), 0);
        }
        if (textViews.isItalic()) {
            spanString.setSpan((Object)new StyleSpan(2), 0, spanString.length(), 0);
        }
        textView.setText((CharSequence)spanString);
        textView.setTextSize((float)textViews.getSize());
        textView.setMaxLines(this.calculateTextViewLines(textViews.getSize()));
        textView.setTextColor(Color.parseColor((String)textViews.getColor()));
        if (null != textViews.getAction()) {
            textView.setOnClickListener((View.OnClickListener)new InAppEventHandler(textViews.getAction(), this.inAppMessage, this.inAppMessageDialogFragment));
        }
    }

    protected void setPrimaryButton(View view) {
        Button primaryButton = (Button)view.findViewById(R.id.layout_primary_button);
        this.setButton(this.inAppMessage.getPrimaryButton(), primaryButton);
    }

    protected void setSecondaryButton(View view) {
        Button secondaryButton = (Button)view.findViewById(R.id.layout_secondary_button);
        this.setButton(this.inAppMessage.getSecondaryButton(), secondaryButton);
    }

    private void setButton(final InAppButton buttons, final Button button) {
        SpannableString spanString = new SpannableString((CharSequence)buttons.getText());
        if (buttons.isUnderline()) {
            spanString.setSpan((Object)new UnderlineSpan(), 0, spanString.length(), 0);
        }
        if (buttons.isBold()) {
            spanString.setSpan((Object)new StyleSpan(1), 0, spanString.length(), 0);
        }
        if (buttons.isItalic()) {
            spanString.setSpan((Object)new StyleSpan(2), 0, spanString.length(), 0);
        }
        button.setText((CharSequence)spanString);
        button.setTextSize((float)buttons.getSize());
        button.setTextColor(Color.parseColor((String)buttons.getTextColor()));
        if (null != buttons.getAction()) {
            button.setOnClickListener((View.OnClickListener)new InAppEventHandler(buttons.getAction(), this.inAppMessage, this.inAppMessageDialogFragment));
        }
        if (null != buttons.getUrl()) {
            button.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Bitmap bitmap;
                        File file = MktoIOManager.getIOManager(PrimaryLayout.this.context.getPackageName()).getFileFromLocal(buttons.getUrl(), PrimaryLayout.this.inAppMessage.getCampaignId());
                        if (file != null && file.exists() && null != (bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath()))) {
                            MktoDrawable mktoDrawable = new MktoDrawable(bitmap);
                            if (Build.VERSION.SDK_INT >= 16) {
                                button.setBackground((Drawable)mktoDrawable);
                            } else {
                                button.setBackgroundDrawable((Drawable)mktoDrawable);
                            }
                        }
                    }
                    catch (Exception e) {
                        MktoUtils.writeError(e.getMessage());
                    }
                    catch (MktoException e) {
                        MktoUtils.writeError(e.getMessage());
                    }
                }
            });
        } else {
            LayerDrawable layerDrawable;
            GradientDrawable gd = new GradientDrawable();
            gd.setColor(Color.parseColor((String)buttons.getColor()));
            if (buttons.isBorder()) {
                gd.setStroke(2, -1);
            }
            this.setButtonStyle(gd, buttons);
            if (buttons.isGradient()) {
                GradientDrawable gradient = this.getGradient();
                this.setButtonStyle(gradient, buttons);
                layerDrawable = new LayerDrawable(new Drawable[]{gd, gradient});
            } else {
                layerDrawable = new LayerDrawable(new Drawable[]{gd});
            }
            if (Build.VERSION.SDK_INT >= 16) {
                button.setBackground((Drawable)layerDrawable);
            } else {
                button.setBackgroundDrawable((Drawable)layerDrawable);
            }
        }
    }

    public void setButtonStyle(GradientDrawable gd, InAppButton buttons) {
        switch (buttons.getStyle()) {
            case STYLE1: {
                gd.setCornerRadius(MktoUtils.dpToPx(0));
                break;
            }
            case STYLE2: {
                gd.setCornerRadius(MktoUtils.dpToPx(8));
                break;
            }
            case STYLE3: {
                gd.setCornerRadius(MktoUtils.dpToPx(28));
            }
        }
    }

    protected ViewGroup.LayoutParams getLayoutParamsForClosebutton(CloseButton closeButtonView) {
        RelativeLayout.LayoutParams closeImageViewLayoutParams = (RelativeLayout.LayoutParams)closeButtonView.getLayoutParams();
        InAppMessageView.LayoutType type = this.inAppMessage.getType();
        String alignment = this.inAppMessage.getCloseButton().getLayoutAlignment();
        if ((type == InAppMessageView.LayoutType.LAYOUT_1 || type == InAppMessageView.LayoutType.LAYOUT_2 || type == InAppMessageView.LayoutType.LAYOUT_3) && this.inAppMessage.getCloseButton().getStyle() == InAppCloseButton.Style.STYLE5) {
            if (alignment.equalsIgnoreCase("start")) {
                closeImageViewLayoutParams.addRule(this.resolveLayoutAlignCompat(5), R.id.layout_content);
                closeImageViewLayoutParams.addRule(6, R.id.layout_content);
            } else {
                closeImageViewLayoutParams.addRule(this.resolveLayoutAlignCompat(7), R.id.layout_content);
                closeImageViewLayoutParams.addRule(6, R.id.layout_content);
            }
            closeImageViewLayoutParams.setMargins(0, 0, 0, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                closeImageViewLayoutParams.setMarginEnd(0);
                closeImageViewLayoutParams.setMarginStart(0);
            }
        } else if (alignment.equalsIgnoreCase("start")) {
            closeImageViewLayoutParams.addRule(this.resolveLayoutAlignCompat(9));
            closeImageViewLayoutParams.addRule(10);
        } else {
            closeImageViewLayoutParams.addRule(this.resolveLayoutAlignCompat(11));
            closeImageViewLayoutParams.addRule(10);
        }
        return closeImageViewLayoutParams;
    }

    int resolveLayoutAlignCompat(int verb) {
        if (Build.VERSION.SDK_INT >= 19) {
            switch (verb) {
                case 5: {
                    return 18;
                }
                case 7: {
                    return 19;
                }
                case 9: {
                    return 20;
                }
                case 11: {
                    return 21;
                }
            }
        }
        return verb;
    }

    public GradientDrawable getGradient() {
        int[] colorArray = new int[]{this.context.getResources().getColor(R.color.gradient_start), this.context.getResources().getColor(R.color.gradient_end)};
        GradientDrawable gradient = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, colorArray);
        gradient.setGradientType(0);
        return gradient;
    }

    public int calculateTextViewLines(int textSize) {
        return textSize > 30 ? 1 : (textSize > 20 ? 2 : 3);
    }
}

