/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.inapp.controlers;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import com.marketo.ab.MktoDataManager;
import com.marketo.ab.MktoEventManager;
import com.marketo.inapp.controlers.InAppMessageDialogFragment;
import com.marketo.inapp.models.InAppMessage;
import marketo.utils.MktoUtils;

public class InAppEventHandler
implements View.OnClickListener {
    private final InAppMessageDialogFragment inAppMessageDialogFragment;
    private final InAppMessage inApp;
    String action;

    public InAppEventHandler(String action, InAppMessage inapp, InAppMessageDialogFragment inAppMessageDialogFragment) {
        this.action = action;
        this.inAppMessageDialogFragment = inAppMessageDialogFragment;
        this.inApp = inapp;
    }

    public void onClick(View v) {
        if (null == this.action && null == this.inAppMessageDialogFragment) {
            MktoUtils.writeError("Failed to perform Action because of null Value");
        } else {
            this.performAction(v);
        }
    }

    @TargetApi(value=12)
    private void performAction(View v) {
        try {
            if (!this.action.equalsIgnoreCase("close")) {
                if (!this.action.contains("://")) {
                    this.action = "http://" + this.action;
                }
                Intent launchBrowserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.action));
                launchBrowserIntent.setData(Uri.parse((String)this.action));
                if (launchBrowserIntent.resolveActivity(this.inAppMessageDialogFragment.getActivity().getPackageManager()) != null) {
                    this.inAppMessageDialogFragment.getActivity().startActivity(launchBrowserIntent);
                }
                this.inApp.updateStateOnInAppAction();
                MktoEventManager.getManager(null).inAppTapped(this.inApp.getCampaignId());
            }
        }
        catch (Exception ex) {
            MktoUtils.writeError("Failed to perform action received from In-App Message.");
        }
        finally {
            this.inAppMessageDialogFragment.dismissAllowingStateLoss();
        }
    }

    public static void updateInAppSession(Context mContext) {
        MktoDataManager mktoDataManager = MktoDataManager.getSharedInstance(mContext);
        mktoDataManager.updateAllInAppSession();
    }
}

