/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.ab;

import com.marketo.ab.MktoThread;
import com.marketo.base.MktoContants;

public class MktoOperation {
    static MktoThread eventLogger = new MktoThread("MktoEventLogger");
    static MktoThread eventReportor = new MktoThread("MktoEventReportor");
    static MktoThread inappLoader = new MktoThread("MktoInApp");
    private static MktoOperation operationManager = new MktoOperation();

    public static synchronized MktoOperation getInstance() {
        if (operationManager == null) {
            operationManager = new MktoOperation();
        }
        return operationManager;
    }

    static void runOnVesselThread(Runnable r, MktoThread mktoThread) {
        if (Thread.currentThread() != mktoThread) {
            mktoThread.post(r);
        } else {
            r.run();
        }
    }

    public static void runOnEventThread(Runnable runnable) {
        if (!MktoContants.isUnitTestApp) {
            if (Thread.currentThread() != eventLogger) {
                eventLogger.post(runnable);
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public static void runOnReportingThread(Runnable runnable) {
        if (!MktoContants.isUnitTestApp) {
            if (Thread.currentThread() != eventReportor) {
                eventReportor.post(runnable);
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public static void runOnInappLoaderThread(Runnable runnable) {
        if (!MktoContants.isUnitTestApp) {
            if (Thread.currentThread() != inappLoader) {
                inappLoader.post(runnable);
            } else {
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public static void runOnEventThread(Runnable runnable, long rUNNABLE_DELAY) {
        eventLogger.postDelayed(runnable, rUNNABLE_DELAY);
    }

    public static void excuteOp() {
        eventLogger.start();
    }

    static {
        eventLogger.start();
        eventReportor.start();
        inappLoader.start();
    }
}

