/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.ab;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.text.TextUtils;
import com.marketo.Marketo;
import com.marketo.ab.MktoDataManager;
import com.marketo.ab.MktoEventDecriptor;
import com.marketo.ab.MktoOperation;
import com.marketo.errors.MktoException;
import com.marketo.inapp.controlers.InAppEventHandler;
import com.marketo.inapp.controlers.InAppMessageDialogFragment;
import com.marketo.inapp.models.InAppMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import marketo.collector.MktoCollector;
import marketo.utils.MktoNetworkManager;
import marketo.utils.MktoUtils;
import org.json.JSONException;
import org.json.JSONObject;

public final class MktoEventManager {
    public static final String INIT_REPORTED = "mkto.reported";
    public static final String EVENT_INIT = "init";
    private static final String EVENT_CHECKPOINT = "checkpoint";
    private static final String EVENT_SESSION = "session";
    private static final String KEY_TYPE = "type";
    private static final String KEY_DEVICE = "device_state";
    private static final String KEY_NAME = "name";
    private static final String KEY_META = "metadata";
    private static final String KEY_PUSH_TOKEN = "push_token";
    private static final String KEY_PROJECT_ID = "gcm_project_number";
    private static final String KEY_CAMPAIGN_ID = "cid";
    private static final String KEY_INAPP_CAMPAIGN_ID = "campaign_id";
    private static final String KEY_SUBTYPE = "subtype";
    public static final String EVENT_PUSH = "push";
    private static final String EVENT_GCM_INIT = "init";
    private static final String EVENT_GCM_UNREGISTER = "unregister";
    private static final String EVENT_GCM_INVALID = "invalid_device";
    private static final String EVENT_GCM_OPENED = "opened";
    private static final String EVENT_GCM_DELIVERED = "delivered";
    public static final String EVENT_USER = "user";
    private static final String EVENT_UPDATE_TEST_DEVICE = "update_test_device";
    private static final String KEY_DEVICENAME = "name";
    private static final String EVENT_INAPP = "inapp";
    private static final String EVENT_INAPP_TAPPED = "tapped";
    private static final String EVENT_INAPP_SHOWN = "displayed";
    private static final String MKTO_INAPP_DIALOG_FRAGMENT_ID = "mkto_inapp_dialog";
    private static final long REPORT_DELAY = 300000L;
    private static MktoEventManager eventManager;
    final int RUNNABLE_DELAY = 2000;
    Context mContext;
    volatile boolean isReporting = false;
    boolean isDebugMode = false;
    private boolean isInAppShown = false;
    private long lastReportTime = 0L;
    private int totalActivities = 0;
    private ConcurrentHashMap<String, Long> sessions = new ConcurrentHashMap();

    public boolean isInAppShown() {
        return this.isInAppShown;
    }

    public void setInAppShown(boolean isInAppShown) {
        this.isInAppShown = isInAppShown;
    }

    public MktoEventManager(Context context) {
        this.mContext = context;
        this.isDebugMode = MktoUtils.isInDebugMode(context);
    }

    public static synchronized MktoEventManager getManager(Context context) {
        if (context != null && eventManager == null) {
            eventManager = new MktoEventManager(context);
        }
        return eventManager;
    }

    static JSONObject getPushSubType(long campaignId, String subType) throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(KEY_SUBTYPE, (Object)subType);
        obj.put(KEY_CAMPAIGN_ID, campaignId);
        return obj;
    }

    public void discardAllSession() {
        if (this.sessions != null && this.sessions.size() > 0) {
            this.sessions.clear();
        }
    }

    public void startSession(String sessonName) {
        if (TextUtils.isEmpty((CharSequence)sessonName) || this.sessions == null) {
            return;
        }
        if (this.sessions.contains(sessonName)) {
            MktoUtils.writeError(sessonName + " session already started.");
            return;
        }
        if (this.sessions.size() <= 500) {
            this.sessions.put(sessonName, System.nanoTime());
        } else {
            MktoUtils.writeError("Session threshold exceeded, unable to start this session.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession(String name, long endTime) {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            try {
                if (this.sessions != null && !this.sessions.isEmpty() && this.sessions.containsKey(name)) {
                    long startTime = this.sessions.get(name);
                    this.sessions.remove(name);
                    if (startTime > 0L) {
                        this.sessionEvent(name, startTime, endTime);
                    }
                } else {
                    MktoUtils.writeError("No session with name " + name + " in progress.");
                }
            }
            catch (Exception ex) {
                MktoUtils.writeError("Failed to save session time");
            }
            this.stopAppSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAppSesson() {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            try {
                if (this.sessions.containsKey("mkt_app_session")) {
                    return false;
                }
                MktoUtils.writeInfo("Starting app session");
                this.sessions.put("mkt_app_session", System.nanoTime());
                eventManager.reportAppOpened();
                return true;
            }
            catch (Exception e) {
                MktoUtils.writeError("Failed to start app session");
            }
        }
        return false;
    }

    public void stopAppSession() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (MktoEventManager.this.totalActivities <= 0 && MktoEventManager.this.sessions != null && !MktoEventManager.this.sessions.isEmpty() && MktoEventManager.this.sessions.containsKey("mkt_app_session")) {
                        long startTime = (Long)MktoEventManager.this.sessions.get("mkt_app_session");
                        MktoEventManager.this.sessions.remove("mkt_app_session");
                        if (startTime > 0L) {
                            MktoEventManager.this.sessionEvent("mkt_app_session", startTime, System.nanoTime());
                        }
                        MktoUtils.writeInfo("Ending app session");
                    }
                }
                catch (Exception ex) {
                    MktoUtils.writeError("Failed to save session time");
                }
            }
        };
        MktoOperation.runOnEventThread(runnable, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityStarted() {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            ++this.totalActivities;
            boolean started = this.startAppSesson();
            this.reportEvents(started);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityStoped() {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            --this.totalActivities;
            this.stopAppSession();
            this.reportEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAllSessions(final long endTime) {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hm = new HashMap(MktoEventManager.this.sessions);
                        MktoEventManager.this.sessions.clear();
                        MktoEventManager.this.saveSessions(hm, endTime);
                    }
                    catch (Exception ex) {
                        MktoUtils.writeError("Fail to save all sessions");
                    }
                }
            };
            MktoOperation.runOnEventThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSessions(HashMap<String, Long> sessions, long end) {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            if (sessions == null || sessions.isEmpty()) {
                return;
            }
            ArrayList<String> results = new ArrayList<String>(sessions.size());
            for (Map.Entry<String, Long> pairs : sessions.entrySet()) {
                JSONObject obj = this.sessionJSONEvent(pairs.getKey(), pairs.getValue(), end);
                if (obj == null) continue;
                results.add(obj.toString());
            }
            if (sessions.size() > 0) {
                MktoDataManager.getSharedInstance(this.mContext).saveEvents(results);
                this.reportEvents(false);
            }
        }
    }

    private JSONObject sessionJSONEvent(String sessionName, long start, long end) {
        try {
            long lapsedTime = end - start;
            long lapsedTimeInSeconds = TimeUnit.SECONDS.convert(lapsedTime, TimeUnit.NANOSECONDS);
            if (lapsedTimeInSeconds <= 0L) {
                return null;
            }
            JSONObject obj = this.getEventJSON(EVENT_SESSION);
            obj.put("name", (Object)sessionName);
            obj.put("duration", lapsedTimeInSeconds);
            obj.put(KEY_TYPE, (Object)"custom");
            return obj;
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create session JSON Object");
            return null;
        }
    }

    private void sessionEvent(String sessionName, long start, long end) {
        try {
            long lapsedTime = end - start;
            long lapsedTimeInSeconds = TimeUnit.SECONDS.convert(lapsedTime, TimeUnit.NANOSECONDS);
            if (lapsedTimeInSeconds <= 0L) {
                return;
            }
            JSONObject obj = this.getEventJSON(EVENT_SESSION);
            obj.put("name", (Object)sessionName);
            obj.put("duration", lapsedTimeInSeconds);
            obj.put(KEY_TYPE, (Object)"internal");
            this.saveEvent(obj.toString());
            this.reportEvents(false);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create session JSON Object");
        }
    }

    public void reportAppOpened() {
        InAppEventHandler.updateInAppSession(this.mContext);
        Marketo.updateInAppList(this.mContext);
        this.checkpointEvent("mkt_app_open", "internal", null);
        int app_open = MktoUtils.readPreferenceInt(this.mContext, "mkt_app_open", 0);
        MktoUtils.writePreference(this.mContext, "mkt_app_open", ++app_open);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCheckpoint(final String checkPointName, final JSONObject metaData) {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MktoEventManager.this.checkpointEvent(checkPointName, "custom", metaData);
                    MktoEventManager.this.reportEvents(false);
                }
            };
            MktoOperation.runOnEventThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAll() {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MktoEventManager.this.reportEvents(true);
                }
            };
            MktoOperation.runOnEventThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointEvent(String checkpoint, String event_type, JSONObject metaData) {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            try {
                JSONObject obj = this.getEventJSON(EVENT_CHECKPOINT);
                obj.put("name", (Object)checkpoint);
                if (metaData != null) {
                    obj.put(KEY_META, (Object)metaData);
                }
                obj.put(KEY_TYPE, (Object)event_type);
                this.saveEvent(obj.toString());
                this.checkToTriggerInAppMessage(obj.toString());
                if (event_type.equalsIgnoreCase("custom")) {
                    MktoUtils.writeInfo(checkpoint + " saved successfully.");
                }
            }
            catch (Exception e) {
                MktoUtils.writeError("Failed to create & save checkpoint");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getEventJSON(String eventType) throws JSONException {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            JSONObject obj = new JSONObject();
            obj.put("event_type", (Object)eventType);
            obj.put("timestamp", System.currentTimeMillis() / 1000L);
            return obj;
        }
    }

    private void checkToTriggerInAppMessage(String event) {
        if (!Marketo.isSDKInitalized() || this.isInAppShown()) {
            return;
        }
        try {
            InAppMessage inAppMessage;
            String event_name = new JSONObject(event).optString("name");
            MktoUtils.writeDebugLog("Got Event " + event_name + " as trigger. Checking for inAPP ");
            Marketo marketo = Marketo.getInstance(this.mContext);
            if (null != marketo.getTriggerableInAppMessages() && marketo.getTriggerableInAppMessages().containsKey(event_name) && null != (inAppMessage = marketo.getTriggerableInAppMessages().get(event_name))) {
                this.showInAppFragmentDialog(inAppMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MktoUtils.writeError("Failed to show the InAppMessage\n");
        }
    }

    @TargetApi(value=11)
    private void showInAppFragmentDialog(InAppMessage inAppMessage) {
        Marketo mInstance = Marketo.getInstance(this.mContext);
        Activity currentActivity = mInstance.getCurrentActivity();
        if (currentActivity != null) {
            FragmentTransaction ft = currentActivity.getFragmentManager().beginTransaction();
            Fragment prev = currentActivity.getFragmentManager().findFragmentByTag(MKTO_INAPP_DIALOG_FRAGMENT_ID);
            if (prev != null) {
                ft.remove(prev);
            }
            ft.addToBackStack(null);
            InAppMessageDialogFragment newFragment = InAppMessageDialogFragment.newInstance(inAppMessage);
            try {
                newFragment.show(ft, MKTO_INAPP_DIALOG_FRAGMENT_ID);
                inAppMessage.updateStateOnInAppShown();
                this.inAppShown(inAppMessage.getCampaignId());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void initEvent(JSONObject deviceDetails) {
        try {
            JSONObject obj = this.getEventJSON("init");
            obj.put(KEY_DEVICE, (Object)deviceDetails);
            MktoDataManager.getSharedInstance(this.mContext).saveEvent(obj.toString());
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create user JSON Object");
        }
    }

    public void updateTestDevicePushToken(String pushToken) {
        try {
            boolean isTestDevice = MktoUtils.readPreference(this.mContext, "mkto.testDevice", false);
            if (!isTestDevice) {
                return;
            }
            if (pushToken == null || pushToken.length() == 0) {
                MktoUtils.writeInfo("Updating test device push token is null or empty, not sending update_test_device event.");
                return;
            }
            JSONObject obj = this.getEventJSON(EVENT_UPDATE_TEST_DEVICE);
            obj.put(KEY_PUSH_TOKEN, (Object)pushToken);
            this.saveEvent(obj.toString());
            MktoUtils.writeInfo("Updating test device push token.");
        }
        catch (Exception e) {
            MktoUtils.writeError("failed to create user JSON Object");
        }
    }

    private String getDeviceName() {
        String device_name = MktoUtils.readPreference(this.mContext, "mkto.devicename");
        if (!TextUtils.isEmpty((CharSequence)device_name)) {
            return device_name;
        }
        return MktoUtils.getDeviceName().toString();
    }

    public void initPushEvent(String push_token, String senderId) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_PUSH);
            JSONObject subObject = new JSONObject();
            subObject.put(KEY_SUBTYPE, (Object)"init");
            subObject.put(KEY_PUSH_TOKEN, (Object)push_token);
            subObject.put(KEY_PROJECT_ID, (Object)senderId);
            obj.put(EVENT_PUSH, (Object)subObject);
            this.saveEvent(obj.toString());
            this.updateTestDevicePushToken(push_token);
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create user JSON Object");
        }
    }

    public void inAppShown(String campaignId) {
        try {
            this.setInAppShown(true);
            JSONObject obj = this.getEventJSON(EVENT_INAPP);
            JSONObject subObject = new JSONObject();
            subObject.put(KEY_SUBTYPE, (Object)EVENT_INAPP_SHOWN);
            subObject.put(KEY_CAMPAIGN_ID, (Object)campaignId);
            obj.put(EVENT_INAPP, (Object)subObject);
            this.saveEvent(obj.toString());
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create push JSON Object");
        }
    }

    public void inAppTapped(String campaignId) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_INAPP);
            JSONObject subObject = new JSONObject();
            subObject.put(KEY_SUBTYPE, (Object)EVENT_INAPP_TAPPED);
            subObject.put(KEY_CAMPAIGN_ID, (Object)campaignId);
            obj.put(EVENT_INAPP, (Object)subObject);
            this.saveEvent(obj.toString());
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create push open JSON Object");
        }
    }

    public void pushDelivered(long campaignId) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_PUSH);
            obj.put(EVENT_PUSH, (Object)MktoEventManager.getPushSubType(campaignId, EVENT_GCM_DELIVERED));
            this.saveEvent(obj.toString());
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create push JSON Object");
        }
    }

    public void pushTapped(long campaignId) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_PUSH);
            obj.put(EVENT_PUSH, (Object)MktoEventManager.getPushSubType(campaignId, EVENT_GCM_OPENED));
            this.saveEvent(obj.toString());
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create push open JSON Object");
        }
    }

    public void saveLead(JSONObject lead) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_USER);
            obj.put(EVENT_USER, (Object)lead);
            this.saveEvent(obj.toString());
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create push JSON Object");
        }
    }

    public void reportPushTapped(final long campaignId) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (campaignId <= 0L) {
                    MktoUtils.writeError("Invalid campaign id");
                    return;
                }
                MktoEventManager.this.pushTapped(campaignId);
            }
        };
        MktoOperation.runOnEventThread(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportEvents(final boolean shouldReport) {
        if (this.isReporting) {
            MktoUtils.writeDebugLog("data reporting already in progress.");
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MktoEventManager.this.isReporting = true;
                if (!Marketo.isSDKInitalized()) {
                    MktoUtils.writeError("Failed to report data, MarketoSDK is not initialized.");
                    MktoEventManager.this.isReporting = false;
                    return;
                }
                boolean isSecureModeEnabled = Marketo.isSecureModeEnabled();
                if (isSecureModeEnabled) {
                    String accessKey = MktoUtils.readPreference(MktoEventManager.this.mContext, "mkto.accessKey");
                    String signature = MktoUtils.readPreference(MktoEventManager.this.mContext, "mkto.signature");
                    String email = MktoUtils.readPreference(MktoEventManager.this.mContext, "mkto.email");
                    long timestamp = MktoUtils.readPreferenceLong(MktoEventManager.this.mContext, "mkto.timestamp", 0L);
                    if (!MktoUtils.isValidSecurityTokens(accessKey, signature, timestamp, email)) {
                        MktoUtils.writeError("App is in Secure mode but could not found valid Security Token , Please set valid Security Signature using setSecureSignature method.");
                        MktoEventManager.this.isReporting = false;
                        return;
                    }
                }
                if (!shouldReport) {
                    long delay = 300000L;
                    if (MktoEventManager.this.isDebugMode) {
                        delay /= 2L;
                    }
                    boolean reportNow = false;
                    if (MktoEventManager.this.lastReportTime < System.currentTimeMillis() - delay) {
                        reportNow = true;
                    }
                    if (!reportNow) {
                        MktoUtils.writeDebugLog("wait, it's too soon to report next batch of data");
                        MktoEventManager.this.isReporting = false;
                        return;
                    }
                }
                try {
                    MktoDataManager sharedInstance = MktoDataManager.getSharedInstance(MktoEventManager.this.mContext);
                    MktoEventDecriptor ed = sharedInstance.getAllEvents();
                    if (ed == null || ed.ids.length == 0) {
                        MktoUtils.writeDebugLog("No enough data to report");
                        MktoEventManager.this.isReporting = false;
                        return;
                    }
                    MktoUtils.writeDebugLog(ed.events);
                    JSONObject resp = MktoNetworkManager.postJSON(MktoEventManager.this.getReportEndPoint(), ed.events, MktoEventManager.this.mContext);
                    if (resp.optBoolean("success")) {
                        sharedInstance.clearEvents(ed.ids);
                    }
                    MktoEventManager.this.updateLastReportTime();
                    MktoUtils.writeInfo("Submitted all data successfully");
                }
                catch (MktoException e) {
                    MktoUtils.writeDebugLog("Failed to submit data");
                }
                catch (Exception e) {
                    MktoUtils.writeDebugLog("Failed to submit data");
                }
                finally {
                    MktoEventManager.this.isReporting = false;
                }
            }
        };
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            MktoOperation.runOnReportingThread(runnable);
        }
    }

    private String getReportEndPoint() throws UnsupportedEncodingException {
        boolean isSecureModeEnabled = Marketo.isSecureModeEnabled();
        if (isSecureModeEnabled) {
            String accessKey = MktoUtils.readPreference(this.mContext, "mkto.accessKey");
            String signature = MktoUtils.readPreference(this.mContext, "mkto.signature");
            String email = MktoUtils.readPreference(this.mContext, "mkto.email");
            long timestamp = MktoUtils.readPreferenceLong(this.mContext, "mkto.timestamp", 0L);
            String url = String.format("/report/events/?ak=%s&sign=%s&ts=%s&email=%s", accessKey, URLEncoder.encode(signature, "UTF-8"), timestamp, email);
            MktoUtils.writeDebugLog(url);
            return url;
        }
        return "/report/events/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastReportTime() {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            this.lastReportTime = System.currentTimeMillis();
            MktoUtils.writePreferenceLong(this.mContext, "last_report", this.lastReportTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEvent(String event) {
        MktoEventManager mktoEventManager = this;
        synchronized (mktoEventManager) {
            boolean isInitReported = MktoUtils.readPreference(this.mContext, INIT_REPORTED, false);
            if (!isInitReported) {
                eventManager.initEvent(MktoCollector.getProfile(this.mContext));
                MktoUtils.writePreference(this.mContext, INIT_REPORTED, true);
            }
            MktoDataManager.getSharedInstance(this.mContext).saveEvent(event);
        }
    }

    public void clearPushEvent(boolean isInternal) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_PUSH);
            JSONObject subObject = new JSONObject();
            subObject.put(KEY_TYPE, (Object)(isInternal ? "internal" : EVENT_USER));
            subObject.put(KEY_SUBTYPE, (Object)EVENT_GCM_UNREGISTER);
            obj.put(EVENT_PUSH, (Object)subObject);
            this.saveEvent(obj.toString());
            this.updateTestDevicePushToken("");
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create user JSON Object");
        }
    }

    public void clearInvalidPush(String uuid) {
        try {
            JSONObject obj = this.getEventJSON(EVENT_PUSH);
            JSONObject subObject = new JSONObject();
            subObject.put(KEY_SUBTYPE, (Object)EVENT_GCM_INVALID);
            subObject.put(EVENT_GCM_INVALID, (Object)uuid);
            obj.put(EVENT_PUSH, (Object)subObject);
            this.saveEvent(obj.toString());
            this.reportEvents(true);
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to create user JSON Object");
        }
    }

    public static enum EVENT_TYPE {
        EVENT_SCREEN_VISITED,
        EVENT_APP_OPEN;

    }
}

