/*
 * Decompiled with CFR 0.152.
 */
package com.marketo.ab;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import com.marketo.ab.MktoEventDecriptor;
import com.marketo.inapp.models.InAppMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import marketo.utils.MktoUtils;
import org.json.JSONObject;

public final class MktoDataManager {
    private static MktoDBHelper sInstance;
    private static MktoDataManager sManagerInstance;
    private Context context;
    private SQLiteDatabase database;
    private MktoDBHelper dbHelper;
    private String[] allEventColumns = new String[]{" _id ", "event"};

    MktoDataManager(Context context) {
        this.context = context;
        this.dbHelper = MktoDBHelper.getInstance(context);
    }

    public static synchronized MktoDataManager getSharedInstance(Context context) {
        if (sManagerInstance == null) {
            sManagerInstance = new MktoDataManager(context);
        }
        return sManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        MktoDataManager mktoDataManager = this;
        synchronized (mktoDataManager) {
            if (!(this.dbHelper == null || this.database != null && this.database.isOpen())) {
                this.database = this.dbHelper.getWritableDatabase();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        MktoDataManager mktoDataManager = this;
        synchronized (mktoDataManager) {
            if (this.dbHelper != null) {
                this.dbHelper.close();
            }
            if (this.database != null && this.database.isOpen()) {
                this.database.close();
                this.database = null;
            }
        }
    }

    public void cleanup() {
        this.open();
        if (this.database != null) {
            this.database.delete("vessel_events", null, null);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEvent(String eventJson) {
        MktoDataManager mktoDataManager = this;
        synchronized (mktoDataManager) {
            if (TextUtils.isEmpty((CharSequence)eventJson)) {
                return;
            }
            this.open();
            if (this.database != null) {
                ContentValues values = new ContentValues();
                values.put("event", eventJson);
                this.database.insert("vessel_events", null, values);
                this.checkThreshold(this.database, "vessel_events");
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreshold(SQLiteDatabase database, String abTable) {
        MktoDataManager mktoDataManager = this;
        synchronized (mktoDataManager) {
            try {
                database.beginTransaction();
                String[] idColumn = new String[]{" _id ", "event"};
                Cursor cursor = database.query(abTable, idColumn, null, null, null, null, null);
                if (cursor.getCount() > 500) {
                    cursor.moveToFirst();
                    int totalCount = cursor.getCount();
                    String deleteQuery = "DELETE from " + abTable + " where " + " _id " + "= ?";
                    SQLiteStatement deleteStmt = database.compileStatement(deleteQuery);
                    while (totalCount > 500 && !cursor.isAfterLast()) {
                        String event = cursor.getString(1);
                        JSONObject jsonObject = new JSONObject(event);
                        String event_type = jsonObject.optString("event_type", "");
                        if (!(TextUtils.isEmpty((CharSequence)event_type) || event_type.equalsIgnoreCase("push") || event_type.equalsIgnoreCase("init") || event_type.equalsIgnoreCase("user"))) {
                            deleteStmt.bindLong(1, cursor.getLong(0));
                            deleteStmt.execute();
                            --totalCount;
                        }
                        cursor.moveToNext();
                    }
                }
                cursor.close();
                database.setTransactionSuccessful();
            }
            catch (Exception e) {
                MktoUtils.writeError("Failed to close & save all session");
            }
            finally {
                if (database.inTransaction()) {
                    database.endTransaction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEvents(List<String> events) {
        try {
            if (events == null || events.size() == 0) {
                return;
            }
            this.open();
            String sql = "insert into vessel_events values($next_id, ?);";
            SQLiteStatement statment = this.database.compileStatement(sql);
            try {
                this.database.beginTransaction();
                for (String event : events) {
                    statment.bindString(1, event);
                    statment.executeInsert();
                }
                this.database.setTransactionSuccessful();
            }
            catch (Exception e) {
                MktoUtils.writeError("Failed to close & save all session");
            }
            finally {
                if (this.database.inTransaction()) {
                    this.database.endTransaction();
                }
            }
            this.checkThreshold(this.database, "vessel_events");
            this.close();
        }
        catch (Exception ex) {
            MktoUtils.writeError("Failed to save events in db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InAppMessage getAllTriggerbleInAppMessagesForEvent(String event) {
        InAppMessage inAppMessage = null;
        Cursor cursor = null;
        try {
            if (this.database == null) {
                InAppMessage inAppMessage2 = null;
                return inAppMessage2;
            }
            this.open();
            String query = "select * from mkto_inapp where mkto_is_enable == 1 AND mkto_is_paused == 0 AND mkto_inapp_trigger_event ==? AND datetime(mkto_inapp_endtime /1000,'unixepoch') > datetime('now')  AND datetime(mkto_inapp_start_at /1000,'unixepoch') < datetime('now') ORDER BY _id DESC LIMIT 1";
            cursor = this.database.rawQuery(query, new String[]{event});
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToFirst();
                int inAppIndex = cursor.getColumnIndex("inapp_msg");
                JSONObject inAppMessageObject = new JSONObject(cursor.getString(inAppIndex));
                inAppMessage = new InAppMessage(inAppMessageObject, this.context);
                cursor.close();
            }
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to fetch the InAppMessage for event " + event + " " + e.toString());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return inAppMessage;
    }

    public synchronized HashMap<String, InAppMessage> getAllTriggerbleInAppMessages() {
        HashMap<String, InAppMessage> inAppMessages = new HashMap<String, InAppMessage>();
        this.open();
        Cursor cursor = this.database.rawQuery("select DISTINCT mkto_inapp_trigger_event from mkto_inapp", new String[0]);
        if (null != cursor) {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                String event = cursor.getString(cursor.getColumnIndex("mkto_inapp_trigger_event"));
                InAppMessage inAppMessage = this.getAllTriggerbleInAppMessagesForEvent(event);
                if (null != inAppMessage && inAppMessage.isAssetsAvailable()) {
                    inAppMessages.put(event, inAppMessage);
                }
                cursor.moveToNext();
            }
            cursor.close();
        }
        this.close();
        return inAppMessages;
    }

    public synchronized MktoEventDecriptor getAllEvents() {
        this.open();
        if (this.database == null) {
            this.close();
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Cursor cursor = this.database.query("vessel_events", this.allEventColumns, null, null, null, null, null);
        cursor.moveToFirst();
        boolean first = true;
        ArrayList<String> ids = new ArrayList<String>();
        while (!cursor.isAfterLast()) {
            if (!first) {
                sb.append('\n');
            }
            sb.append(cursor.getString(1));
            ids.add(cursor.getString(0));
            first = false;
            cursor.moveToNext();
        }
        cursor.close();
        this.close();
        return new MktoEventDecriptor(sb.toString(), ids.toArray(new String[ids.size()]));
    }

    public synchronized void clearEvents() {
        this.open();
        if (this.database != null) {
            this.database.delete("vessel_events", null, null);
        }
        this.close();
    }

    public synchronized void clearEvents(String[] ids) {
        this.open();
        String sql = "delete from vessel_events where _id =?";
        SQLiteStatement statement = this.database.compileStatement(sql);
        for (String id : ids) {
            statement.bindString(1, id);
            statement.execute();
        }
        this.close();
    }

    public synchronized void deleteInApp(String campaignId) {
        this.open();
        int i = this.database.delete("mkto_inapp", "campaignId=?", new String[]{String.valueOf(campaignId)});
        this.close();
    }

    public synchronized void markInAppPermanentDisable(String campaignId) {
        this.open();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mkto_is_enable", Integer.valueOf(-1));
        this.database.update("mkto_inapp", contentValues, "campaignId=?", new String[]{String.valueOf(campaignId)});
        this.close();
    }

    public synchronized void markInAppDisable(String campaignId) {
        this.open();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mkto_is_enable", Integer.valueOf(0));
        this.database.update("mkto_inapp", contentValues, "campaignId=?", new String[]{String.valueOf(campaignId)});
        this.close();
    }

    public synchronized void pauseInApp(String campaignId) {
        this.open();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mkto_is_paused", Integer.valueOf(1));
        this.database.update("mkto_inapp", contentValues, "campaignId=?", new String[]{String.valueOf(campaignId)});
        this.close();
    }

    public synchronized void saveInAppMessage(String message, String campaignId, String TriggerEvent, String startTime, String endTime, int enabled, int paused, String frequency) {
        String query = String.format("INSERT OR REPLACE INTO mkto_inapp (inapp_msg, campaignId, mkto_inapp_start_at, mkto_inapp_trigger_event, mkto_is_enable, mkto_inapp_endtime, mkto_is_paused, mkto_inapp_frequency) VALUES (%s,'%s','%s','%s','%d','%s','%d','%s');", DatabaseUtils.sqlEscapeString((String)message), String.valueOf(campaignId), startTime, TriggerEvent, enabled, endTime, paused, frequency);
        this.open();
        this.database.execSQL(query);
        this.close();
    }

    public void updateAllInAppSession() {
        this.open();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mkto_is_enable", Integer.valueOf(1));
        this.database.update("mkto_inapp", contentValues, "mkto_is_enable!= -1 AND mkto_inapp_frequency= '" + InAppMessage.Frequency.ONCE_PER_SESSION_UNTIL_ACTION.name() + "' OR " + "mkto_inapp_frequency" + "= '" + InAppMessage.Frequency.ONCE_PER_SESSION.name() + "' ", new String[0]);
        this.close();
    }

    static class MktoDBHelper
    extends SQLiteOpenHelper {
        private static final int DATABASE_VERSION = 2;
        private static final String MARKETO_DB = "marketo";
        private static final String COLUMN_ID = " _id ";
        private static final String INAPP_MESSAGE_TABLE = "mkto_inapp";
        private static final String INAPP_MESSAGE = "inapp_msg";
        private static final String CAMPAIGN_ID_INAPP_MESSAGE = "campaignId";
        private static final String START_TIME = "mkto_inapp_start_at";
        private static final String TRIGGER_EVENT = "mkto_inapp_trigger_event";
        private static final String END_TIME = "mkto_inapp_endtime";
        private static final String IS_ENABLE = "mkto_is_enable";
        private static final String IS_PAUSED = "mkto_is_paused";
        private static final String FREQUENCY = "mkto_inapp_frequency";
        private static final String EVENT_TABLE = "vessel_events";
        private static final String EVENT_TEXT_COLUMN = "event";
        private static final int EVENT_THRESHOLD = 500;
        private static final String EVENT_TABLE_CREATE = "create table vessel_events( _id INTEGER PRIMARY KEY, event TEXT NOT NULL);";
        private static final String MKTO_INAPP_TABLE_CREATE = "CREATE TABLE IF NOT EXISTS mkto_inapp (_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, inapp_msg TEXT NOT NULL, campaignId TEXT NOT NULL unique, mkto_inapp_start_at TEXT NOT NULL, mkto_inapp_endtime TEXT NOT NULL, mkto_inapp_trigger_event TEXT NOT NULL, mkto_is_enable INTEGER NOT NULL, mkto_is_paused INTEGER NOT NULL, mkto_inapp_frequency TEXT NOT NULL);";

        public static synchronized MktoDBHelper getInstance(Context ctx) {
            if (sInstance == null) {
                sInstance = new MktoDBHelper(ctx.getApplicationContext());
            }
            return sInstance;
        }

        MktoDBHelper(Context context) {
            super(context, MARKETO_DB, null, 2);
        }

        public void onCreate(SQLiteDatabase database) {
            database.execSQL(EVENT_TABLE_CREATE);
            database.execSQL(MKTO_INAPP_TABLE_CREATE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (oldVersion != newVersion) {
                db.execSQL("DROP TABLE IF EXISTS vessel_events");
                db.execSQL("DROP TABLE IF EXISTS mkto_inapp");
                this.onCreate(db);
            }
        }
    }
}

