/*
 * Decompiled with CFR 0.152.
 */
package com.marketo;

import android.content.Context;
import android.text.TextUtils;
import com.google.firebase.messaging.RemoteMessage;
import com.marketo.ab.MktoEventManager;
import com.marketo.errors.MktoException;
import java.util.Map;
import marketo.push.MktoPushMessage;
import marketo.utils.MktoDeviceIdentifier;
import marketo.utils.MktoUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MarketoFirebaseMessagingService {
    private final Context context;

    MarketoFirebaseMessagingService(Context context) {
        this.context = context;
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map data;
        if (remoteMessage.getData().size() > 0 && (data = remoteMessage.getData()).containsKey("vs")) {
            MktoUtils.writeDebugLog("From :-" + remoteMessage.getFrom() + " Data :- " + (String)data.get("vs"));
            this.ShowNotification((String)data.get("vs"), this.context);
        }
    }

    public void onNewToken(String refreshedToken) {
        String senderId = MktoUtils.readPreference(this.context, "mkto.sender_id");
        if (!TextUtils.isEmpty((CharSequence)refreshedToken)) {
            MktoEventManager eventManager = MktoEventManager.getManager(this.context);
            eventManager.initPushEvent(refreshedToken, senderId);
            MktoUtils.writeInfo("Received a push token from FCM, registering device with Marketo");
            MktoUtils.writePreference(this.context, "mkto.push_token", refreshedToken);
        }
    }

    private void ShowNotification(String message, Context context) {
        try {
            if (TextUtils.isEmpty((CharSequence)message)) {
                return;
            }
            MktoUtils.writeInfo("Received a push notification.");
            JSONObject pushObject = new JSONObject(message);
            String pushUUID = pushObject.optString("uuid", "");
            if (!TextUtils.isEmpty((CharSequence)pushUUID) && !pushUUID.equalsIgnoreCase(MktoDeviceIdentifier.getOrCreateUUID(context))) {
                MktoUtils.writeError("Invalid Push notification");
                MktoEventManager.getManager(context).clearInvalidPush(pushUUID);
                return;
            }
            long campaignId = pushObject.optLong("cid");
            if (campaignId <= 0L) {
                MktoUtils.writeError("Failed to get campaign id from Marketo push message");
                return;
            }
            MktoUtils.writeInfo("Received a new campaign with id :" + campaignId);
            MktoEventManager.getManager(context).pushDelivered(campaignId);
            MktoPushMessage pushMessage = new MktoPushMessage(pushObject);
            pushMessage.showNotification(context, campaignId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            MktoUtils.writeError("Failed to unpack Marketo push message.");
        }
        catch (MktoException ex) {
            MktoUtils.writeError(ex.getMessage());
        }
    }
}

