/*
 * Decompiled with CFR 0.152.
 */
package com.marketo;

import android.graphics.Bitmap;
import marketo.utils.MktoUtils;

public class MarketoConfig {

    public static class SecureMode {
        private String accessKey;
        private String signature;
        private long timestamp;
        private String email;

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public boolean isValid() {
            return MktoUtils.isValidSecurityTokens(this.accessKey, this.signature, this.timestamp, this.email);
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSignature() {
            return this.signature;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public static class Notification {
        private Bitmap notificationLargeIcon;
        private int notificationSmallIcon = -1;

        public void setNotificationLargeIcon(Bitmap notificationLargeIcon) {
            if (notificationLargeIcon != null) {
                this.notificationLargeIcon = notificationLargeIcon;
            } else {
                MktoUtils.writeError("Invalid notification icon");
            }
        }

        public Bitmap getNotificationLargeIcon() {
            return this.notificationLargeIcon;
        }

        public void setNotificationSmallIcon(int notificationSmallIcon) {
            if (notificationSmallIcon > -1) {
                this.notificationSmallIcon = notificationSmallIcon;
            }
        }

        public int getNotificationSmallIcon() {
            return this.notificationSmallIcon;
        }
    }
}

