/*
 * Decompiled with CFR 0.152.
 */
package com.marketo;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import com.marketo.Marketo;
import com.marketo.ab.MktoEventManager;
import marketo.utils.MktoUtils;
import org.json.JSONObject;

public class MarketoActivity
extends Activity {
    private static final String ALERTMESSAGE = "Add this device as Test Device?";
    private static final String ALERTDIALOGHEADING = "Test Device";
    private static final String SECRET = "secret";
    private static final String TOKEN = "token";
    private static final String INVALID_INPUT = "Please enter valid device name";
    private static final String ERROR_DIALOG_TITLE = "Error";
    private static final String SUCCESS_DIALOG_TILE = "Success";
    private static final String SECRETE_KEY_MISMACH = "The URL does not match this application.";
    private static final String INVALID_URL = "The deeplink is invalid. Please try again...";
    private static final String PROGRESS_DIALOG_MESSAGE = "Adding device as a test device. Please wait...";
    private static final String DEVICE_ADDED_SUCCESSFULLY = "This device has been successfully registered.";
    private static final String SOMETHING_WENT_WRONG = "This device has already been registered, or the device name is already used.";
    private AlertDialog alt;
    private ProgressDialog dialog;
    private EditText editText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(0x1030011);
        Intent intent = this.getIntent();
        if (intent.hasExtra("mkto.campaignId")) {
            long campaignId = intent.getLongExtra("mkto.campaignId", 0L);
            MktoUtils.writeInfo("User tapped on campaign with id :" + campaignId);
            MktoEventManager.getManager(this.getApplicationContext()).reportPushTapped(campaignId);
            if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("mkto.primary"))) {
                this.performAction(intent.getStringExtra("mkto.primary"));
                MktoUtils.writeInfo("Push tapped, mkto.primary action selected");
            } else {
                try {
                    PackageManager manager = this.getApplication().getPackageManager();
                    Intent appIntent = manager.getLaunchIntentForPackage(this.getApplication().getPackageName());
                    this.startActivity(appIntent);
                }
                catch (Exception ex) {
                    MktoUtils.writeError("Failed to get launch action");
                }
                finally {
                    this.finish();
                }
            }
        } else {
            Uri data = intent.getData();
            this.checkDeeplink(data, savedInstanceState);
        }
    }

    private void performAction(String url) {
        try {
            if (url.startsWith("www")) {
                url = "http://" + url;
            }
            Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            i.setData(Uri.parse((String)url));
            this.startActivity(i);
        }
        catch (Exception ex) {
            MktoUtils.writeError("Failed to perform Action recived from push notification.");
        }
        finally {
            this.finish();
        }
    }

    private void checkDeeplink(Uri data, Bundle savedInstanceState) {
        if (data == null) {
            MktoUtils.writeError("Invalid or Null application context");
            this.finish();
        } else {
            MktoUtils.writeDebugLog("Deeplink uri is " + data);
            if (data.isHierarchical()) {
                String secret = data.getQueryParameter(SECRET);
                String token = data.getQueryParameter(TOKEN);
                if (!TextUtils.isEmpty((CharSequence)secret) && !TextUtils.isEmpty((CharSequence)token)) {
                    if (this.isAuthenticatedSecret(secret)) {
                        this.showAlertDialgForDeviceName(this.getDeviceName(savedInstanceState), token);
                    } else {
                        this.showDialogBox(ERROR_DIALOG_TITLE, SECRETE_KEY_MISMACH);
                    }
                } else {
                    this.showDialogBox(ERROR_DIALOG_TITLE, INVALID_URL);
                }
            } else {
                this.showDialogBox(ERROR_DIALOG_TITLE, INVALID_URL);
            }
        }
    }

    private boolean isAuthenticatedSecret(String urlSecretKey) {
        return urlSecretKey.equals(MktoUtils.readPreference((Context)this, "mkto.secretkey"));
    }

    private void showAlertDialgForDeviceName(String device_name, final String token) {
        AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
        alert.setTitle((CharSequence)ALERTDIALOGHEADING);
        alert.setMessage((CharSequence)ALERTMESSAGE);
        alert.setCancelable(false);
        this.editText = new EditText((Context)this);
        this.editText.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.editText.setText((CharSequence)device_name);
        alert.setView((View)this.editText);
        alert.setPositiveButton((CharSequence)"Yes", null);
        alert.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.cancel();
                MarketoActivity.this.finish();
            }
        });
        this.dismissAlertDialog();
        this.alt = alert.create();
        this.alt.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                Button b = MarketoActivity.this.alt.getButton(-1);
                b.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (!TextUtils.isEmpty((CharSequence)MarketoActivity.this.editText.getText().toString())) {
                            MarketoActivity.this.executeAsyncTask(MarketoActivity.this.editText.getText().toString(), token);
                        } else {
                            MarketoActivity.this.editText.setError((CharSequence)MarketoActivity.INVALID_INPUT);
                        }
                    }
                });
            }
        });
        this.alt.show();
    }

    private void executeAsyncTask(String deviceName, String token) {
        new AddDeviceAsyncTask(this).execute(new String[]{deviceName, token});
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.alt != null) {
            String name = "";
            this.dismissAlertDialog();
            if (this.editText != null) {
                name = this.editText.getText().toString();
            }
            outState.putString("device_name", name);
            if (this.dialog != null) {
                outState.putBoolean("is_request_in_queue", this.dialog.isShowing());
                this.dialog.dismiss();
                this.dialog.cancel();
                this.dialog = null;
            }
        }
    }

    private void displayProgressDialog() {
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setCancelable(false);
        this.dialog.setMessage((CharSequence)PROGRESS_DIALOG_MESSAGE);
        this.dialog.setProgressStyle(0);
        this.dialog.show();
    }

    private void dismissProgress() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    private void dismissAlertDialog() {
        if (null != this.alt) {
            this.alt.dismiss();
            this.alt = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.dismissAlertDialog();
        MktoEventManager.getManager((Context)this).setInAppShown(false);
    }

    private void showDialogBox(String title, String message) {
        AlertDialog.Builder alert = new AlertDialog.Builder((Context)this);
        alert.setTitle((CharSequence)title);
        alert.setMessage((CharSequence)message);
        alert.setCancelable(false);
        alert.setNegativeButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                MarketoActivity.this.dismissProgress();
                MarketoActivity.this.dismissAlertDialog();
                dialog.cancel();
                MarketoActivity.this.finish();
            }
        });
        this.dismissAlertDialog();
        this.alt = alert.create();
        this.alt.show();
    }

    public AlertDialog getLastDialog() {
        return this.alt;
    }

    public String getDeviceName(Bundle savedInstanceState) {
        String device_name;
        if (savedInstanceState != null && savedInstanceState.containsKey("device_name")) {
            device_name = savedInstanceState.getString("device_name");
        } else {
            device_name = MktoUtils.readPreference((Context)this, "mkto.devicename");
            if (TextUtils.isEmpty((CharSequence)device_name)) {
                device_name = (String)MktoUtils.getDeviceName();
            }
        }
        return device_name;
    }

    public class AddDeviceAsyncTask
    extends AsyncTask<String, String, String> {
        MarketoActivity activity;

        public AddDeviceAsyncTask(MarketoActivity activity) {
            this.activity = activity;
        }

        protected void onPreExecute() {
            this.activity.displayProgressDialog();
        }

        protected String doInBackground(String ... params) {
            return Marketo.addTestDevice(params[0], params[1]);
        }

        protected void onPostExecute(String result) {
            try {
                if (result != null && new JSONObject(result).optBoolean("success")) {
                    MarketoActivity.this.showDialogBox(MarketoActivity.SUCCESS_DIALOG_TILE, MarketoActivity.DEVICE_ADDED_SUCCESSFULLY);
                } else {
                    MarketoActivity.this.showDialogBox(MarketoActivity.ERROR_DIALOG_TITLE, MarketoActivity.SOMETHING_WENT_WRONG);
                }
            }
            catch (Exception e) {
                MarketoActivity.this.showDialogBox(MarketoActivity.ERROR_DIALOG_TITLE, MarketoActivity.SOMETHING_WENT_WRONG);
            }
        }
    }
}

