/*
 * Decompiled with CFR 0.152.
 */
package com.marketo;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.firebase.messaging.RemoteMessage;
import com.marketo.MarketoActionMetaData;
import com.marketo.MarketoConfig;
import com.marketo.MarketoFirebaseMessagingService;
import com.marketo.MarketoLead;
import com.marketo.ab.MktoDataManager;
import com.marketo.ab.MktoEventManager;
import com.marketo.ab.MktoOperation;
import com.marketo.errors.MktoException;
import com.marketo.inapp.models.InAppMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import marketo.collector.MktoCollector;
import marketo.push.MktoPushUtils;
import marketo.utils.MktoDeviceIdentifier;
import marketo.utils.MktoNetworkManager;
import marketo.utils.MktoUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Marketo {
    public static final String SDK_VERSION_CODE = "0.8.1";
    public static final int SDK_VERSION_INT = 7;
    public static final String SDK_VERSION = "MarketoSDK 0.8.1";
    private static final Object lock = new Object();
    private static long syncTimeOut = 3600L;
    private static int networkTimeout = 10000;
    private static Marketo sInstance;
    private volatile boolean isSyncing = false;
    private volatile boolean isAddingTestDevice = false;
    private MktoEventManager eventManager = null;
    private Context context;
    private String mktoAppSecret;
    private String customerMunchkinId;
    private MarketoConfig.Notification mktoConfig = null;
    private HashMap<String, InAppMessage> triggerableInAppMessages;
    private MarketoAppTracker appTracker;

    private Marketo(Context context) {
        this.context = context;
        this.eventManager = MktoEventManager.getManager(context);
        this.appTracker = new MarketoAppTracker(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Marketo getInstance(Context context) {
        if (context == null) {
            MktoUtils.writeError("Invalid or Null application context");
            return sInstance;
        }
        Object object = lock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new Marketo(context);
            }
        }
        return sInstance;
    }

    public static boolean isSDKInitalized() {
        return sInstance != null && !TextUtils.isEmpty((CharSequence)Marketo.sInstance.mktoAppSecret);
    }

    protected boolean isInitalized() {
        return Marketo.isSDKInitalized();
    }

    private MktoEventManager getManager(Context context) {
        if (this.eventManager != null) {
            return this.eventManager;
        }
        return MktoEventManager.getManager(context);
    }

    public static void setNetworkTimeout(int timeoutMilliseconds) {
        networkTimeout = timeoutMilliseconds;
    }

    public void setTriggerableInAppMessages(HashMap<String, InAppMessage> triggerableInAppMessages) {
        this.triggerableInAppMessages = new HashMap();
        this.triggerableInAppMessages.putAll(triggerableInAppMessages);
    }

    public HashMap<String, InAppMessage> getTriggerableInAppMessages() {
        return this.triggerableInAppMessages;
    }

    public void removeSecureSignature() {
        if (sInstance != null && Marketo.sInstance.context != null) {
            MktoUtils.clearPreference(Marketo.sInstance.context, "mkto.accessKey");
            MktoUtils.clearPreference(Marketo.sInstance.context, "mkto.signature");
            MktoUtils.clearPreference(Marketo.sInstance.context, "mkto.timestamp");
            MktoUtils.clearPreference(Marketo.sInstance.context, "mkto.email");
        } else {
            MktoUtils.writeError("Can not remove SecureSignature before MarketoSDK is initialized ");
        }
    }

    public static boolean isSecureModeEnabled() {
        boolean enabled = false;
        if (sInstance != null && Marketo.sInstance.context != null) {
            enabled = MktoUtils.readPreference(Marketo.sInstance.context, "mkto.smode", false);
        }
        return enabled;
    }

    public void setSecureSignature(MarketoConfig.SecureMode secureMode) {
        if (sInstance != null && Marketo.sInstance.context != null && MktoUtils.isValidSecurityTokens(secureMode.getAccessKey(), secureMode.getSignature(), secureMode.getTimestamp(), secureMode.getEmail())) {
            MktoUtils.writePreference(Marketo.sInstance.context, "mkto.accessKey", secureMode.getAccessKey());
            MktoUtils.writePreference(Marketo.sInstance.context, "mkto.signature", secureMode.getSignature());
            MktoUtils.writePreferenceLong(Marketo.sInstance.context, "mkto.timestamp", secureMode.getTimestamp());
            MktoUtils.writePreference(Marketo.sInstance.context, "mkto.email", secureMode.getEmail());
            this.getManager(Marketo.sInstance.context).reportEvents(true);
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized or invalid parameters");
        }
    }

    public String getDeviceId() {
        if (sInstance != null && Marketo.sInstance.context != null) {
            return MktoDeviceIdentifier.getOrCreateUUID(Marketo.sInstance.context);
        }
        MktoUtils.writeError("Can not get DeviceID before MarketoSDK is initialized.");
        return null;
    }

    public static int getNetworkTimeout() {
        return networkTimeout;
    }

    static String addTestDevice(String device_name, String token) {
        String returnString = null;
        if (!Marketo.isSDKInitalized()) {
            return returnString;
        }
        try {
            returnString = sInstance.addingTestDevice(device_name, token);
        }
        catch (Exception e) {
            MktoUtils.writeError("Error whiles starting app session");
        }
        return returnString;
    }

    public static void reportAction(String reportAction, MarketoActionMetaData metaData) {
        if (!TextUtils.isEmpty((CharSequence)reportAction) && sInstance != null && Marketo.sInstance.context != null) {
            sInstance.getManager(Marketo.sInstance.context).reportCheckpoint(reportAction, metaData);
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized or invalid checkpoint name");
        }
    }

    public static void reportAll() {
        if (sInstance != null && Marketo.sInstance.context != null) {
            sInstance.getManager(Marketo.sInstance.context).reportAll();
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized");
        }
    }

    private static void discardAllSessions() {
        if (sInstance != null && Marketo.sInstance.context != null) {
            sInstance.getManager(Marketo.sInstance.context).discardAllSession();
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized. Failed to discard sessions");
        }
    }

    private static void startSession(String sessonName) {
        if (!TextUtils.isEmpty((CharSequence)sessonName) && sInstance != null && Marketo.sInstance.context != null) {
            sInstance.getManager(Marketo.sInstance.context).startSession(sessonName);
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized or invalid session name.Failed to start session.");
        }
    }

    private static void endSession(final String sessionName) {
        if (!TextUtils.isEmpty((CharSequence)sessionName) && sInstance != null && Marketo.sInstance.context != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    sInstance.getManager(sInstance.context).endSession(sessionName, System.nanoTime());
                }
            };
            MktoOperation.runOnEventThread(runnable);
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized or invalid session name");
        }
    }

    private static void endAllSessions() {
        if (sInstance != null && Marketo.sInstance.context != null) {
            MktoEventManager.getManager(Marketo.sInstance.context).endAllSessions(System.nanoTime());
        } else {
            MktoUtils.writeError("MarketoSDK is not initialized");
        }
    }

    private boolean verifyConfiguration(Context context, String appSecretKey, String munchkinId) {
        if (TextUtils.isEmpty((CharSequence)appSecretKey) || TextUtils.isEmpty((CharSequence)munchkinId)) {
            MktoUtils.writeError("Invalid appSecretKey or munchkinId, failed to initialize.");
            return false;
        }
        if (appSecretKey.equalsIgnoreCase(this.mktoAppSecret) && munchkinId.equalsIgnoreCase(this.customerMunchkinId)) {
            MktoUtils.writeWarning("Already initalized.");
            return false;
        }
        String versionCode = MktoUtils.getAppVersionCode(context);
        boolean blocked = MktoUtils.checkIfIsBlocked(context, versionCode);
        if (blocked) {
            MktoUtils.writeError("Current version is blocked. Please contact support.");
            return false;
        }
        if (!MktoUtils.permissionLookup(context, "android.permission.INTERNET")) {
            MktoUtils.writeError("Please add android.permission.INTERNET in manifest file, failed to initialize MarketoSDK.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)versionCode)) {
            MktoUtils.writeError("Invalid versionCode, failed to initialize MarketoSDK.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSDK(final String munchkinId, final String appSecretKey) {
        Marketo marketo = this;
        synchronized (marketo) {
            if (this.context == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MktoUtils.writeInfo("Initializing MarketoSDK 0.8.1");
                    if (!Marketo.this.verifyConfiguration(Marketo.this.context, appSecretKey, munchkinId)) {
                        return;
                    }
                    Marketo.this.customerMunchkinId = munchkinId;
                    MktoUtils.writePreference(Marketo.this.context, "mkto.munchkinid", Marketo.this.customerMunchkinId);
                    String currentMunchkinWithAppKey = munchkinId + appSecretKey;
                    String versionCode = MktoUtils.getAppVersionCode(Marketo.this.context);
                    String prevVersionCode = MktoUtils.readPreference(Marketo.this.context, "version_code");
                    String prevMunchkinWithAppKey = MktoUtils.readPreference(Marketo.this.context, "mkto.munchkinid") + MktoUtils.readPreference(Marketo.this.context, "mkto.secretkey");
                    if (TextUtils.isEmpty((CharSequence)prevVersionCode) || !prevMunchkinWithAppKey.equalsIgnoreCase(currentMunchkinWithAppKey)) {
                        MktoUtils.clearPreference(Marketo.this.context, "mkto.secretkey");
                        MktoUtils.writePreferenceLong(Marketo.this.context, "mkto_install_date", MktoUtils.getDate());
                        MktoUtils.writePreference(Marketo.this.context, "mkto.newuser", true);
                        Marketo.this.getInAppMessagesForDevice(true, versionCode, appSecretKey);
                    } else if (!prevVersionCode.equalsIgnoreCase(versionCode)) {
                        MktoUtils.writePreference(Marketo.this.context, "mkto.newuser", false);
                        Marketo.this.getInAppMessagesForDevice(true, versionCode, appSecretKey);
                    } else {
                        MktoUtils.writePreference(Marketo.this.context, "mkto.newuser", false);
                        Marketo.this.getInAppMessagesForDevice(false, versionCode, appSecretKey);
                    }
                }
            };
            MktoOperation.runOnReportingThread(runnable);
        }
    }

    public void setNotificationConfig(MarketoConfig.Notification config) {
        if (config != null) {
            this.mktoConfig = config;
        } else {
            MktoUtils.writeError("Invalid configuration");
        }
    }

    public MarketoConfig.Notification getNotificationConfig() {
        return this.mktoConfig;
    }

    private String getInAppUrl(String secret_key) {
        long lst = MktoUtils.readPreferenceLong(this.context, "lst", 0L);
        return String.format("/api/v1/sync/%s?lst=%s", secret_key, lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInAppMessagesForDevice(boolean initizeSDK, String version_code, String secret_key) {
        if (this.context == null) {
            return;
        }
        Marketo marketo = this;
        synchronized (marketo) {
            if (initizeSDK) {
                try {
                    JSONObject init_result = MktoNetworkManager.getRequest(this.getInAppUrl(secret_key), this.context);
                    this.mktoAppSecret = secret_key;
                    this.parseResult(this.context, init_result);
                    MktoUtils.writePreference(this.context, "mkto.secretkey", secret_key);
                    this.LoadLatestInAppInMemory(this.context);
                    MktoUtils.writePreferenceLong(this.context, "mkto.lastSync", System.nanoTime());
                    MktoUtils.writePreference(this.context, "version_code", version_code);
                    MktoUtils.writeInfo("initialized MarketoSDK 0.8.1 successfully");
                }
                catch (MktoException e) {
                    this.cleanMarketoAppSecret();
                    MktoUtils.writeError("failed to initialize MarketoSDK 0.8.1 " + e.getMessage());
                }
                catch (Exception e) {
                    this.cleanMarketoAppSecret();
                    MktoUtils.writeError("failed to initialize MarketoSDK 0.8.1 " + e.getMessage());
                }
            } else {
                this.mktoAppSecret = secret_key;
                MktoUtils.writeInfo("initialized MarketoSDK 0.8.1 successfully");
                this.LoadLatestInAppInMemory(this.context);
            }
        }
    }

    public void cleanMarketoAppSecret() {
        this.mktoAppSecret = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfInAppMessageUpdateNeeded() {
        if (this.isSyncing) {
            return;
        }
        Marketo marketo = this;
        synchronized (marketo) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Marketo.this.isSyncing = true;
                    if (!Marketo.this.isSyncReady()) {
                        Marketo.this.isSyncing = false;
                        return;
                    }
                    if (!Marketo.isSDKInitalized()) {
                        Marketo.this.isSyncing = false;
                        return;
                    }
                    Marketo.this.updateSyncTime();
                    try {
                        MktoUtils.writeDebugLog("SYNCNOW:Syncing now for a new InApps");
                        String url = Marketo.this.getInAppUrl(MktoUtils.readPreference(Marketo.this.context, "mkto.secretkey"));
                        JSONObject init_result = MktoNetworkManager.getRequest(url, Marketo.this.context);
                        Marketo.this.parseResult(Marketo.this.context, init_result);
                        Marketo.this.LoadLatestInAppInMemory(Marketo.this.context);
                    }
                    catch (MktoException e) {
                        MktoUtils.writeError("Failed to update configuration " + e.getMessage());
                    }
                    finally {
                        MktoUtils.writeDebugLog("SYNCNOW:Done releasing lock");
                        Marketo.this.isSyncing = false;
                    }
                }
            };
            MktoOperation.runOnReportingThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSyncTime() {
        Marketo marketo = this;
        synchronized (marketo) {
            if (this.context != null) {
                MktoUtils.writePreferenceLong(this.context, "mkto.lastSync", System.nanoTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSyncReady() {
        Marketo marketo = this;
        synchronized (marketo) {
            if (MktoUtils.isInDebugMode(this.context)) {
                return true;
            }
            long lastSyncTime = MktoUtils.readPreferenceLong(this.context, "mkto.lastSync", 0L);
            if (lastSyncTime == 0L) {
                return true;
            }
            long currentTime = System.nanoTime();
            long lapsedTime = currentTime - lastSyncTime;
            long sec = TimeUnit.SECONDS.convert(lapsedTime, TimeUnit.NANOSECONDS);
            boolean bl = sec > MktoUtils.readPreferenceLong(this.context, "mkto.syncTimeOut", syncTimeOut);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addingTestDevice(String device_name, String token) {
        if (this.isAddingTestDevice) {
            return null;
        }
        Marketo marketo = this;
        synchronized (marketo) {
            String init_result = null;
            try {
                this.isAddingTestDevice = true;
                String url = this.getAddTestDeviceUrl(device_name, this.getPushToken(), token);
                MktoUtils.writeDebugLog("adding a new test device " + url);
                JSONObject resultString = MktoNetworkManager.getRequest(url, this.context);
                this.parseResult(this.context, resultString);
                MktoUtils.writePreference(this.context, "mkto.devicename", device_name);
                MktoUtils.writePreference(this.context, "mkto.testDevice", true);
                init_result = resultString.toString();
            }
            catch (MktoException e) {
                init_result = e.getMessage();
                MktoUtils.writeError("Failed to update configuration " + e.getMessage());
            }
            finally {
                MktoUtils.writeDebugLog("ADDING_TEST_DEVICE:Adding ended releasing lock");
                this.isAddingTestDevice = false;
            }
            return init_result;
        }
    }

    private String getPushToken() {
        String push_token = null;
        if (sInstance != null && Marketo.sInstance.context != null) {
            push_token = MktoUtils.readPreference(Marketo.sInstance.context, "mkto.push_token");
        }
        return push_token;
    }

    private String getAddTestDeviceUrl(String device_name, String push_token, String token) throws MktoException {
        Resources resources = Marketo.sInstance.context.getResources();
        Configuration config = resources.getConfiguration();
        String device_type = MktoCollector.getDeviceType(config);
        try {
            if (Marketo.isPushRegistered() && push_token != null) {
                return String.format("/api/v1/test_device?name=%s&token=%s&device_type=%s&push_token=%s", URLEncoder.encode(device_name, "UTF-8"), URLEncoder.encode(token, "UTF-8"), URLEncoder.encode(device_type, "UTF-8"), URLEncoder.encode(push_token, "UTF-8"));
            }
            return String.format("/api/v1/test_device?name=%s&token=%s&device_type=%s", URLEncoder.encode(device_name, "UTF-8"), URLEncoder.encode(token, "UTF-8"), URLEncoder.encode(device_type, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            MktoUtils.writeError("Unable to encode url");
            throw new MktoException("Error while encodeing url");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JSONObject parseResult(Context ctx, final JSONObject result) {
        if (result == null) {
            return null;
        }
        try {
            JSONArray inappArray;
            MktoUtils.checkBlockResponse(ctx, result);
            JSONObject config = result.optJSONObject("config");
            if (config != null) {
                long synTimeOut = config.optLong("syncTimeOut", syncTimeOut);
                MktoUtils.writePreferenceLong(ctx, "mkto.syncTimeOut", synTimeOut);
                boolean enableSecureMode = config.optBoolean("secure_mode");
                boolean isSecureModeOn = MktoUtils.readPreference(ctx, "mkto.smode", false);
                MktoUtils.writePreference(ctx, "mkto.smode", enableSecureMode);
                if (!isSecureModeOn && enableSecureMode) {
                    MktoUtils.writeInfo("Enabling a secure communication mode on this device.");
                }
                boolean isATestDevice = MktoUtils.readPreference(ctx, "mkto.testDevice", false);
                boolean enableTestDevice = config.optBoolean("test_device");
                MktoUtils.writePreference(ctx, "mkto.testDevice", enableTestDevice);
                if (!isATestDevice && enableTestDevice) {
                    MktoUtils.writeInfo("Enabling test device functionality on the device.");
                    this.eventManager.updateTestDevicePushToken(this.getPushToken());
                }
            }
            if (result.has("etag")) {
                MktoUtils.writePreference(this.context, "initETag", result.optString("etag"));
            }
            if (null != (inappArray = result.optJSONArray("inapp")) && inappArray.length() != 0) {
                MktoUtils.writelog("Received " + inappArray.length() + " inApps");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        for (int index = 0; index < inappArray.length(); ++index) {
                            JSONObject inAppJson = inappArray.optJSONObject(index);
                            if (null == inAppJson) continue;
                            try {
                                InAppMessage inAppMessage = new InAppMessage(inAppJson, Marketo.this.context);
                                if (!inAppMessage.isBeforeEndDateRange() || inAppMessage.getStatus() == InAppMessage.Status.STOP) continue;
                                inAppMessage.fetchFiles();
                                inAppMessage.saveInAppMessageInDB();
                                continue;
                            }
                            catch (JSONException e) {
                                MktoUtils.writeError("Failed to parse the response." + e.getMessage() + e.getLocalizedMessage());
                                continue;
                            }
                            catch (ParseException e) {
                                MktoUtils.writeError("Failed to parse the response." + e.getMessage() + e.getLocalizedMessage());
                                continue;
                            }
                            catch (UnsupportedEncodingException e) {
                                MktoUtils.writeError("UnsupportedEncodingException" + e.getMessage() + e.getLocalizedMessage());
                                continue;
                            }
                            catch (IOException e) {
                                MktoUtils.writeError("IOException" + e.getMessage() + e.getLocalizedMessage());
                                continue;
                            }
                            catch (Exception e) {
                                MktoUtils.writeError("Failed to parse the response." + e.getMessage() + e.getLocalizedMessage());
                                continue;
                            }
                            catch (MktoException e) {
                                MktoUtils.writeError(e.getMessage());
                            }
                        }
                        Marketo.updateInAppList(Marketo.this.context);
                        if (result.has("lst")) {
                            MktoUtils.writePreferenceLong(Marketo.this.context, "lst", result.optLong("lst", 0L));
                        }
                    }
                };
                Marketo marketo = this;
                synchronized (marketo) {
                    MktoOperation.runOnInappLoaderThread(runnable);
                }
            }
            return result.optJSONObject("response");
        }
        catch (Exception e) {
            MktoUtils.writeError("Failed to parse the response.");
            return null;
        }
    }

    private void LoadLatestInAppInMemory(Context context) {
        if (null != this.getTriggerableInAppMessages() && !this.getTriggerableInAppMessages().isEmpty()) {
            this.getTriggerableInAppMessages().clear();
        }
        this.setTriggerableInAppMessages(MktoDataManager.getSharedInstance(context).getAllTriggerbleInAppMessages());
    }

    private static void TrackNotificationTapIfInBackground(Intent intent, Context context) {
        Bundle bundle;
        if (null != intent && null != (bundle = intent.getExtras()) && bundle.containsKey("vs")) {
            try {
                JSONObject jsonObject = new JSONObject(bundle.getString("vs"));
                MktoEventManager.getManager(context).reportPushTapped(jsonObject.optLong("cid"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void initializeMarketoPush(String projectId, String channelName) {
        if (this.context == null) {
            MktoUtils.writeError("Failed to initialize Marketo push.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)projectId)) {
            MktoUtils.writeError("Invalid projectId");
            return;
        }
        if (Marketo.isPushRegistered()) {
            return;
        }
        MktoPushUtils.startPushService(this.context, channelName, projectId);
    }

    public void initializeMarketoPush(String projectId) {
        if (this.context == null) {
            MktoUtils.writeError("Failed to initialize Marketo push.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)projectId)) {
            MktoUtils.writeError("Invalid projectId");
            return;
        }
        if (Marketo.isPushRegistered()) {
            return;
        }
        MktoPushUtils.startPushService(this.context, "MKTO", projectId);
    }

    public void uninitializeMarketoPush() {
        if (this.context == null) {
            MktoUtils.writeError("Failed to initialize Marketo push.");
            return;
        }
        MktoUtils.writeInfo("Unregistered device from FCM");
        MktoUtils.clearPreference(this.context, "mkto.push_token");
        MktoEventManager.getManager(this.context).clearPushEvent(false);
    }

    public void setPushNotificationToken(String token) {
        new MarketoFirebaseMessagingService(this.context).onNewToken(token);
    }

    public void showPushNotification(RemoteMessage remoteMessage) {
        new MarketoFirebaseMessagingService(this.context).onMessageReceived(remoteMessage);
    }

    public static boolean isPushRegistered() {
        if (sInstance != null && Marketo.sInstance.context != null) {
            String chanelName = MktoUtils.readPreference(Marketo.sInstance.context, "mkto.channel_name");
            if (TextUtils.isEmpty((CharSequence)chanelName)) {
                return false;
            }
            String push_token = MktoUtils.readPreference(Marketo.sInstance.context, "mkto.push_token");
            if (!TextUtils.isEmpty((CharSequence)push_token)) {
                MktoUtils.writeInfo("Marketo push is active on this device.");
                return true;
            }
        }
        return false;
    }

    public void associateLead(final MarketoLead lead) {
        if (lead == null || this.context == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Marketo.this.getManager(Marketo.this.context).saveLead(lead);
            }
        };
        MktoOperation.runOnEventThread(runnable);
    }

    private void onStartOperation(final Activity activity) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MktoEventManager eventManager = Marketo.this.getManager((Context)activity);
                    eventManager.activityStarted();
                    Marketo.this.checkIfInAppMessageUpdateNeeded();
                }
            };
            MktoOperation.runOnEventThread(runnable);
        }
        catch (Exception e) {
            MktoUtils.writeError("Error whiles starting app session");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopOperation(final Activity activity) {
        try {
            Marketo marketo = this;
            synchronized (marketo) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MktoEventManager eventManager = Marketo.this.getManager((Context)activity);
                        eventManager.activityStoped();
                        Marketo.this.checkIfInAppMessageUpdateNeeded();
                    }
                };
                MktoOperation.runOnEventThread(runnable);
            }
        }
        catch (Exception e) {
            MktoUtils.writeError("Error whiles stopping app session");
        }
    }

    private static void onStop(Activity activity) {
        if (activity == null || sInstance == null || Marketo.sInstance.context == null) {
            MktoUtils.writeError("Marketo SDK not yet initialized");
            return;
        }
        sInstance.onStopOperation(activity);
    }

    private static void onStart(Activity activity) {
        if (activity == null || sInstance == null || Marketo.sInstance.context == null) {
            MktoUtils.writeError("Invalid activity or Marketo is not initialized yet");
            return;
        }
        sInstance.onStartOperation(activity);
    }

    public static void updateInAppList(Context context) {
        Marketo.getInstance(context).LoadLatestInAppInMemory(context);
    }

    public Activity getCurrentActivity() {
        return this.appTracker.getCurrentActivity();
    }

    public void setPhonegapCurrentActivity(Activity activity) {
        this.appTracker.setCurrentActivity(activity);
    }

    @TargetApi(value=14)
    public class MarketoAppTracker
    implements Application.ActivityLifecycleCallbacks {
        private static final String TAG = "MarketoAppTracker";
        private static final int MAX_TIME_BETWEEN_ACTIVITIES_MS = 100;
        private Activity currentActivity;

        MarketoAppTracker(Context context) {
            if (context != null) {
                Context appContext = context.getApplicationContext();
                try {
                    Application application = (Application)appContext;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                }
                catch (ClassCastException cce) {
                    MktoUtils.writeError("Failed to get Application from appContext");
                }
            }
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
            this.currentActivity = activity;
            Marketo.onStart(this.currentActivity);
            Marketo.TrackNotificationTapIfInBackground(activity.getIntent(), activity.getApplicationContext());
            MktoUtils.writeDebugLog("onActivityStarted - " + activity.getClass().getName());
        }

        public void onActivityResumed(Activity activity) {
            MktoUtils.writeDebugLog("onActivityResumed - " + activity.getClass().getName());
        }

        public void onActivityPaused(Activity activity) {
            MktoUtils.writeDebugLog("onActivityPaused - " + activity.getClass().getName());
            if (this.currentActivity != activity) {
                MktoUtils.writeDebugLog("How's this possible? some activity was paused but its not the same as current activity");
            }
            this.currentActivity = null;
        }

        public void onActivityStopped(Activity activity) {
            MktoUtils.writeDebugLog("onActivityStopped - " + activity.getClass().getName());
            Marketo.onStop(activity);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            MktoUtils.writeDebugLog("onActivitySaveInstance - " + activity.getClass().getName());
        }

        public void onActivityDestroyed(Activity activity) {
            MktoUtils.writeDebugLog("onActivityDestroyed - " + activity.getClass().getName());
        }

        Activity getCurrentActivity() {
            return this.currentActivity;
        }

        void setCurrentActivity(Activity activity) {
            if (this.currentActivity == null && null != activity) {
                this.currentActivity = activity;
            }
        }
    }
}

