/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import java.time.Duration;

public abstract class AbstractNonBlockCacheRateLimiter
implements RateLimiter {
    @Override
    public Rate consume(RateLimitProperties.Policy policy, String key, Long requestTime) {
        Duration refreshInterval = policy.getRefreshInterval();
        Long quota = policy.getQuota() != null ? Long.valueOf(policy.getQuota().toMillis()) : null;
        Rate rate = new Rate(key, policy.getLimit(), quota, null, null);
        this.calcRemainingLimit(policy.getLimit(), refreshInterval, requestTime, key, rate);
        this.calcRemainingQuota(quota, refreshInterval, requestTime, key, rate);
        return rate;
    }

    protected abstract void calcRemainingLimit(Long var1, Duration var2, Long var3, String var4, Rate var5);

    protected abstract void calcRemainingQuota(Long var1, Duration var2, Long var3, String var4, Rate var5);
}

