/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import javax.servlet.http.HttpServletRequest;

public class DefaultRateLimitUtils
implements RateLimitUtils {
    private static final String ANONYMOUS_USER = "anonymous";
    private final RateLimitProperties properties;

    @Override
    public String getUser(HttpServletRequest request) {
        return request.getRemoteUser() != null ? request.getRemoteUser() : ANONYMOUS_USER;
    }

    @Override
    public String getRemoteAddress(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (this.properties.isBehindProxy() && xForwardedFor != null) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }

    public DefaultRateLimitUtils(RateLimitProperties properties) {
        this.properties = properties;
    }
}

