/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractRateLimitFilter
extends ZuulFilter {
    private final RateLimitProperties properties;
    private final RouteLocator routeLocator;
    private final UrlPathHelper urlPathHelper;

    public boolean shouldFilter() {
        return this.properties.isEnabled() && !this.policy(this.route()).isEmpty();
    }

    Route route() {
        String requestURI = this.urlPathHelper.getPathWithinApplication(RequestContext.getCurrentContext().getRequest());
        return this.routeLocator.getMatchingRoute(requestURI);
    }

    protected List<RateLimitProperties.Policy> policy(Route route) {
        if (route != null) {
            return this.properties.getPolicies(route.getId());
        }
        return this.properties.getDefaultPolicyList();
    }

    @ConstructorProperties(value={"properties", "routeLocator", "urlPathHelper"})
    public AbstractRateLimitFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper) {
        this.properties = properties;
        this.routeLocator = routeLocator;
        this.urlPathHelper = urlPathHelper;
    }
}

