/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import androidx.annotation.Keep;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.shifter.CoordinateShifterManager;
import com.mapbox.geojson.utils.GeoJsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Keep
abstract class BaseCoordinatesTypeAdapter<T>
extends TypeAdapter<T> {
    BaseCoordinatesTypeAdapter() {
    }

    protected void writePoint(JsonWriter out, Point value) throws IOException {
        this.writePointList(out, (List<Double>)value.coordinates());
    }

    protected Point readPoint(JsonReader in) throws IOException {
        List<Double> coordinates = this.readPointList(in);
        if (coordinates != null && coordinates.size() > 1) {
            return new Point("Point", null, coordinates);
        }
        throw new GeoJsonException(" Point coordinates should be non-null double array");
    }

    protected void writePointList(JsonWriter out, List<Double> value) throws IOException {
        if (value == null) {
            return;
        }
        out.beginArray();
        List<Double> unshiftedCoordinates = CoordinateShifterManager.getCoordinateShifter().unshiftPoint(value);
        out.value(GeoJsonUtils.trim(unshiftedCoordinates.get(0)));
        out.value(GeoJsonUtils.trim(unshiftedCoordinates.get(1)));
        if (value.size() > 2) {
            out.value((Number)unshiftedCoordinates.get(2));
        }
        out.endArray();
    }

    protected List<Double> readPointList(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            throw new NullPointerException();
        }
        ArrayList<Double> coordinates = new ArrayList<Double>();
        in.beginArray();
        while (in.hasNext()) {
            coordinates.add(in.nextDouble());
        }
        in.endArray();
        if (coordinates.size() > 2) {
            return CoordinateShifterManager.getCoordinateShifter().shiftLonLatAlt((Double)coordinates.get(0), (Double)coordinates.get(1), (Double)coordinates.get(2));
        }
        return CoordinateShifterManager.getCoordinateShifter().shiftLonLat((Double)coordinates.get(0), (Double)coordinates.get(1));
    }
}

