/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.models.$AutoValue_StepManeuver;
import com.mapbox.api.directions.v5.models.AutoValue_StepManeuver;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import com.mapbox.geojson.Point;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@AutoValue
public abstract class StepManeuver
extends DirectionsJsonObject {
    public static final String TURN = "turn";
    public static final String NEW_NAME = "new name";
    public static final String DEPART = "depart";
    public static final String ARRIVE = "arrive";
    public static final String MERGE = "merge";
    public static final String ON_RAMP = "on ramp";
    public static final String OFF_RAMP = "off ramp";
    public static final String FORK = "fork";
    public static final String END_OF_ROAD = "end of road";
    public static final String CONTINUE = "continue";
    public static final String ROUNDABOUT = "roundabout";
    public static final String ROTARY = "rotary";
    public static final String ROUNDABOUT_TURN = "roundabout turn";
    public static final String NOTIFICATION = "notification";
    public static final String EXIT_ROUNDABOUT = "exit roundabout";
    public static final String EXIT_ROTARY = "exit rotary";

    public static Builder builder() {
        return new $AutoValue_StepManeuver.Builder();
    }

    @NonNull
    public Point location() {
        return Point.fromLngLat((double)this.rawLocation()[0], (double)this.rawLocation()[1]);
    }

    @SerializedName(value="location")
    @NonNull
    protected abstract double[] rawLocation();

    @SerializedName(value="bearing_before")
    @Nullable
    public abstract Double bearingBefore();

    @SerializedName(value="bearing_after")
    @Nullable
    public abstract Double bearingAfter();

    @Nullable
    public abstract String instruction();

    @Nullable
    public abstract String type();

    @Nullable
    public abstract String modifier();

    @Nullable
    public abstract Integer exit();

    public abstract Builder toBuilder();

    public static TypeAdapter<StepManeuver> typeAdapter(Gson gson) {
        return new AutoValue_StepManeuver.GsonTypeAdapter(gson);
    }

    public static StepManeuver fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        return (StepManeuver)gson.create().fromJson(json, StepManeuver.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder rawLocation(@NonNull double[] var1);

        public abstract Builder bearingBefore(@Nullable @FloatRange(from=0.0, to=360.0) Double var1);

        public abstract Builder bearingAfter(@Nullable @FloatRange(from=0.0, to=360.0) Double var1);

        public abstract Builder instruction(@Nullable String var1);

        public abstract Builder type(@Nullable String var1);

        public abstract Builder modifier(@Nullable String var1);

        public abstract Builder exit(@Nullable Integer var1);

        public abstract StepManeuver build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StepManeuverType {
    }
}

