/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.core.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

public final class TextUtils {
    private TextUtils() {
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        if (tokens == null || tokens.length < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String formatCoordinate(double coordinate) {
        DecimalFormat decimalFormat = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.US));
        return String.format(Locale.US, "%s", decimalFormat.format(coordinate));
    }

    public static String formatCoordinate(double coordinate, int precision) {
        String pattern = "0." + new String(new char[precision]).replace("\u0000", "0");
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        df.applyPattern(pattern);
        df.setRoundingMode(RoundingMode.FLOOR);
        return df.format(coordinate);
    }

    @Deprecated
    public static String formatRadiuses(double[] radiuses) {
        if (radiuses == null || radiuses.length == 0) {
            return null;
        }
        Object[] radiusesFormatted = new String[radiuses.length];
        for (int i = 0; i < radiuses.length; ++i) {
            radiusesFormatted[i] = radiuses[i] == Double.POSITIVE_INFINITY ? "unlimited" : String.format(Locale.US, "%s", TextUtils.formatCoordinate(radiuses[i]));
        }
        return TextUtils.join(";", radiusesFormatted);
    }

    @Deprecated
    public static String formatBearing(List<Double[]> bearings) {
        if (bearings.isEmpty()) {
            return null;
        }
        Object[] bearingFormatted = new String[bearings.size()];
        for (int i = 0; i < bearings.size(); ++i) {
            bearingFormatted[i] = bearings.get(i).length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(bearings.get(i)[0]), TextUtils.formatCoordinate(bearings.get(i)[1]));
        }
        return TextUtils.join(";", bearingFormatted);
    }

    @Deprecated
    public static String formatDistributions(List<Integer[]> distributions) {
        if (distributions.isEmpty()) {
            return null;
        }
        Object[] distributionsFormatted = new String[distributions.size()];
        for (int i = 0; i < distributions.size(); ++i) {
            distributionsFormatted[i] = distributions.get(i).length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(distributions.get(i)[0].intValue()), TextUtils.formatCoordinate(distributions.get(i)[1].intValue()));
        }
        return TextUtils.join(";", distributionsFormatted);
    }

    @Deprecated
    public static String formatApproaches(String[] approaches) {
        for (int i = 0; i < approaches.length; ++i) {
            if (approaches[i] == null) {
                approaches[i] = "";
                continue;
            }
            if (approaches[i].equals("unrestricted") || approaches[i].equals("curb") || approaches[i].isEmpty()) continue;
            return null;
        }
        return TextUtils.join(";", approaches);
    }

    @Deprecated
    public static String formatWaypointNames(String[] waypointNames) {
        for (int i = 0; i < waypointNames.length; ++i) {
            if (waypointNames[i] != null) continue;
            waypointNames[i] = "";
        }
        return TextUtils.join(";", waypointNames);
    }
}

