/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.core.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.core.constants.Constants;
import com.mapbox.core.utils.TextUtils;
import java.util.Locale;

public final class ApiCallHelper {
    private static final String ONLY_PRINTABLE_CHARS = "[^\\p{ASCII}]";

    private ApiCallHelper() {
    }

    public static String getHeaderUserAgent(@Nullable String clientAppName) {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        if (TextUtils.isEmpty(osName) || TextUtils.isEmpty(osVersion) || TextUtils.isEmpty(osArch)) {
            return Constants.HEADER_USER_AGENT;
        }
        return ApiCallHelper.getHeaderUserAgent(clientAppName, osName, osVersion, osArch);
    }

    public static String getHeaderUserAgent(@Nullable String clientAppName, @NonNull String osName, @NonNull String osVersion, @NonNull String osArch) {
        osName = osName.replaceAll(ONLY_PRINTABLE_CHARS, "");
        osVersion = osVersion.replaceAll(ONLY_PRINTABLE_CHARS, "");
        osArch = osArch.replaceAll(ONLY_PRINTABLE_CHARS, "");
        String baseUa = String.format(Locale.US, "%s %s/%s (%s)", Constants.HEADER_USER_AGENT, osName, osVersion, osArch);
        return TextUtils.isEmpty(clientAppName) ? baseUa : String.format(Locale.US, "%s %s", clientAppName, baseUa);
    }
}

