/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class MapboxService<T, S> {
    private final Class<S> serviceType;
    private boolean enableDebug;
    protected OkHttpClient okHttpClient;
    private Call.Factory callFactory;
    private Retrofit retrofit;
    private Call<T> call;
    private S service;

    public MapboxService(Class<S> serviceType) {
        this.serviceType = serviceType;
    }

    protected abstract String baseUrl();

    protected abstract Call<T> initializeCall();

    protected Call<T> getCall() {
        if (this.call == null) {
            this.call = this.initializeCall();
        }
        return this.call;
    }

    public Response<T> executeCall() throws IOException {
        return this.getCall().execute();
    }

    public void enqueueCall(Callback<T> callback) {
        this.getCall().enqueue(callback);
    }

    public void cancelCall() {
        this.getCall().cancel();
    }

    public Call<T> cloneCall() {
        return this.getCall().clone();
    }

    protected S getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.baseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create()));
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.retrofit = retrofitBuilder.build();
        this.service = this.retrofit.create(this.serviceType);
        return this.service;
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder();
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void enableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public Call.Factory getCallFactory() {
        return this.callFactory;
    }

    public void setCallFactory(Call.Factory callFactory) {
        this.callFactory = callFactory;
    }

    protected synchronized OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            if (this.isEnableDebug()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
                httpClient.addInterceptor((Interceptor)logging);
                this.okHttpClient = httpClient.build();
            } else {
                this.okHttpClient = new OkHttpClient();
            }
        }
        return this.okHttpClient;
    }
}

