/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.utils;

import com.mapbox.services.Constants;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class TextUtils {
    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String formatCoordinate(double coordinate) {
        DecimalFormat decimalFormat = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.US));
        return String.format(Constants.DEFAULT_LOCALE, "%s", decimalFormat.format(coordinate));
    }

    public static String formatCoordinate(double coordinate, int precision) {
        String pattern = "0." + new String(new char[precision]).replace("\u0000", "0");
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        df.applyPattern(pattern);
        df.setRoundingMode(RoundingMode.FLOOR);
        return df.format(coordinate);
    }
}

