/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.mapbox.android.telemetry.LogUtils;
import java.util.List;

public class AppStateUtils {
    private static final String TAG = "AppStateUtils";
    public static String PREFERENCE_FILENAME = "mb_app_state_utils";
    public static String KEY_LAST_KNOWN_ACTIVITY_STATE = "mb_telemetry_last_know_activity_state";

    public static void saveActivityState(@NonNull Context context, @NonNull ActivityState state) {
        SharedPreferences preferences = context.getSharedPreferences(PREFERENCE_FILENAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(KEY_LAST_KNOWN_ACTIVITY_STATE, state.getCode()).apply();
    }

    public static ActivityState getLastKnownActivityState(@NonNull Context context) {
        SharedPreferences preferences = context.getSharedPreferences(PREFERENCE_FILENAME, 0);
        int code = preferences.getInt(KEY_LAST_KNOWN_ACTIVITY_STATE, ActivityState.ACTIVITY_STATE_UNKNOWN.getCode());
        return ActivityState.fromCode(code);
    }

    private static AppState getAppStatePreLollipop(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return AppState.UNKNOWN;
        }
        String appPackageName = context.getApplicationContext().getPackageName();
        AppState state = AppState.UNKNOWN;
        int maxNumTasksToAsk = 32;
        List tasks = activityManager.getRunningTasks(32);
        for (ActivityManager.RunningTaskInfo task : tasks) {
            if (task.topActivity == null || !task.topActivity.getPackageName().equals(appPackageName)) continue;
            state = AppState.FOREGROUND;
        }
        if (tasks.size() < 32 && state == AppState.UNKNOWN) {
            state = AppState.BACKGROUND;
        }
        return state;
    }

    @RequiresApi(api=29)
    private static AppState getAppStateQAndHigher(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return AppState.UNKNOWN;
        }
        AppState state = AppState.BACKGROUND;
        List tasks = activityManager.getAppTasks();
        for (ActivityManager.AppTask task : tasks) {
            if (!task.getTaskInfo().isRunning) continue;
            state = AppState.FOREGROUND;
        }
        return state;
    }

    @RequiresApi(api=21)
    private static AppState getAppStateLollipopAndHigher(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return AppState.UNKNOWN;
        }
        AppState state = AppState.BACKGROUND;
        List tasks = activityManager.getAppTasks();
        for (ActivityManager.AppTask task : tasks) {
            if (task.getTaskInfo().id == -1) continue;
            state = AppState.FOREGROUND;
        }
        return state;
    }

    private static AppState getAppStateFromActivityManager(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return AppStateUtils.getAppStateQAndHigher(context);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return AppStateUtils.getAppStateLollipopAndHigher(context);
        }
        return AppStateUtils.getAppStatePreLollipop(context);
    }

    private static boolean isActivityInactive(ActivityState activityState) {
        switch (activityState) {
            case ACTIVITY_STATE_PAUSED: 
            case ACTIVITY_STATE_STOPPED: 
            case ACTIVITY_STATE_SAVE_INSTANCE_STATE: 
            case ACTIVITY_STATE_DESTROYED: {
                return true;
            }
        }
        return false;
    }

    private static AppState arbitrage(AppState stateFromActivityManager, ActivityState lastKnownActivityState) {
        LogUtils.v(TAG, "stateFromActivityManager = " + (Object)((Object)stateFromActivityManager) + ", lastKnowActivityState = " + (Object)((Object)lastKnownActivityState), new Object[0]);
        if (stateFromActivityManager == AppState.FOREGROUND && AppStateUtils.isActivityInactive(lastKnownActivityState)) {
            return AppState.BACKGROUND;
        }
        return stateFromActivityManager;
    }

    public static AppState getAppState(@NonNull Context context) {
        LogUtils.v(TAG, "Getting app state...", new Object[0]);
        AppState state = AppStateUtils.arbitrage(AppStateUtils.getAppStateFromActivityManager(context), AppStateUtils.getLastKnownActivityState(context));
        LogUtils.v(TAG, "getAppState() returns " + (Object)((Object)state), new Object[0]);
        return state;
    }

    public static enum AppState {
        UNKNOWN,
        FOREGROUND,
        BACKGROUND;


        public String toString() {
            switch (this) {
                case FOREGROUND: {
                    return "Foreground";
                }
                case BACKGROUND: {
                    return "Background";
                }
            }
            return "Unknown";
        }
    }

    public static enum ActivityState {
        ACTIVITY_STATE_UNKNOWN(0),
        ACTIVITY_STATE_CREATED(1),
        ACTIVITY_STATE_STARTED(2),
        ACTIVITY_STATE_RESUMED(3),
        ACTIVITY_STATE_PAUSED(4),
        ACTIVITY_STATE_STOPPED(5),
        ACTIVITY_STATE_SAVE_INSTANCE_STATE(6),
        ACTIVITY_STATE_DESTROYED(7);

        private final int code;

        private ActivityState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static ActivityState fromCode(int code) {
            switch (code) {
                case 0: {
                    return ACTIVITY_STATE_UNKNOWN;
                }
                case 1: {
                    return ACTIVITY_STATE_CREATED;
                }
                case 2: {
                    return ACTIVITY_STATE_STARTED;
                }
                case 3: {
                    return ACTIVITY_STATE_RESUMED;
                }
                case 4: {
                    return ACTIVITY_STATE_PAUSED;
                }
                case 5: {
                    return ACTIVITY_STATE_STOPPED;
                }
                case 6: {
                    return ACTIVITY_STATE_SAVE_INSTANCE_STATE;
                }
                case 7: {
                    return ACTIVITY_STATE_DESTROYED;
                }
            }
            LogUtils.e(AppStateUtils.TAG, "Unknown activity status code: " + code, new Object[0]);
            return ACTIVITY_STATE_UNKNOWN;
        }
    }
}

