/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentListener;
import com.mapbox.android.telemetry.AttachmentMetadata;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FileAttachment;
import com.mapbox.android.telemetry.FileData;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class TelemetryClient {
    private static final String LOG_TAG = "TelemetryClient";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String EVENTS_ENDPOINT = "/events/v2";
    private static final String ATTACHMENTS_ENDPOINT = "/attachments/v1";
    private static final String USER_AGENT_REQUEST_HEADER = "User-Agent";
    private static final String MAPBOX_AGENT_REQUEST_HEADER = "X-Mapbox-Agent";
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String EXTRA_DEBUGGING_LOG = "Sending POST to %s with %d event(s) (user agent: %s) with payload: %s";
    private static final String BOUNDARY = "--01ead4a5-7a67-4703-ad02-589886e00923";
    private String accessToken;
    private String userAgent;
    private String reformedUserAgent;
    private TelemetryClientSettings setting;
    private final Logger logger;
    private CertificateBlacklist certificateBlacklist;

    TelemetryClient(String accessToken, String userAgent, String reformedUserAgent, TelemetryClientSettings setting, Logger logger, CertificateBlacklist certificateBlacklist) {
        this.accessToken = accessToken;
        this.userAgent = userAgent;
        this.reformedUserAgent = reformedUserAgent;
        this.setting = setting;
        this.logger = logger;
        this.certificateBlacklist = certificateBlacklist;
    }

    void updateAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    void updateUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    void sendEvents(List<Event> events, Callback callback, boolean serializeNulls) {
        this.sendBatch(Collections.unmodifiableList(events), callback, serializeNulls);
    }

    void sendAttachment(Attachment attachment, final CopyOnWriteArraySet<AttachmentListener> attachmentListeners) {
        List<FileAttachment> visionAttachments = attachment.getAttachments();
        ArrayList<AttachmentMetadata> metadataList = new ArrayList<AttachmentMetadata>();
        final ArrayList<String> fileIds = new ArrayList<String>();
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder(BOUNDARY).setType(MultipartBody.FORM);
        for (FileAttachment fileAttachment : visionAttachments) {
            FileData fileData = fileAttachment.getFileData();
            AttachmentMetadata attachmentMetadata = fileAttachment.getAttachmentMetadata();
            metadataList.add(attachmentMetadata);
            requestBodyBuilder.addFormDataPart("file", attachmentMetadata.getName(), RequestBody.create((MediaType)fileData.getType(), (File)new File(fileData.getFilePath())));
            fileIds.add(attachmentMetadata.getFileId());
        }
        Gson gson = new Gson();
        requestBodyBuilder.addFormDataPart("attachments", gson.toJson(metadataList));
        RequestBody requestBody = this.reverseMultiForm(requestBodyBuilder);
        HttpUrl baseUrl = this.setting.getBaseUrl();
        HttpUrl requestUrl = baseUrl.newBuilder(ATTACHMENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        if (this.isExtraDebuggingNeeded()) {
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, requestUrl, visionAttachments.size(), this.userAgent, metadataList));
        }
        Request request = new Request.Builder().url(requestUrl).header(USER_AGENT_REQUEST_HEADER, this.userAgent).addHeader(MAPBOX_AGENT_REQUEST_HEADER, this.reformedUserAgent).post(requestBody).build();
        OkHttpClient client = this.setting.getAttachmentClient(this.certificateBlacklist);
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException exception) {
                for (AttachmentListener attachmentListener : attachmentListeners) {
                    attachmentListener.onAttachmentFailure(exception.getMessage(), fileIds);
                }
            }

            public void onResponse(Call call, Response response) {
                for (AttachmentListener attachmentListener : attachmentListeners) {
                    attachmentListener.onAttachmentResponse(response.message(), response.code(), fileIds);
                }
            }
        });
    }

    void updateDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.setting = this.setting.toBuilder().debugLoggingEnabled(debugLoggingEnabled).build();
    }

    String obtainAccessToken() {
        return this.accessToken;
    }

    TelemetryClientSettings obtainSetting() {
        return this.setting;
    }

    private void sendBatch(List<Event> batch, Callback callback, boolean serializeNulls) {
        Gson gson = serializeNulls ? new GsonBuilder().serializeNulls().create() : new Gson();
        String payload = gson.toJson(batch);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        HttpUrl baseUrl = this.setting.getBaseUrl();
        HttpUrl url = baseUrl.newBuilder(EVENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        if (this.isExtraDebuggingNeeded()) {
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, url, batch.size(), this.userAgent, payload));
        }
        Request request = new Request.Builder().url(url).header(USER_AGENT_REQUEST_HEADER, this.userAgent).addHeader(MAPBOX_AGENT_REQUEST_HEADER, this.reformedUserAgent).post(body).build();
        OkHttpClient client = this.setting.getClient(this.certificateBlacklist, batch.size());
        client.newCall(request).enqueue(callback);
    }

    private boolean isExtraDebuggingNeeded() {
        return this.setting.isDebugLoggingEnabled() || this.setting.getEnvironment().equals((Object)Environment.STAGING);
    }

    private RequestBody reverseMultiForm(MultipartBody.Builder builder) {
        MultipartBody multipartBody = builder.build();
        builder = new MultipartBody.Builder(BOUNDARY).setType(MultipartBody.FORM);
        for (int i = multipartBody.size() - 1; i > -1; --i) {
            builder.addPart(multipartBody.part(i));
        }
        return builder.build();
    }

    synchronized void setBaseUrl(String eventsHost) {
        HttpUrl baseUrl = TelemetryClientSettings.configureUrlHostname(eventsHost);
        this.setting = this.setting.toBuilder().baseUrl(baseUrl).build();
    }
}

