/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.crash;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.crash.CrashReporterClient;
import java.io.File;

public final class CrashReporterWorker
extends Worker {
    private static final String LOG_TAG = "CrashReporterWorker";

    public CrashReporterWorker(@NonNull Context context, @NonNull WorkerParameters params) {
        super(context, params);
    }

    public ListenableWorker.Result doWork() {
        try {
            File rootDirectory = FileUtils.getFile((Context)this.getApplicationContext(), (String)"com.mapbox.android.telemetry");
            if (!rootDirectory.exists()) {
                Log.w((String)LOG_TAG, (String)"Root directory doesn't exist");
                return ListenableWorker.Result.failure();
            }
            String token = this.getInputData().getString("com.mapbox.android.telemetry.error.data");
            if (token == null || token.isEmpty()) {
                return ListenableWorker.Result.failure();
            }
            this.handleCrashReports(CrashReporterClient.create(this.getApplicationContext(), token).loadFrom(rootDirectory));
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)throwable.toString());
            return ListenableWorker.Result.failure();
        }
        return ListenableWorker.Result.success();
    }

    @VisibleForTesting
    void handleCrashReports(@NonNull CrashReporterClient client) {
        if (!client.isEnabled()) {
            Log.w((String)LOG_TAG, (String)"Crash reporter is disabled");
            return;
        }
        while (client.hasNextEvent()) {
            CrashEvent event = client.nextEvent();
            if (client.isDuplicate(event)) {
                Log.d((String)LOG_TAG, (String)("Skip duplicate crash in this batch: " + event.getHash()));
                client.delete(event);
                continue;
            }
            if (client.send(event)) {
                client.delete(event);
                continue;
            }
            Log.w((String)LOG_TAG, (String)"Failed to deliver crash event");
        }
    }

    public static OneTimeWorkRequest createWorkRequest(String accessToken) {
        return (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(CrashReporterWorker.class).setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())).setInputData(new Data.Builder().putString("com.mapbox.android.telemetry.error.data", accessToken).build())).build();
    }
}

