/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.CertificatePinnerFactory;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.GzipRequestInterceptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

class TelemetryClientSettings {
    private static final Map<Environment, String> HOSTS = new HashMap<Environment, String>(){
        {
            this.put(Environment.STAGING, "api-events-staging.tilestream.net");
            this.put(Environment.COM, "events.mapbox.com");
            this.put(Environment.CHINA, "events.mapbox.cn");
        }
    };
    private static final String HTTPS_SCHEME = "https";
    private final Context context;
    private Environment environment;
    private final OkHttpClient client;
    private final HttpUrl baseUrl;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager x509TrustManager;
    private final HostnameVerifier hostnameVerifier;
    private boolean debugLoggingEnabled;

    TelemetryClientSettings(Builder builder) {
        this.context = builder.context;
        this.environment = builder.environment;
        this.client = builder.client;
        this.baseUrl = builder.baseUrl;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.x509TrustManager = builder.x509TrustManager;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.debugLoggingEnabled = builder.debugLoggingEnabled;
    }

    Environment getEnvironment() {
        return this.environment;
    }

    OkHttpClient getClient(CertificateBlacklist certificateBlacklist, int eventCount) {
        Interceptor[] interceptors = new Interceptor[]{new GzipRequestInterceptor()};
        return this.configureHttpClient(certificateBlacklist, interceptors);
    }

    OkHttpClient getAttachmentClient(CertificateBlacklist certificateBlacklist) {
        return this.configureHttpClient(certificateBlacklist, null);
    }

    HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    boolean isDebugLoggingEnabled() {
        return this.debugLoggingEnabled;
    }

    Builder toBuilder() {
        return new Builder(this.context).environment(this.environment).client(this.client).baseUrl(this.baseUrl).sslSocketFactory(this.sslSocketFactory).x509TrustManager(this.x509TrustManager).hostnameVerifier(this.hostnameVerifier).debugLoggingEnabled(this.debugLoggingEnabled);
    }

    static HttpUrl configureUrlHostname(String eventsHost) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(HTTPS_SCHEME);
        builder.host(eventsHost);
        return builder.build();
    }

    private OkHttpClient configureHttpClient(CertificateBlacklist certificateBlacklist, Interceptor[] interceptors) {
        CertificatePinnerFactory factory = new CertificatePinnerFactory();
        OkHttpClient.Builder builder = this.client.newBuilder().retryOnConnectionFailure(true).certificatePinner(factory.provideCertificatePinnerFor(this.environment, certificateBlacklist)).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS));
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        if (this.isSocketFactoryUnset(this.sslSocketFactory, this.x509TrustManager)) {
            builder.sslSocketFactory(this.sslSocketFactory, this.x509TrustManager);
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        return builder.build();
    }

    private boolean isSocketFactoryUnset(SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager) {
        return sslSocketFactory != null && x509TrustManager != null;
    }

    static final class Builder {
        Context context;
        Environment environment = Environment.COM;
        OkHttpClient client = new OkHttpClient();
        HttpUrl baseUrl = null;
        SSLSocketFactory sslSocketFactory = null;
        X509TrustManager x509TrustManager = null;
        HostnameVerifier hostnameVerifier = null;
        boolean debugLoggingEnabled = false;

        Builder(Context context) {
            this.context = context;
        }

        Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        Builder client(OkHttpClient client) {
            if (client != null) {
                this.client = client;
            }
            return this;
        }

        Builder baseUrl(HttpUrl baseUrl) {
            if (baseUrl != null) {
                this.baseUrl = baseUrl;
            }
            return this;
        }

        Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        Builder x509TrustManager(X509TrustManager x509TrustManager) {
            this.x509TrustManager = x509TrustManager;
            return this;
        }

        Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        Builder debugLoggingEnabled(boolean debugLoggingEnabled) {
            this.debugLoggingEnabled = debugLoggingEnabled;
            return this;
        }

        TelemetryClientSettings build() {
            if (this.baseUrl == null) {
                String eventsHost = (String)HOSTS.get((Object)this.environment);
                this.baseUrl = TelemetryClientSettings.configureUrlHostname(eventsHost);
            }
            return new TelemetryClientSettings(this);
        }
    }
}

