/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mapbox.android.telemetry.NavigationFeedbackEvent;
import java.lang.reflect.Type;
import java.util.Map;

class FeedbackEventSerializer
implements JsonSerializer<NavigationFeedbackEvent> {
    private static final String EVENT = "event";
    private static final String STEP = "step";

    FeedbackEventSerializer() {
    }

    public JsonElement serialize(NavigationFeedbackEvent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject feedbackEvent = new JsonObject();
        feedbackEvent.addProperty(EVENT, src.getEvent());
        this.serializeMetadata(src, context, feedbackEvent);
        this.serializeFeedbackEventData(src, context, feedbackEvent);
        this.serializeLocationData(src, context, feedbackEvent);
        this.serializeFeedbackData(src, context, feedbackEvent);
        this.serializeStep(src, context, feedbackEvent);
        return feedbackEvent;
    }

    private void serializeMetadata(NavigationFeedbackEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject metadata = context.serialize((Object)src.getMetadata()).getAsJsonObject();
        for (Map.Entry e : metadata.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeFeedbackEventData(NavigationFeedbackEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject feedbackEventData = context.serialize((Object)src.getFeedbackEventData()).getAsJsonObject();
        for (Map.Entry e : feedbackEventData.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeLocationData(NavigationFeedbackEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject locationData = context.serialize((Object)src.getNavigationLocationData()).getAsJsonObject();
        for (Map.Entry e : locationData.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeFeedbackData(NavigationFeedbackEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject feedbackData = context.serialize((Object)src.getFeedbackData()).getAsJsonObject();
        for (Map.Entry e : feedbackData.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeStep(NavigationFeedbackEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonElement step = context.serialize((Object)src.getStep());
        feedbackEvent.add(STEP, step);
    }
}

