/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;

public class OfflineDownloadEndEvent
extends Event
implements Parcelable {
    private static final String OFFLINE_DOWNLOAD_COMPLETE = "map.offlineDownload.end";
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="minZoom")
    private final Double minZoom;
    @SerializedName(value="maxZoom")
    private final Double maxZoom;
    @SerializedName(value="shapeForOfflineRegion")
    private final String shapeForOfflineRegion;
    @SerializedName(value="styleURL")
    private String styleURL;
    @SerializedName(value="sizeOfResourcesCompleted")
    private Long sizeOfResourcesCompleted;
    @SerializedName(value="numberOfTilesCompleted")
    private Long numberOfTilesCompleted;
    @SerializedName(value="state")
    private String state;
    public static final Parcelable.Creator<OfflineDownloadEndEvent> CREATOR = new Parcelable.Creator<OfflineDownloadEndEvent>(){

        public OfflineDownloadEndEvent createFromParcel(Parcel in) {
            return new OfflineDownloadEndEvent(in);
        }

        public OfflineDownloadEndEvent[] newArray(int size) {
            return new OfflineDownloadEndEvent[size];
        }
    };

    public void setStyleURL(String styleURL) {
        this.styleURL = styleURL;
    }

    public void setSizeOfResourcesCompleted(Long sizeOfResourcesCompleted) {
        this.sizeOfResourcesCompleted = sizeOfResourcesCompleted;
    }

    public void setNumberOfTilesCompleted(Long numberOfTilesCompleted) {
        this.numberOfTilesCompleted = numberOfTilesCompleted;
    }

    public void setState(String state) {
        this.state = state;
    }

    OfflineDownloadEndEvent(String shapeForOfflineRegion, Double minZoom, Double maxZoom) {
        this.event = OFFLINE_DOWNLOAD_COMPLETE;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.shapeForOfflineRegion = shapeForOfflineRegion;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    private OfflineDownloadEndEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.shapeForOfflineRegion = in.readString();
        this.minZoom = in.readDouble();
        this.maxZoom = in.readDouble();
        this.styleURL = in.readString();
        this.sizeOfResourcesCompleted = in.readLong();
        this.numberOfTilesCompleted = in.readLong();
        this.state = in.readString();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.OFFLINE_DOWNLOAD_COMPLETE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeString(this.shapeForOfflineRegion);
        dest.writeDouble(this.minZoom.doubleValue());
        dest.writeDouble(this.maxZoom.doubleValue());
        dest.writeString(this.styleURL);
        dest.writeLong(this.sizeOfResourcesCompleted.longValue());
        dest.writeLong(this.numberOfTilesCompleted.longValue());
        dest.writeString(this.state);
    }
}

