/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.LocationReceiver;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.TelemetryCallback;
import com.mapbox.android.telemetry.TelemetryLocationEnabler;
import com.mapbox.android.telemetry.TelemetryReceiver;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class TelemetryService
extends Service
implements TelemetryCallback,
EventCallback {
    public static final String IS_LOCATION_ENABLER_FROM_PREFERENCES = "isLocationEnablerFromPreferences";
    private static final long DEFAULT_INTERVAL_IN_MILLISECONDS = 1000L;
    private static final long DEFAULT_MAX_WAIT_TIME = 5000L;
    private static final String TAG = "TelemetryService";
    private LocationReceiver locationReceiver;
    private TelemetryReceiver telemetryReceiver;
    private EventsQueue queue;
    private int boundInstances;
    private LocationEngine locationEngine;
    private CopyOnWriteArraySet<ServiceTaskCallback> serviceTaskCallbacks;
    private TelemetryLocationEnabler telemetryLocationEnabler;
    private boolean isLocationEnablerFromPreferences;
    private boolean isLocationReceiverRegistered;
    private boolean isTelemetryReceiverRegistered;
    private final LocationEngineCallback<LocationEngineResult> callback;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public TelemetryService() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.locationReceiver = null;
        this.telemetryReceiver = null;
        this.queue = null;
        this.boundInstances = 0;
        this.locationEngine = null;
        this.serviceTaskCallbacks = null;
        this.isLocationEnablerFromPreferences = true;
        this.isLocationReceiverRegistered = false;
        this.isTelemetryReceiverRegistered = false;
        blArray[0] = true;
        this.callback = new LocationEngineCallback<LocationEngineResult>(this){
            final /* synthetic */ TelemetryService this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onSuccess(LocationEngineResult locationEngineResult) {
                void locations;
                block4: {
                    block3: {
                        block2: {
                            void result;
                            boolean[] blArray = 1.$jacocoInit();
                            List list = result.getLocations();
                            blArray[1] = true;
                            Log.d((String)TelemetryService.TAG, (String)("Locations reported: " + locations.size()));
                            blArray[2] = true;
                            if (locations != null) break block2;
                            blArray[3] = true;
                            break block3;
                        }
                        if (!locations.isEmpty()) break block4;
                        blArray[4] = true;
                    }
                    Log.e((String)TelemetryService.TAG, (String)"Location is unavailable");
                    blArray[5] = true;
                    return;
                }
                blArray[6] = true;
                LocalBroadcastManager.getInstance((Context)this.this$0.getApplicationContext()).sendBroadcast(LocationReceiver.supplyIntent((List<Location>)locations));
                blArray[7] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onFailure(@NonNull Exception exception) {
                void exception2;
                boolean[] blArray = 1.$jacocoInit();
                Log.e((String)TelemetryService.TAG, (String)exception2.toString());
                blArray[8] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-7840957896990547622L, (String)"com/mapbox/android/telemetry/TelemetryService$1", (int)10);
                }
                return blArray;
            }
        };
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate() {
        void context;
        boolean[] blArray = TelemetryService.$jacocoInit();
        super.onCreate();
        blArray[2] = true;
        Context context2 = this.getApplicationContext();
        blArray[3] = true;
        this.createLocationReceiver((Context)context);
        blArray[4] = true;
        this.createTelemetryReceiver((Context)context);
        blArray[5] = true;
        this.createServiceTaskCallbacks();
        blArray[6] = true;
    }

    /*
     * WARNING - void declaration
     */
    public int onStartCommand(Intent intent, int n, int n2) {
        void intent2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.enableTelemetryLocationState((Intent)intent2, this.getApplicationContext());
        blArray[7] = true;
        return 3;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        boolean[] blArray = TelemetryService.$jacocoInit();
        blArray[8] = true;
        return new TelemetryBinder(this);
    }

    /*
     * WARNING - void declaration
     */
    public void onDestroy() {
        void context;
        boolean[] blArray = TelemetryService.$jacocoInit();
        Context context2 = this.getApplicationContext();
        blArray[9] = true;
        this.unregisterLocationReceiver((Context)context);
        blArray[10] = true;
        this.unregisterTelemetryReceiver((Context)context);
        blArray[11] = true;
        this.disableTelemetryLocationState((Context)context);
        blArray[12] = true;
        super.onDestroy();
        blArray[13] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onTaskRemoved(Intent intent) {
        void rootIntent;
        boolean[] blArray = TelemetryService.$jacocoInit();
        Iterator<ServiceTaskCallback> iterator = this.serviceTaskCallbacks.iterator();
        blArray[14] = true;
        while (iterator.hasNext()) {
            void callback;
            ServiceTaskCallback serviceTaskCallback = iterator.next();
            blArray[15] = true;
            callback.onTaskRemoved();
            blArray[16] = true;
        }
        super.onTaskRemoved((Intent)rootIntent);
        blArray[17] = true;
    }

    @Override
    public void onBackground() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        System.out.println("TelemetryService#onBackground: Shutting down location receiver...");
        blArray[18] = true;
        this.unregisterLocationReceiver(this.getApplicationContext());
        blArray[19] = true;
    }

    @Override
    public void onForeground() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        System.out.println("TelemetryService#onForeground: Restarting location receiver...");
        blArray[20] = true;
        this.registerLocationReceiver(this.getApplicationContext());
        blArray[21] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEventReceived(Event event) {
        boolean[] blArray = TelemetryService.$jacocoInit();
        if (this.queue == null) {
            blArray[22] = true;
        } else {
            void event2;
            blArray[23] = true;
            this.queue.push((Event)event2);
            blArray[24] = true;
        }
        blArray[25] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        void sessionIdentifier2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.locationReceiver.updateSessionIdentifier((SessionIdentifier)sessionIdentifier2);
        blArray[26] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindInstance() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            try {
                blArray[27] = true;
                ++this.boundInstances;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[28] = true;
                throw throwable;
            }
        }
        blArray[29] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindInstance() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            try {
                blArray[30] = true;
                --this.boundInstances;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[31] = true;
                throw throwable;
            }
        }
        blArray[32] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int obtainBoundInstances() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            try {
                blArray[33] = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[34] = true;
                return this.boundInstances;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[35] = true;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean addServiceTask(ServiceTaskCallback serviceTaskCallback) {
        void callback;
        boolean[] blArray = TelemetryService.$jacocoInit();
        blArray[36] = true;
        return this.serviceTaskCallbacks.add((ServiceTaskCallback)callback);
    }

    /*
     * WARNING - void declaration
     */
    boolean removeServiceTask(ServiceTaskCallback serviceTaskCallback) {
        void callback;
        boolean[] blArray = TelemetryService.$jacocoInit();
        blArray[37] = true;
        return this.serviceTaskCallbacks.remove(callback);
    }

    /*
     * WARNING - void declaration
     */
    void injectEventsQueue(EventsQueue eventsQueue) {
        void queue;
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.queue = queue;
        blArray[38] = true;
    }

    @VisibleForTesting
    boolean isLocationReceiverRegistered() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        blArray[39] = true;
        return this.isLocationReceiverRegistered;
    }

    @VisibleForTesting
    boolean isTelemetryReceiverRegistered() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        blArray[40] = true;
        return this.isTelemetryReceiverRegistered;
    }

    @VisibleForTesting
    boolean locationPermissionCheck() {
        boolean bl;
        boolean[] blArray = TelemetryService.$jacocoInit();
        if (ContextCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
            bl = blArray[41] = true;
        } else {
            bl = false;
            blArray[42] = true;
        }
        blArray[43] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private void createLocationReceiver(Context context) {
        void context2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.locationReceiver = new LocationReceiver(this);
        blArray[44] = true;
        this.registerLocationReceiver((Context)context2);
        blArray[45] = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerLocationReceiver(Context context) {
        void context2;
        block4: {
            boolean[] blArray = TelemetryService.$jacocoInit();
            this.locationEngine = LocationEngineProvider.getBestLocationEngine((Context)context2, (boolean)true);
            blArray[46] = true;
            if (!this.locationPermissionCheck()) {
                blArray[47] = true;
            } else {
                try {
                    blArray[48] = true;
                    this.locationEngine.requestLocationUpdates(TelemetryService.getRequest(), this.callback, this.getMainLooper());
                }
                catch (SecurityException securityException) {
                    void se;
                    blArray[50] = true;
                    Log.e((String)TAG, (String)se.toString());
                    blArray[51] = true;
                    break block4;
                }
                blArray[49] = true;
            }
        }
        blArray[52] = true;
        LocalBroadcastManager.getInstance((Context)context2).registerReceiver((BroadcastReceiver)this.locationReceiver, new IntentFilter("com.mapbox.location_receiver"));
        this.isLocationReceiverRegistered = true;
        blArray[53] = true;
    }

    private static LocationEngineRequest getRequest() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        blArray[54] = true;
        blArray[55] = true;
        blArray[56] = true;
        return new LocationEngineRequest.Builder(1000L).setPriority(3).setMaxWaitTime(5000L).build();
    }

    /*
     * WARNING - void declaration
     */
    private void createTelemetryReceiver(Context context) {
        void context2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.telemetryReceiver = new TelemetryReceiver(this);
        blArray[57] = true;
        blArray[58] = true;
        LocalBroadcastManager.getInstance((Context)context2).registerReceiver((BroadcastReceiver)this.telemetryReceiver, new IntentFilter("com.mapbox.telemetry_receiver"));
        this.isTelemetryReceiverRegistered = true;
        blArray[59] = true;
    }

    private void createServiceTaskCallbacks() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.serviceTaskCallbacks = new CopyOnWriteArraySet();
        blArray[60] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void enableTelemetryLocationState(Intent intent, Context context) {
        void intent2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        if (intent2 != null) {
            blArray[61] = true;
            this.isLocationEnablerFromPreferences = intent2.getBooleanExtra(IS_LOCATION_ENABLER_FROM_PREFERENCES, true);
            blArray[62] = true;
        } else {
            this.isLocationEnablerFromPreferences = true;
            blArray[63] = true;
        }
        if (!this.isLocationEnablerFromPreferences) {
            blArray[64] = true;
        } else {
            void context2;
            blArray[65] = true;
            this.createLocationEnabler();
            blArray[66] = true;
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.ENABLED, (Context)context2);
            blArray[67] = true;
        }
        blArray[68] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterLocationReceiver(Context context) {
        void context2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        this.locationEngine.removeLocationUpdates(this.callback);
        blArray[69] = true;
        LocalBroadcastManager.getInstance((Context)context2).unregisterReceiver((BroadcastReceiver)this.locationReceiver);
        this.isLocationReceiverRegistered = false;
        blArray[70] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void unregisterTelemetryReceiver(Context context) {
        void context2;
        boolean[] blArray = TelemetryService.$jacocoInit();
        LocalBroadcastManager.getInstance((Context)context2).unregisterReceiver((BroadcastReceiver)this.telemetryReceiver);
        this.isTelemetryReceiverRegistered = false;
        blArray[71] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void disableTelemetryLocationState(Context context) {
        boolean[] blArray = TelemetryService.$jacocoInit();
        if (!this.isLocationEnablerFromPreferences) {
            blArray[72] = true;
        } else {
            void context2;
            blArray[73] = true;
            this.createLocationEnabler();
            blArray[74] = true;
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.DISABLED, (Context)context2);
            blArray[75] = true;
        }
        blArray[76] = true;
    }

    private void createLocationEnabler() {
        boolean[] blArray = TelemetryService.$jacocoInit();
        if (this.telemetryLocationEnabler != null) {
            blArray[77] = true;
        } else {
            blArray[78] = true;
            this.telemetryLocationEnabler = new TelemetryLocationEnabler(true);
            blArray[79] = true;
        }
        blArray[80] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-7480498698240894097L, (String)"com/mapbox/android/telemetry/TelemetryService", (int)81);
        }
        return blArray;
    }

    class TelemetryBinder
    extends Binder {
        final /* synthetic */ TelemetryService this$0;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        TelemetryBinder(TelemetryService telemetryService) {
            void this$0;
            boolean[] blArray = TelemetryBinder.$jacocoInit();
            this.this$0 = this$0;
            blArray[0] = true;
        }

        TelemetryService obtainService() {
            boolean[] blArray = TelemetryBinder.$jacocoInit();
            blArray[1] = true;
            return this.this$0;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-1547223509925076068L, (String)"com/mapbox/android/telemetry/TelemetryService$TelemetryBinder", (int)2);
            }
            return blArray;
        }
    }
}

