/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentChain;
import com.mapbox.android.telemetry.EnvironmentResolver;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.ServerInformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

class CertificateBlacklist
implements Callback {
    private static final String LOG_TAG = "MapboxBlacklist";
    private static final String BLACKLIST_FILE = "MapboxBlacklist";
    private static final String SHA256 = "sha256/";
    private static final String NEW_LINE = "\n";
    private static final String HTTPS = "https://";
    private static final String BACKSLASH = "/";
    private static final String EMPTY_STRING = "";
    private static final int BLACKLIST_HEAD = 0;
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final String COM_CONFIG_ENDPOINT = "api.mapbox.com";
    private static final String CHINA_CONFIG_ENDPOINT = "api.mapbox.cn";
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String NAME_NOT_FOUND_EXCEPTION = "Name Not Found";
    private static final String SAVE_BLACKLIST_FAIL = "Unable to save blacklist to file";
    private static final String RETRIEVE_TIME_FAIL = "Unable to retrieve last update time from blacklist";
    private static final String RETRIEVE_BLACKLIST_FAIL = "Unable to retrieve blacklist contents from file";
    private static final String CLOSE_STREAM_FAIL = "Unable to close stream";
    private static final String CLOSE_BUFFER_READER_FAIL = "Unable to close BufferedReader";
    private static final String REQUEST_FAIL = "Request failed to download blacklist";
    private static final String READLINE_FAIL = "Unable to read line of Blacklist file";
    private static final String HTTPS_SCHEME = "https";
    private static final Map<Environment, String> ENDPOINTS;
    private final Context context;
    private final String accessToken;
    private Logger logger;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    CertificateBlacklist(Context context, String string) {
        void accessToken;
        void context2;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        this.context = context2;
        this.accessToken = accessToken;
        blArray[0] = true;
        this.logger = new Logger();
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    List<String> retrieveBlackList() {
        List<String> blacklist;
        void directory;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        File file = this.context.getFilesDir();
        blArray[2] = true;
        ArrayList arrayList = new ArrayList();
        blArray[3] = true;
        if (!directory.isDirectory()) {
            blArray[4] = true;
        } else {
            void file2;
            blArray[5] = true;
            File file3 = new File((File)directory, "MapboxBlacklist");
            blArray[6] = true;
            if (!file2.exists()) {
                blArray[7] = true;
            } else {
                try {
                    blArray[8] = true;
                    blacklist = this.obtainBlacklistContents((File)file2);
                    blArray[9] = true;
                    blacklist.remove(0);
                    blArray[10] = true;
                }
                catch (IOException iOException) {
                    void exception;
                    blArray[11] = true;
                    this.logger.error(RETRIEVE_BLACKLIST_FAIL, exception.getMessage());
                    blArray[12] = true;
                }
            }
        }
        blArray[13] = true;
        return blacklist;
    }

    boolean daySinceLastUpdate() {
        boolean bl;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        long millisecondDiff = System.currentTimeMillis() - this.retrieveLastUpdateTime();
        if (millisecondDiff >= 86400000L) {
            bl = blArray[14] = true;
        } else {
            bl = false;
            blArray[15] = true;
        }
        blArray[16] = true;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private long retrieveLastUpdateTime() {
        long lastUpdateTime;
        void directory;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        File file = this.context.getFilesDir();
        blArray[17] = true;
        File file2 = new File((File)directory, "MapboxBlacklist");
        long l = 0L;
        blArray[18] = true;
        if (!file2.exists()) {
            blArray[19] = true;
        } else {
            try {
                void blacklist;
                blArray[20] = true;
                List<String> list = this.obtainBlacklistContents(file2);
                blArray[21] = true;
                lastUpdateTime = Long.valueOf((String)blacklist.get(0));
                blArray[22] = true;
            }
            catch (IOException blacklist) {
                void exception;
                blArray[23] = true;
                this.logger.error(RETRIEVE_TIME_FAIL, exception.getMessage());
                blArray[24] = true;
            }
        }
        blArray[25] = true;
        return lastUpdateTime;
    }

    /*
     * WARNING - void declaration
     */
    void updateBlacklist() {
        void request;
        void client;
        void requestUrl;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        blArray[26] = true;
        blArray[27] = true;
        blArray[28] = true;
        blArray[29] = true;
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(HTTPS_SCHEME).host(this.determineConfigEndpoint()).addPathSegment("events-config").addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        blArray[30] = true;
        blArray[31] = true;
        blArray[32] = true;
        Request request2 = new Request.Builder().url((HttpUrl)requestUrl).build();
        blArray[33] = true;
        OkHttpClient okHttpClient = new OkHttpClient();
        blArray[34] = true;
        client.newCall((Request)request).enqueue((Callback)this);
        blArray[35] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveBlackList(List<String> list) {
        FileOutputStream outputStream;
        void revokedKeys;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        String fileContents = this.createListContent((List<String>)revokedKeys);
        Object var4_4 = null;
        try {
            blArray[36] = true;
            outputStream = this.context.openFileOutput("MapboxBlacklist", 0);
            blArray[37] = true;
            outputStream.write(fileContents.getBytes());
            try {
                blArray[38] = true;
                outputStream.close();
                blArray[39] = true;
            }
            catch (IOException iOException) {
                void exception;
                blArray[40] = true;
                this.logger.error(CLOSE_STREAM_FAIL, exception.getMessage());
                blArray[41] = true;
            }
        }
        catch (IOException exception) {
            try {
                void exception4332;
                blArray[42] = true;
                this.logger.error(SAVE_BLACKLIST_FAIL, exception4332.getMessage());
                try {
                    blArray[43] = true;
                    outputStream.close();
                    blArray[44] = true;
                }
                catch (IOException exception4332) {
                    blArray[45] = true;
                    this.logger.error(CLOSE_STREAM_FAIL, exception.getMessage());
                    blArray[46] = true;
                }
            }
            catch (Throwable throwable) {
                try {
                    blArray[47] = true;
                    outputStream.close();
                    blArray[48] = true;
                }
                catch (IOException iOException) {
                    void exception3;
                    blArray[49] = true;
                    this.logger.error(CLOSE_STREAM_FAIL, exception3.getMessage());
                    blArray[50] = true;
                }
                blArray[51] = true;
                throw throwable;
            }
        }
        blArray[52] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onFailure(Call call, IOException iOException) {
        void exception;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        Log.e((String)"MapboxBlacklist", (String)REQUEST_FAIL, (Throwable)exception);
        blArray[53] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void onResponse(Call call, Response response) throws IOException {
        void revokedKeys;
        void response2;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        List<String> list = this.extractResponse((Response)response2);
        blArray[54] = true;
        this.saveBlackList((List<String>)revokedKeys);
        blArray[55] = true;
    }

    /*
     * WARNING - void declaration
     */
    private String createListContent(List<String> list) {
        void content;
        void revokedKeys;
        void date;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        Date date2 = new Date();
        blArray[56] = true;
        StringBuilder stringBuilder = new StringBuilder(date.getTime() + NEW_LINE);
        blArray[57] = true;
        Iterator iterator = revokedKeys.iterator();
        blArray[58] = true;
        while (iterator.hasNext()) {
            void key;
            String string = (String)iterator.next();
            blArray[59] = true;
            content.append(SHA256).append((String)key).append(NEW_LINE);
            blArray[60] = true;
        }
        blArray[61] = true;
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> obtainBlacklistContents(File var1_1) throws IOException {
        block24: {
            var2_2 = CertificateBlacklist.$jacocoInit();
            var3_3 = new FileInputStream((File)file);
            var2_2[62] = true;
            var4_4 = new BufferedReader(new InputStreamReader((InputStream)inputStream));
            var2_2[63] = true;
            var5_5 = new ArrayList<E>();
            try {
                var2_2[64] = true;
                var6_6 = false;
                var2_2[65] = true;
                while (true) {
                    block27: {
                        if (!done) break block27;
                        var2_2[66] = true;
                        ** GOTO lbl85
                    }
                    var2_2[67] = true;
                    line = reader.readLine();
                    if (line == null) {
                        v0 = var2_2[68] = true;
                    } else {
                        v0 = false;
                        var2_2[69] = true;
                    }
                    done = v0;
                    var2_2[70] = true;
                    if (line == null) {
                        var2_2[71] = true;
                    } else if (line.isEmpty()) {
                        var2_2[72] = true;
                    } else {
                        var2_2[73] = true;
                        blacklist.add(line);
                        var2_2[74] = true;
                    }
                    var2_2[75] = true;
                }
            }
            catch (IOException exception) {
                block23: {
                    block26: {
                        try {
                            var2_2[82] = true;
                            this.logger.error("Unable to read line of Blacklist file", exception.getMessage());
                            try {
                                var2_2[83] = true;
                                inputStream.close();
                                var2_2[84] = true;
                                ** GOTO lbl53
                            }
                            catch (IOException exception) {
                                var2_2[85] = true;
                                this.logger.error("Unable to close stream", exception.getMessage());
                                try {
                                    var2_2[86] = true;
lbl53:
                                    // 2 sources

                                    reader.close();
                                    break block23;
                                }
                                catch (IOException exception) {
                                    var2_2[88] = true;
                                    this.logger.error("Unable to close BufferedReader", exception.getMessage());
                                    var2_2[89] = true;
                                }
                                break block24;
                            }
                        }
                        catch (Throwable var8_13) {
                            block25: {
                                try {
                                    var2_2[90] = true;
                                    inputStream.close();
                                    var2_2[91] = true;
                                    ** GOTO lbl73
                                }
                                catch (IOException var9_14) {
                                    var2_2[92] = true;
                                    this.logger.error("Unable to close stream", exception.getMessage());
                                    try {
                                        var2_2[93] = true;
lbl73:
                                        // 2 sources

                                        reader.close();
                                    }
                                    catch (IOException exception) {
                                        var2_2[95] = true;
                                        this.logger.error("Unable to close BufferedReader", exception.getMessage());
                                        var2_2[96] = true;
                                        break block25;
                                    }
                                }
                                var2_2[94] = true;
                            }
                            var2_2[97] = true;
                            throw var8_13;
                        }
lbl85:
                        // 1 sources

                        try {
                            inputStream.close();
                            var2_2[76] = true;
                            ** GOTO lbl95
                        }
                        catch (IOException done) {
                            var2_2[77] = true;
                            this.logger.error("Unable to close stream", exception.getMessage());
                            try {
                                var2_2[78] = true;
lbl95:
                                // 2 sources

                                reader.close();
                                break block26;
                            }
                            catch (IOException exception) {
                                var2_2[80] = true;
                                this.logger.error("Unable to close BufferedReader", exception.getMessage());
                                var2_2[81] = true;
                            }
                            break block24;
                        }
                    }
                    var2_2[79] = true;
                }
                var2_2[87] = true;
            }
        }
        var2_2[98] = true;
        return blacklist;
    }

    /*
     * WARNING - void declaration
     */
    private String determineConfigEndpoint() {
        block4: {
            void environmentChain;
            boolean[] blArray = CertificateBlacklist.$jacocoInit();
            EnvironmentChain environmentChain2 = new EnvironmentChain();
            blArray[99] = true;
            EnvironmentResolver environmentResolver = environmentChain.setup();
            try {
                void serverInformation;
                void setupChain;
                blArray[100] = true;
                ApplicationInfo appInformation = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
                if (appInformation == null) {
                    blArray[101] = true;
                    break block4;
                }
                if (appInformation.metaData == null) {
                    blArray[102] = true;
                    break block4;
                }
                blArray[103] = true;
                ServerInformation serverInformation2 = setupChain.obtainServerInformation(appInformation.metaData);
                blArray[104] = true;
                blArray[105] = true;
                return ENDPOINTS.get((Object)serverInformation.getEnvironment());
            }
            catch (PackageManager.NameNotFoundException appInformation) {
                void exception;
                blArray[107] = true;
                this.logger.error(NAME_NOT_FOUND_EXCEPTION, exception.getMessage());
                blArray[108] = true;
            }
        }
        blArray[106] = true;
        blArray[109] = true;
        return COM_CONFIG_ENDPOINT;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> extractResponse(Response response) throws IOException {
        void listType;
        void jsonObject;
        void responseData;
        void gson;
        void response2;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        String string = response2.body().string();
        blArray[110] = true;
        Gson gson2 = new Gson();
        blArray[111] = true;
        JsonObject jsonObject2 = (JsonObject)gson.fromJson((String)responseData, JsonObject.class);
        blArray[112] = true;
        Type type = new TypeToken<List<String>>(this){
            final /* synthetic */ CertificateBlacklist this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 2.$jacocoInit();
                this.this$0 = this$0;
                blArray[0] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-3851835856863586471L, (String)"com/mapbox/android/telemetry/CertificateBlacklist$2", (int)1);
                }
                return blArray;
            }
        }.getType();
        blArray[113] = true;
        List revokedKeys = (List)gson.fromJson(jsonObject.get("RevokedCertKeys"), (Type)listType);
        blArray[114] = true;
        return revokedKeys;
    }

    private String[] separateUrlSegments(String string) {
        String url;
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        url = url.replace(HTTPS, EMPTY_STRING);
        blArray[115] = true;
        blArray[116] = true;
        return url.split(BACKSLASH);
    }

    static {
        boolean[] blArray = CertificateBlacklist.$jacocoInit();
        ENDPOINTS = new HashMap<Environment, String>(){
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                boolean[] blArray = 1.$jacocoInit();
                blArray[0] = true;
                this.put(Environment.COM, CertificateBlacklist.COM_CONFIG_ENDPOINT);
                blArray[1] = true;
                this.put(Environment.STAGING, CertificateBlacklist.COM_CONFIG_ENDPOINT);
                blArray[2] = true;
                this.put(Environment.CHINA, CertificateBlacklist.CHINA_CONFIG_ENDPOINT);
                blArray[3] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)1539963739320715037L, (String)"com/mapbox/android/telemetry/CertificateBlacklist$1", (int)4);
                }
                return blArray;
            }
        };
        blArray[117] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-4443687560247088580L, (String)"com/mapbox/android/telemetry/CertificateBlacklist", (int)118);
        }
        return blArray;
    }
}

