/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.SharedPreferences;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

class TelemetryLocationEnabler {
    private static final String MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE = "mapboxTelemetryLocationState";
    private static final Map<String, LocationState> LOCATION_STATES = new HashMap<String, LocationState>(){
        {
            this.put(LocationState.ENABLED.name(), LocationState.ENABLED);
            this.put(LocationState.DISABLED.name(), LocationState.DISABLED);
        }
    };
    private boolean isFromPreferences = true;
    private LocationState currentTelemetryLocationState = LocationState.DISABLED;

    TelemetryLocationEnabler(boolean isFromPreferences) {
        this.isFromPreferences = isFromPreferences;
    }

    LocationState obtainTelemetryLocationState() {
        if (this.isFromPreferences) {
            return this.retrieveTelemetryLocationStateFromPreferences();
        }
        return this.currentTelemetryLocationState;
    }

    LocationState updateTelemetryLocationState(LocationState telemetryLocationState) {
        if (this.isFromPreferences) {
            return this.updateLocationPreferences(telemetryLocationState);
        }
        this.currentTelemetryLocationState = telemetryLocationState;
        return this.currentTelemetryLocationState;
    }

    void injectTelemetryLocationState(LocationState locationState) {
        this.currentTelemetryLocationState = locationState;
    }

    private LocationState retrieveTelemetryLocationStateFromPreferences() {
        if (MapboxTelemetry.applicationContext == null) {
            return LOCATION_STATES.get(LocationState.DISABLED.name());
        }
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences();
        String telemetryStateName = sharedPreferences.getString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, LocationState.DISABLED.name());
        return LOCATION_STATES.get(telemetryStateName);
    }

    private LocationState updateLocationPreferences(LocationState telemetryLocationState) {
        if (MapboxTelemetry.applicationContext == null) {
            return telemetryLocationState;
        }
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, telemetryLocationState.name());
        editor.apply();
        return telemetryLocationState;
    }

    static enum LocationState {
        ENABLED,
        DISABLED;

    }
}

