/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

class TelemetryLocationEnabler {
    private static final String MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE = "mapboxTelemetryLocationState";
    private static final Map<String, LocationState> LOCATION_STATES = new HashMap<String, LocationState>(){
        {
            this.put(LocationState.ENABLED.name(), LocationState.ENABLED);
            this.put(LocationState.DISABLED.name(), LocationState.DISABLED);
        }
    };
    private boolean isFromPreferences;
    private LocationState currentTelemetryLocationState = LocationState.DISABLED;

    TelemetryLocationEnabler(boolean isFromPreferences) {
        this.isFromPreferences = isFromPreferences;
    }

    LocationState obtainTelemetryLocationState(Context context) {
        if (this.isFromPreferences) {
            return this.retrieveTelemetryLocationStateFromPreferences(context);
        }
        return this.currentTelemetryLocationState;
    }

    LocationState updateTelemetryLocationState(LocationState telemetryLocationState, Context context) {
        if (this.isFromPreferences) {
            return this.updateLocationPreferences(telemetryLocationState, context);
        }
        this.currentTelemetryLocationState = telemetryLocationState;
        return this.currentTelemetryLocationState;
    }

    void injectTelemetryLocationState(LocationState locationState) {
        this.currentTelemetryLocationState = locationState;
    }

    private LocationState retrieveTelemetryLocationStateFromPreferences(Context context) {
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(context);
        String telemetryStateName = sharedPreferences.getString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, LocationState.DISABLED.name());
        return telemetryStateName != null ? LOCATION_STATES.get(telemetryStateName) : LOCATION_STATES.get(LocationState.DISABLED.name());
    }

    private LocationState updateLocationPreferences(LocationState telemetryLocationState, Context context) {
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, telemetryLocationState.name());
        editor.apply();
        return telemetryLocationState;
    }

    static enum LocationState {
        ENABLED,
        DISABLED;

    }
}

