/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.telemetry.TelemetryUtils;

class SessionIdentifier {
    private static final int HOURS_TO_MILLISECONDS = 3600000;
    private String sessionId = null;
    private long lastSessionIdUpdate;
    private static final int DEFAULT_ROTATION_HOURS = 24;
    private int rotationInterval = 24;

    SessionIdentifier() {
    }

    SessionIdentifier(int rotationInterval) {
        this.rotationInterval = rotationInterval;
    }

    String getSessionId() {
        long timeDiff = System.currentTimeMillis() - this.lastSessionIdUpdate;
        if (timeDiff >= (long)(this.rotationInterval * 3600000) || this.sessionId == null) {
            this.sessionId = TelemetryUtils.obtainUniversalUniqueIdentifier();
            this.lastSessionIdUpdate = System.currentTimeMillis();
        }
        return this.sessionId;
    }
}

