/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;

class EventReceiver
extends BroadcastReceiver {
    private static final String EVENT_RECEIVED_INTENT_KEY = "event_received";
    private static final String ON_EVENT_INTENT_EXTRA = "onEvent";
    private static final String EVENT_INTENT_KEY = "event";
    static final String EVENT_RECEIVER_INTENT = "com.mapbox.event_receiver";
    private EventCallback callback = null;

    EventReceiver(@NonNull EventCallback callback) {
        this.callback = callback;
    }

    public void onReceive(Context context, Intent intent) {
        String eventReceived = intent.getStringExtra(EVENT_RECEIVED_INTENT_KEY);
        if (ON_EVENT_INTENT_EXTRA.equals(eventReceived)) {
            Event event = (Event)intent.getExtras().getParcelable(EVENT_INTENT_KEY);
            this.callback.onEventReceived(event);
        }
    }

    static Intent supplyIntent(Event event) {
        Intent eventIntent = new Intent(EVENT_RECEIVER_INTENT);
        eventIntent.putExtra(EVENT_RECEIVED_INTENT_KEY, ON_EVENT_INTENT_EXTRA);
        eventIntent.putExtra(EVENT_INTENT_KEY, (Parcelable)event);
        return eventIntent;
    }
}

