/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;

class LocationEvent
extends Event
implements Parcelable {
    private static final String LOCATION = "location";
    private static final String SOURCE_MAPBOX = "mapbox";
    private static final String OPERATING_SYSTEM = "Android - " + Build.VERSION.RELEASE;
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="source")
    private String source;
    @SerializedName(value="sessionId")
    private final String sessionId;
    @SerializedName(value="lat")
    private final double latitude;
    @SerializedName(value="lng")
    private final double longitude;
    @SerializedName(value="altitude")
    private Double altitude = null;
    @SerializedName(value="operatingSystem")
    private String operatingSystem;
    @SerializedName(value="applicationState")
    private String applicationState;
    @SerializedName(value="horizontalAccuracy")
    private Float accuracy = null;
    public static final Parcelable.Creator<LocationEvent> CREATOR = new Parcelable.Creator<LocationEvent>(){

        public LocationEvent createFromParcel(Parcel in) {
            return new LocationEvent(in);
        }

        public LocationEvent[] newArray(int size) {
            return new LocationEvent[size];
        }
    };

    public LocationEvent(String sessionId, double latitude, double longitude) {
        this.event = LOCATION;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.source = SOURCE_MAPBOX;
        this.sessionId = sessionId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.operatingSystem = OPERATING_SYSTEM;
        this.applicationState = TelemetryUtils.obtainApplicationState();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.LOCATION;
    }

    String getEvent() {
        return this.event;
    }

    String getSource() {
        return this.source;
    }

    double getLatitude() {
        return this.latitude;
    }

    double getLongitude() {
        return this.longitude;
    }

    Double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    Float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Float accuracy) {
        this.accuracy = accuracy;
    }

    private LocationEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.source = in.readString();
        this.sessionId = in.readString();
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.altitude = in.readByte() == 0 ? null : Double.valueOf(in.readDouble());
        this.operatingSystem = in.readString();
        this.applicationState = in.readString();
        this.accuracy = in.readByte() == 0 ? null : Float.valueOf(in.readFloat());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeString(this.source);
        dest.writeString(this.sessionId);
        dest.writeDouble(this.latitude);
        dest.writeDouble(this.longitude);
        if (this.altitude == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeDouble(this.altitude.doubleValue());
        }
        dest.writeString(this.operatingSystem);
        dest.writeString(this.applicationState);
        if (this.accuracy == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeFloat(this.accuracy.floatValue());
        }
    }
}

