/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public abstract class Source {
    private static final String TAG = "Mbgl-Source";
    @Keep
    private long nativePtr;
    protected boolean detached;

    @Keep
    protected Source(long nativePtr) {
        this.checkThread();
        this.nativePtr = nativePtr;
    }

    public Source() {
        this.checkThread();
    }

    protected void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    @NonNull
    public String getId() {
        this.checkThread();
        return this.nativeGetId();
    }

    @NonNull
    public String getAttribution() {
        this.checkThread();
        return this.nativeGetAttribution();
    }

    @Nullable
    public Integer getPrefetchZoomDelta() {
        return this.nativeGetPrefetchZoomDelta();
    }

    public void setPrefetchZoomDelta(@Nullable Integer delta) {
        this.nativeSetPrefetchZoomDelta(delta);
    }

    public void setMaxOverscaleFactorForParentTiles(@Nullable Integer maxOverscaleFactor) {
        this.nativeSetMaxOverscaleFactorForParentTiles(maxOverscaleFactor);
    }

    @Nullable
    public Integer getMaxOverscaleFactorForParentTiles() {
        return this.nativeGetMaxOverscaleFactorForParentTiles();
    }

    public long getNativePtr() {
        return this.nativePtr;
    }

    @NonNull
    @Keep
    protected native String nativeGetId();

    @NonNull
    @Keep
    protected native String nativeGetAttribution();

    @NonNull
    @Keep
    protected native Integer nativeGetPrefetchZoomDelta();

    @NonNull
    @Keep
    protected native void nativeSetPrefetchZoomDelta(Integer var1);

    @NonNull
    @Keep
    protected native void nativeSetMaxOverscaleFactorForParentTiles(Integer var1);

    @NonNull
    @Keep
    protected native Integer nativeGetMaxOverscaleFactorForParentTiles();

    public void setDetached() {
        this.detached = true;
    }

    static {
        LibraryLoader.load();
    }
}

