/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentPositionManager;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.Set;

final class SymbolLocationLayerRenderer
implements LocationLayerRenderer {
    private Style style;
    private final LayerSourceProvider layerSourceProvider;
    private final Set<String> layerSet;
    private Feature locationFeature;
    private GeoJsonSource locationSource;

    SymbolLocationLayerRenderer(LayerSourceProvider layerSourceProvider, LayerFeatureProvider featureProvider, boolean isStale) {
        this.layerSourceProvider = layerSourceProvider;
        this.layerSet = layerSourceProvider.getEmptyLayerSet();
        this.locationFeature = featureProvider.generateLocationFeature(this.locationFeature, isStale);
    }

    @Override
    public void initializeComponents(Style style2) {
        this.style = style2;
        this.addLocationSource();
    }

    @Override
    public void addLayers(LocationComponentPositionManager positionManager) {
        Layer layer = this.layerSourceProvider.generateLayer("mapbox-location-bearing-layer");
        positionManager.addLayerToMap(layer);
        this.layerSet.add(layer.getId());
        this.addSymbolLayer("mapbox-location-foreground-layer", "mapbox-location-bearing-layer");
        this.addSymbolLayer("mapbox-location-background-layer", "mapbox-location-foreground-layer");
        this.addSymbolLayer("mapbox-location-shadow-layer", "mapbox-location-background-layer");
        this.addAccuracyLayer();
    }

    @Override
    public void removeLayers() {
        for (String layerId : this.layerSet) {
            this.style.removeLayer(layerId);
        }
        this.layerSet.clear();
    }

    @Override
    public void hide() {
        for (String layerId : this.layerSet) {
            this.setLayerVisibility(layerId, false);
        }
    }

    @Override
    public void cameraTiltUpdated(double tilt) {
        this.updateForegroundOffset(tilt);
    }

    @Override
    public void cameraBearingUpdated(double bearing) {
        this.updateForegroundBearing((float)bearing);
    }

    @Override
    public void show(int renderMode, boolean isStale) {
        switch (renderMode) {
            case 18: {
                this.setLayerVisibility("mapbox-location-shadow-layer", true);
                this.setLayerVisibility("mapbox-location-foreground-layer", true);
                this.setLayerVisibility("mapbox-location-background-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                this.setLayerVisibility("mapbox-location-bearing-layer", false);
                break;
            }
            case 4: {
                this.setLayerVisibility("mapbox-location-shadow-layer", true);
                this.setLayerVisibility("mapbox-location-foreground-layer", true);
                this.setLayerVisibility("mapbox-location-background-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
                this.setLayerVisibility("mapbox-location-bearing-layer", true);
                break;
            }
            case 8: {
                this.setLayerVisibility("mapbox-location-shadow-layer", false);
                this.setLayerVisibility("mapbox-location-foreground-layer", true);
                this.setLayerVisibility("mapbox-location-background-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", false);
                this.setLayerVisibility("mapbox-location-bearing-layer", false);
                break;
            }
        }
    }

    @Override
    public void styleAccuracy(float accuracyAlpha, int accuracyColor) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-alpha", (Number)Float.valueOf(accuracyAlpha));
        this.locationFeature.addStringProperty("mapbox-property-accuracy-color", ColorUtils.colorToRgbaString(accuracyColor));
        this.refreshSource();
    }

    @Override
    public void setLatLng(LatLng latLng) {
        Point point = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        this.setLocationPoint(point);
    }

    @Override
    public void setGpsBearing(Float gpsBearing) {
        this.setBearingProperty("mapbox-property-gps-bearing", gpsBearing.floatValue());
    }

    @Override
    public void setCompassBearing(Float compassBearing) {
        this.setBearingProperty("mapbox-property-compass-bearing", compassBearing.floatValue());
    }

    @Override
    public void setAccuracyRadius(Float accuracy) {
        this.updateAccuracyRadius(accuracy.floatValue());
    }

    @Override
    public void styleScaling(Expression scaleExpression) {
        for (String layerId : this.layerSet) {
            Layer layer = this.style.getLayer(layerId);
            if (!(layer instanceof SymbolLayer)) continue;
            layer.setProperties(PropertyFactory.iconSize(scaleExpression));
        }
    }

    @Override
    public void setLocationStale(boolean isStale, int renderMode) {
        this.locationFeature.addBooleanProperty("mapbox-property-location-stale", Boolean.valueOf(isStale));
        this.refreshSource();
        if (renderMode != 8) {
            this.setLayerVisibility("mapbox-location-accuracy-layer", !isStale);
        }
    }

    @Override
    public void updateIconIds(String foregroundIconString, String foregroundStaleIconString, String backgroundIconString, String backgroundStaleIconString, String bearingIconString) {
        this.locationFeature.addStringProperty("mapbox-property-foreground-icon", foregroundIconString);
        this.locationFeature.addStringProperty("mapbox-property-background-icon", backgroundIconString);
        this.locationFeature.addStringProperty("mapbox-property-foreground-stale-icon", foregroundStaleIconString);
        this.locationFeature.addStringProperty("mapbox-property-background-stale-icon", backgroundStaleIconString);
        this.locationFeature.addStringProperty("mapbox-property-shadow-icon", bearingIconString);
        this.refreshSource();
    }

    @Override
    public void addBitmaps(int renderMode, @Nullable Bitmap shadowBitmap, Bitmap backgroundBitmap, Bitmap backgroundStaleBitmap, Bitmap bearingBitmap, Bitmap foregroundBitmap, Bitmap foregroundBitmapStale) {
        if (shadowBitmap != null) {
            this.style.addImage("mapbox-location-shadow-icon", shadowBitmap);
        } else {
            this.style.removeImage("mapbox-location-shadow-icon");
        }
        this.style.addImage("mapbox-location-stroke-icon", backgroundBitmap);
        this.style.addImage("mapbox-location-background-stale-icon", backgroundStaleBitmap);
        this.style.addImage("mapbox-location-bearing-icon", bearingBitmap);
        this.style.addImage("mapbox-location-icon", foregroundBitmap);
        this.style.addImage("mapbox-location-stale-icon", foregroundBitmapStale);
    }

    private void updateForegroundOffset(double tilt) {
        JsonArray foregroundJsonArray = new JsonArray();
        foregroundJsonArray.add((Number)Float.valueOf(0.0f));
        foregroundJsonArray.add((Number)Float.valueOf((float)(-0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-foreground-icon-offset", (JsonElement)foregroundJsonArray);
        JsonArray backgroundJsonArray = new JsonArray();
        backgroundJsonArray.add((Number)Float.valueOf(0.0f));
        backgroundJsonArray.add((Number)Float.valueOf((float)(0.05 * tilt)));
        this.locationFeature.addProperty("mapbox-property-shadow-icon-offset", (JsonElement)backgroundJsonArray);
        this.refreshSource();
    }

    private void updateForegroundBearing(float bearing) {
        this.setBearingProperty("mapbox-property-gps-bearing", bearing);
    }

    private void setLayerVisibility(@NonNull String layerId, boolean visible) {
        Layer layer = this.style.getLayer(layerId);
        if (layer != null) {
            String targetVisibility;
            String string2 = targetVisibility = visible ? "visible" : "none";
            if (!((String)layer.getVisibility().value).equals(targetVisibility)) {
                layer.setProperties(PropertyFactory.visibility(visible ? "visible" : "none"));
            }
        }
    }

    private void addSymbolLayer(@NonNull String layerId, @NonNull String beforeLayerId) {
        Layer layer = this.layerSourceProvider.generateLayer(layerId);
        this.addLayerToMap(layer, beforeLayerId);
    }

    private void addAccuracyLayer() {
        Layer accuracyLayer = this.layerSourceProvider.generateAccuracyLayer();
        this.addLayerToMap(accuracyLayer, "mapbox-location-background-layer");
    }

    private void addLayerToMap(Layer layer, @NonNull String idBelowLayer) {
        this.style.addLayerBelow(layer, idBelowLayer);
        this.layerSet.add(layer.getId());
    }

    private void addLocationSource() {
        this.locationSource = this.layerSourceProvider.generateSource(this.locationFeature);
        this.style.addSource(this.locationSource);
    }

    private void refreshSource() {
        GeoJsonSource source = (GeoJsonSource)this.style.getSourceAs("mapbox-location-source");
        if (source != null) {
            this.locationSource.setGeoJson(this.locationFeature);
        }
    }

    private void setLocationPoint(Point locationPoint) {
        JsonObject properties = this.locationFeature.properties();
        if (properties != null) {
            this.locationFeature = Feature.fromGeometry((Geometry)locationPoint, (JsonObject)properties);
            this.refreshSource();
        }
    }

    private void setBearingProperty(@NonNull String propertyId, float bearing) {
        this.locationFeature.addNumberProperty(propertyId, (Number)Float.valueOf(bearing));
        this.refreshSource();
    }

    private void updateAccuracyRadius(float accuracy) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-radius", (Number)Float.valueOf(accuracy));
        this.refreshSource();
    }
}

