/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.LayerBitmapProvider;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.LocationComponentPositionManager;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.OnRenderModeChangedListener;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class LocationLayerController {
    private static final String TAG = "Mbgl-LocationLayerController";
    private int renderMode;
    private final MapboxMap mapboxMap;
    private final LayerBitmapProvider bitmapProvider;
    private LocationComponentOptions options;
    private final OnRenderModeChangedListener internalRenderModeChangedListener;
    private final boolean useSpecializedLocationLayer;
    private boolean isHidden = true;
    private boolean isStale;
    private LocationComponentPositionManager positionManager;
    private LocationLayerRenderer locationLayerRenderer;
    private final MapboxAnimator.AnimationsValueChangeListener<LatLng> latLngValueListener = new MapboxAnimator.AnimationsValueChangeListener<LatLng>(){

        @Override
        public void onNewAnimationValue(LatLng value) {
            LocationLayerController.this.locationLayerRenderer.setLatLng(value);
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> gpsBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            LocationLayerController.this.locationLayerRenderer.setGpsBearing(value);
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> compassBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            LocationLayerController.this.locationLayerRenderer.setCompassBearing(value);
        }
    };
    private final MapboxAnimator.AnimationsValueChangeListener<Float> accuracyValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            LocationLayerController.this.locationLayerRenderer.setAccuracyRadius(value);
        }
    };

    LocationLayerController(MapboxMap mapboxMap, Style style2, LayerSourceProvider layerSourceProvider, LayerFeatureProvider featureProvider, LayerBitmapProvider bitmapProvider, @NonNull LocationComponentOptions options, @NonNull OnRenderModeChangedListener internalRenderModeChangedListener, boolean useSpecializedLocationLayer) {
        this.mapboxMap = mapboxMap;
        this.bitmapProvider = bitmapProvider;
        this.internalRenderModeChangedListener = internalRenderModeChangedListener;
        this.useSpecializedLocationLayer = useSpecializedLocationLayer;
        this.isStale = options.enableStaleState();
        this.locationLayerRenderer = useSpecializedLocationLayer ? layerSourceProvider.getIndicatorLocationLayerRenderer() : layerSourceProvider.getSymbolLocationLayerRenderer(featureProvider, this.isStale);
        this.initializeComponents(style2, options);
    }

    void initializeComponents(Style style2, LocationComponentOptions options) {
        this.positionManager = new LocationComponentPositionManager(style2, options.layerAbove(), options.layerBelow());
        this.locationLayerRenderer.initializeComponents(style2);
        this.locationLayerRenderer.addLayers(this.positionManager);
        this.applyStyle(options);
        if (this.isHidden) {
            this.hide();
        } else {
            this.show();
        }
    }

    void applyStyle(@NonNull LocationComponentOptions options) {
        if (this.positionManager.update(options.layerAbove(), options.layerBelow())) {
            this.locationLayerRenderer.removeLayers();
            this.locationLayerRenderer.addLayers(this.positionManager);
            if (this.isHidden) {
                this.hide();
            }
        }
        this.options = options;
        this.styleBitmaps(options);
        this.locationLayerRenderer.styleAccuracy(options.accuracyAlpha(), options.accuracyColor());
        this.styleScaling(options);
        this.determineIconsSource(options);
        if (!this.isHidden) {
            this.show();
        }
    }

    void setRenderMode(int renderMode) {
        if (this.renderMode == renderMode) {
            return;
        }
        this.renderMode = renderMode;
        this.styleBitmaps(this.options);
        this.determineIconsSource(this.options);
        if (!this.isHidden) {
            this.show();
        }
        this.internalRenderModeChangedListener.onRenderModeChanged(renderMode);
    }

    int getRenderMode() {
        return this.renderMode;
    }

    void show() {
        this.isHidden = false;
        this.locationLayerRenderer.show(this.renderMode, this.isStale);
    }

    void hide() {
        this.isHidden = true;
        this.locationLayerRenderer.hide();
    }

    boolean isHidden() {
        return this.isHidden;
    }

    boolean isConsumingCompass() {
        return this.renderMode == 4;
    }

    private void styleBitmaps(LocationComponentOptions options) {
        Bitmap shadowBitmap = null;
        if (options.elevation() > 0.0f) {
            shadowBitmap = this.bitmapProvider.generateShadowBitmap(options);
        }
        Bitmap backgroundBitmap = this.bitmapProvider.generateBitmap(options.backgroundDrawable(), options.backgroundTintColor());
        Bitmap backgroundStaleBitmap = this.bitmapProvider.generateBitmap(options.backgroundDrawableStale(), options.backgroundStaleTintColor());
        Bitmap bearingBitmap = this.bitmapProvider.generateBitmap(options.bearingDrawable(), options.bearingTintColor());
        Bitmap foregroundBitmap = this.bitmapProvider.generateBitmap(options.foregroundDrawable(), options.foregroundTintColor());
        Bitmap foregroundStaleBitmap = this.bitmapProvider.generateBitmap(options.foregroundDrawableStale(), options.foregroundStaleTintColor());
        if (this.renderMode == 8) {
            foregroundBitmap = this.bitmapProvider.generateBitmap(options.gpsDrawable(), options.foregroundTintColor());
            foregroundStaleBitmap = this.bitmapProvider.generateBitmap(options.gpsDrawable(), options.foregroundStaleTintColor());
        }
        this.locationLayerRenderer.addBitmaps(this.renderMode, shadowBitmap, backgroundBitmap, backgroundStaleBitmap, bearingBitmap, foregroundBitmap, foregroundStaleBitmap);
    }

    private void styleScaling(@NonNull LocationComponentOptions options) {
        Expression scaleExpression = Expression.interpolate(Expression.linear(), Expression.zoom(), Expression.stop(this.mapboxMap.getMinZoomLevel(), Float.valueOf(options.minZoomIconScale())), Expression.stop(this.mapboxMap.getMaxZoomLevel(), Float.valueOf(options.maxZoomIconScale())));
        this.locationLayerRenderer.styleScaling(scaleExpression);
    }

    private void determineIconsSource(LocationComponentOptions options) {
        String foregroundIconString = this.buildIconString(this.renderMode == 8 ? options.gpsName() : options.foregroundName(), "mapbox-location-icon");
        String foregroundStaleIconString = this.buildIconString(options.foregroundStaleName(), "mapbox-location-stale-icon");
        String backgroundIconString = this.buildIconString(options.backgroundName(), "mapbox-location-stroke-icon");
        String backgroundStaleIconString = this.buildIconString(options.backgroundStaleName(), "mapbox-location-background-stale-icon");
        String bearingIconString = this.buildIconString(options.bearingName(), "mapbox-location-bearing-icon");
        this.locationLayerRenderer.updateIconIds(foregroundIconString, foregroundStaleIconString, backgroundIconString, backgroundStaleIconString, bearingIconString);
    }

    @NonNull
    private String buildIconString(@Nullable String bitmapName, @NonNull String drawableName) {
        if (bitmapName != null) {
            if (this.useSpecializedLocationLayer) {
                Logger.e(TAG, bitmapName + " replacement ID provided for an unsupported specialized location layer");
                return drawableName;
            }
            return bitmapName;
        }
        return drawableName;
    }

    void setLocationsStale(boolean isStale) {
        this.isStale = isStale;
        this.locationLayerRenderer.setLocationStale(isStale, this.renderMode);
    }

    boolean onMapClick(@NonNull LatLng point) {
        PointF screenLoc = this.mapboxMap.getProjection().toScreenLocation(point);
        List<Feature> features = this.mapboxMap.queryRenderedFeatures(screenLoc, "mapbox-location-background-layer", "mapbox-location-foreground-layer", "mapbox-location-bearing-layer");
        return !features.isEmpty();
    }

    Set<AnimatorListenerHolder> getAnimationListeners() {
        HashSet<AnimatorListenerHolder> holders = new HashSet<AnimatorListenerHolder>();
        holders.add(new AnimatorListenerHolder(0, this.latLngValueListener));
        if (this.renderMode == 8) {
            holders.add(new AnimatorListenerHolder(2, this.gpsBearingValueListener));
        } else if (this.renderMode == 4) {
            holders.add(new AnimatorListenerHolder(3, this.compassBearingValueListener));
        }
        if (this.renderMode == 4 || this.renderMode == 18) {
            holders.add(new AnimatorListenerHolder(6, this.accuracyValueListener));
        }
        return holders;
    }

    void cameraBearingUpdated(double bearing) {
        if (this.renderMode != 8) {
            this.locationLayerRenderer.cameraBearingUpdated(bearing);
        }
    }

    void cameraTiltUpdated(double tilt) {
        this.locationLayerRenderer.cameraTiltUpdated(tilt);
    }
}

