/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import java.util.ArrayList;
import java.util.List;

@UiThread
public final class MapboxMap {
    private static final String TAG = "Mbgl-MapboxMap";
    private final NativeMap nativeMapView;
    private final UiSettings uiSettings;
    private final Projection projection;
    private final Transform transform;
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private final OnGesturesManagerInteractionListener onGesturesManagerInteractionListener;
    private final List<Style.OnStyleLoaded> awaitingStyleGetters = new ArrayList<Style.OnStyleLoaded>();
    private final List<OnDeveloperAnimationListener> developerAnimationStartedListeners;
    @Nullable
    private Style.OnStyleLoaded styleLoadedCallback;
    private LocationComponent locationComponent;
    private AnnotationManager annotationManager;
    @Nullable
    private OnFpsChangedListener onFpsChangedListener;
    @Nullable
    private Style style;
    private boolean debugActive;

    MapboxMap(NativeMap map, Transform transform, UiSettings ui, Projection projection, OnGesturesManagerInteractionListener listener, CameraChangeDispatcher cameraChangeDispatcher, List<OnDeveloperAnimationListener> developerAnimationStartedListeners) {
        this.nativeMapView = map;
        this.uiSettings = ui;
        this.projection = projection;
        this.transform = transform;
        this.onGesturesManagerInteractionListener = listener;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
        this.developerAnimationStartedListeners = developerAnimationStartedListeners;
    }

    public void triggerRepaint() {
        this.nativeMapView.triggerRepaint();
    }

    void initialise(@NonNull Context context, @NonNull MapboxMapOptions options) {
        this.transform.initialise(this, options);
        this.uiSettings.initialise(context, options);
        this.setDebugActive(options.getDebugActive());
        this.setApiBaseUrl(options);
        this.setPrefetchesTiles(options);
    }

    public void getStyle(@NonNull Style.OnStyleLoaded onStyleLoaded) {
        if (this.style != null && this.style.isFullyLoaded()) {
            onStyleLoaded.onStyleLoaded(this.style);
        } else {
            this.awaitingStyleGetters.add(onStyleLoaded);
        }
    }

    @Nullable
    public Style getStyle() {
        if (this.style == null || !this.style.isFullyLoaded()) {
            return null;
        }
        return this.style;
    }

    void onStart() {
        this.locationComponent.onStart();
    }

    void onStop() {
        this.locationComponent.onStop();
    }

    void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putParcelable("mapbox_cameraPosition", (Parcelable)this.transform.getCameraPosition());
        outState.putBoolean("mapbox_debugActive", this.isDebugActive());
        this.uiSettings.onSaveInstanceState(outState);
    }

    void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        CameraPosition cameraPosition = (CameraPosition)savedInstanceState.getParcelable("mapbox_cameraPosition");
        this.uiSettings.onRestoreInstanceState(savedInstanceState);
        if (cameraPosition != null) {
            this.moveCamera(CameraUpdateFactory.newCameraPosition(new CameraPosition.Builder(cameraPosition).build()));
        }
        this.nativeMapView.setDebug(savedInstanceState.getBoolean("mapbox_debugActive"));
    }

    void onDestroy() {
        this.locationComponent.onDestroy();
        if (this.style != null) {
            this.style.clear();
        }
        this.cameraChangeDispatcher.onDestroy();
    }

    void onPreMapReady() {
        this.transform.invalidateCameraPosition();
        this.annotationManager.reloadMarkers();
        this.annotationManager.adjustTopOffsetPixels(this);
    }

    void onPostMapReady() {
        this.transform.invalidateCameraPosition();
    }

    void onFinishLoadingStyle() {
        this.notifyStyleLoaded();
    }

    void onFailLoadingStyle() {
        this.styleLoadedCallback = null;
    }

    void onUpdateRegionChange() {
        this.annotationManager.update();
    }

    void onUpdateFullyRendered() {
        CameraPosition cameraPosition = this.transform.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.uiSettings.update(cameraPosition);
        }
    }

    long getNativeMapPtr() {
        return this.nativeMapView.getNativePtr();
    }

    private void setPrefetchesTiles(@NonNull MapboxMapOptions options) {
        if (!options.getPrefetchesTiles()) {
            this.setPrefetchZoomDelta(0);
        } else {
            this.setPrefetchZoomDelta(options.getPrefetchZoomDelta());
        }
    }

    @Deprecated
    public void setPrefetchesTiles(boolean enable) {
        this.nativeMapView.setPrefetchTiles(enable);
    }

    @Deprecated
    public boolean getPrefetchesTiles() {
        return this.nativeMapView.getPrefetchTiles();
    }

    public void setPrefetchZoomDelta(@IntRange(from=0L) int delta) {
        this.nativeMapView.setPrefetchZoomDelta(delta);
    }

    @IntRange(from=0L)
    public int getPrefetchZoomDelta() {
        return this.nativeMapView.getPrefetchZoomDelta();
    }

    public void setMinZoomPreference(@FloatRange(from=0.0, to=25.5) double minZoom) {
        this.transform.setMinZoom(minZoom);
    }

    public double getMinZoomLevel() {
        return this.transform.getMinZoom();
    }

    public void setMaxZoomPreference(@FloatRange(from=0.0, to=25.5) double maxZoom) {
        this.transform.setMaxZoom(maxZoom);
    }

    public double getMaxZoomLevel() {
        return this.transform.getMaxZoom();
    }

    public void setMinPitchPreference(@FloatRange(from=0.0, to=60.0) double minPitch) {
        this.transform.setMinPitch(minPitch);
    }

    public double getMinPitch() {
        return this.transform.getMinPitch();
    }

    public void setMaxPitchPreference(@FloatRange(from=0.0, to=60.0) double maxPitch) {
        this.transform.setMaxPitch(maxPitch);
    }

    public double getMaxPitch() {
        return this.transform.getMaxPitch();
    }

    @NonNull
    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    @NonNull
    public Projection getProjection() {
        return this.projection;
    }

    public void cancelTransitions() {
        this.transform.cancelTransitions();
    }

    @NonNull
    public final CameraPosition getCameraPosition() {
        return this.transform.getCameraPosition();
    }

    public void setCameraPosition(@NonNull CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), null);
    }

    public final void moveCamera(@NonNull CameraUpdate update) {
        this.moveCamera(update, null);
    }

    public final void moveCamera(@NonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        this.notifyDeveloperAnimationListeners();
        this.transform.moveCamera(this, update, callback);
    }

    public final void easeCamera(@NonNull CameraUpdate update) {
        this.easeCamera(update, 300);
    }

    public final void easeCamera(@NonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        this.easeCamera(update, 300, callback);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs) {
        this.easeCamera(update, durationMs, null);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, @Nullable CancelableCallback callback) {
        this.easeCamera(update, durationMs, true, callback);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, boolean easingInterpolator) {
        this.easeCamera(update, durationMs, easingInterpolator, null);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, boolean easingInterpolator, @Nullable CancelableCallback callback) {
        if (durationMs <= 0) {
            throw new IllegalArgumentException("Null duration passed into easeCamera");
        }
        this.notifyDeveloperAnimationListeners();
        this.transform.easeCamera(this, update, durationMs, easingInterpolator, callback);
    }

    public final void animateCamera(@NonNull CameraUpdate update) {
        this.animateCamera(update, 300, null);
    }

    public final void animateCamera(@NonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        this.animateCamera(update, 300, callback);
    }

    public final void animateCamera(@NonNull CameraUpdate update, int durationMs) {
        this.animateCamera(update, durationMs, null);
    }

    public final void animateCamera(@NonNull CameraUpdate update, int durationMs, @Nullable CancelableCallback callback) {
        if (durationMs <= 0) {
            throw new IllegalArgumentException("Null duration passed into animateCamera");
        }
        this.notifyDeveloperAnimationListeners();
        this.transform.animateCamera(this, update, durationMs, callback);
    }

    public void scrollBy(float x, float y) {
        this.scrollBy(x, y, 0L);
    }

    public void scrollBy(float x, float y, long duration) {
        this.notifyDeveloperAnimationListeners();
        this.nativeMapView.moveBy(x, y, duration);
    }

    public void resetNorth() {
        this.notifyDeveloperAnimationListeners();
        this.transform.resetNorth();
    }

    public void setFocalBearing(double bearing, float focalX, float focalY, long duration) {
        this.notifyDeveloperAnimationListeners();
        this.transform.setBearing(bearing, focalX, focalY, duration);
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    public void setOfflineRegionDefinition(@NonNull OfflineRegionDefinition definition) {
        this.setOfflineRegionDefinition(definition, null);
    }

    public void setOfflineRegionDefinition(@NonNull OfflineRegionDefinition definition, @Nullable Style.OnStyleLoaded callback) {
        double minZoom = definition.getMinZoom();
        double maxZoom = definition.getMaxZoom();
        CameraPosition cameraPosition = new CameraPosition.Builder().target(definition.getBounds().getCenter()).zoom(minZoom).build();
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
        this.setMinZoomPreference(minZoom);
        this.setMaxZoomPreference(maxZoom);
        this.setStyle(new Style.Builder().fromUri(definition.getStyleURL()), callback);
    }

    public boolean isDebugActive() {
        return this.debugActive;
    }

    public void setDebugActive(boolean debugActive) {
        this.debugActive = debugActive;
        this.nativeMapView.setDebug(debugActive);
    }

    @Deprecated
    public void cycleDebugOptions() {
        this.debugActive = !this.nativeMapView.getDebug();
        this.nativeMapView.setDebug(this.debugActive);
    }

    private void setApiBaseUrl(@NonNull MapboxMapOptions options) {
        String apiBaseUrl = options.getApiBaseUrl();
        if (!TextUtils.isEmpty((CharSequence)apiBaseUrl)) {
            this.nativeMapView.setApiBaseUrl(apiBaseUrl);
        }
    }

    public void setStyle(String style2) {
        this.setStyle(style2, null);
    }

    public void setStyle(String style2, Style.OnStyleLoaded callback) {
        this.setStyle(new Style.Builder().fromUri(style2), callback);
    }

    public void setStyle(Style.Builder builder) {
        this.setStyle(builder, null);
    }

    public void setStyle(Style.Builder builder, Style.OnStyleLoaded callback) {
        this.styleLoadedCallback = callback;
        this.locationComponent.onStartLoadingMap();
        if (this.style != null) {
            this.style.clear();
        }
        this.style = builder.build(this.nativeMapView);
        if (!TextUtils.isEmpty((CharSequence)builder.getUri())) {
            this.nativeMapView.setStyleUri(builder.getUri());
        } else if (!TextUtils.isEmpty((CharSequence)builder.getJson())) {
            this.nativeMapView.setStyleJson(builder.getJson());
        } else {
            this.nativeMapView.setStyleJson("{\"version\": 8,\"sources\": {},\"layers\": []}");
        }
    }

    void notifyStyleLoaded() {
        if (this.nativeMapView.isDestroyed()) {
            return;
        }
        if (this.style != null) {
            this.style.onDidFinishLoadingStyle();
            this.locationComponent.onFinishLoadingStyle();
            if (this.styleLoadedCallback != null) {
                this.styleLoadedCallback.onStyleLoaded(this.style);
            }
            for (Style.OnStyleLoaded styleGetter : this.awaitingStyleGetters) {
                styleGetter.onStyleLoaded(this.style);
            }
        } else {
            MapStrictMode.strictModeViolation("No style to provide.");
        }
        this.styleLoadedCallback = null;
        this.awaitingStyleGetters.clear();
    }

    @Deprecated
    @NonNull
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @Deprecated
    @NonNull
    public Marker addMarker(@NonNull BaseMarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @Deprecated
    @NonNull
    public List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList) {
        return this.annotationManager.addMarkers(markerOptionsList, this);
    }

    @Deprecated
    public void updateMarker(@NonNull Marker updatedMarker) {
        this.annotationManager.updateMarker(updatedMarker, this);
    }

    @Deprecated
    @NonNull
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        return this.annotationManager.addPolyline(polylineOptions, this);
    }

    @Deprecated
    @NonNull
    public List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList) {
        return this.annotationManager.addPolylines(polylineOptionsList, this);
    }

    @Deprecated
    public void updatePolyline(@NonNull Polyline polyline) {
        this.annotationManager.updatePolyline(polyline);
    }

    @Deprecated
    @NonNull
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        return this.annotationManager.addPolygon(polygonOptions, this);
    }

    @Deprecated
    @NonNull
    public List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList) {
        return this.annotationManager.addPolygons(polygonOptionsList, this);
    }

    @Deprecated
    public void updatePolygon(@NonNull Polygon polygon) {
        this.annotationManager.updatePolygon(polygon);
    }

    @Deprecated
    public void removeMarker(@NonNull Marker marker) {
        this.annotationManager.removeAnnotation(marker);
    }

    @Deprecated
    public void removePolyline(@NonNull Polyline polyline) {
        this.annotationManager.removeAnnotation(polyline);
    }

    @Deprecated
    public void removePolygon(@NonNull Polygon polygon) {
        this.annotationManager.removeAnnotation(polygon);
    }

    @Deprecated
    public void removeAnnotation(@NonNull Annotation annotation) {
        this.annotationManager.removeAnnotation(annotation);
    }

    @Deprecated
    public void removeAnnotation(long id2) {
        this.annotationManager.removeAnnotation(id2);
    }

    @Deprecated
    public void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        this.annotationManager.removeAnnotations(annotationList);
    }

    @Deprecated
    public void removeAnnotations() {
        this.annotationManager.removeAnnotations();
    }

    @Deprecated
    public void clear() {
        this.annotationManager.removeAnnotations();
    }

    @Deprecated
    @Nullable
    public Annotation getAnnotation(long id2) {
        return this.annotationManager.getAnnotation(id2);
    }

    @Deprecated
    @NonNull
    public List<Annotation> getAnnotations() {
        return this.annotationManager.getAnnotations();
    }

    @Deprecated
    @NonNull
    public List<Marker> getMarkers() {
        return this.annotationManager.getMarkers();
    }

    @Deprecated
    @NonNull
    public List<Polygon> getPolygons() {
        return this.annotationManager.getPolygons();
    }

    @Deprecated
    @NonNull
    public List<Polyline> getPolylines() {
        return this.annotationManager.getPolylines();
    }

    @Deprecated
    public void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        this.annotationManager.setOnMarkerClickListener(listener);
    }

    @Deprecated
    public void setOnPolygonClickListener(@Nullable OnPolygonClickListener listener) {
        this.annotationManager.setOnPolygonClickListener(listener);
    }

    @Deprecated
    public void setOnPolylineClickListener(@Nullable OnPolylineClickListener listener) {
        this.annotationManager.setOnPolylineClickListener(listener);
    }

    @Deprecated
    public void selectMarker(@NonNull Marker marker) {
        if (marker == null) {
            Logger.w(TAG, "marker was null, so just returning");
            return;
        }
        this.annotationManager.selectMarker(marker);
    }

    @Deprecated
    public void deselectMarkers() {
        this.annotationManager.deselectMarkers();
    }

    @Deprecated
    public void deselectMarker(@NonNull Marker marker) {
        this.annotationManager.deselectMarker(marker);
    }

    @Deprecated
    @NonNull
    public List<Marker> getSelectedMarkers() {
        return this.annotationManager.getSelectedMarkers();
    }

    @Deprecated
    public void setInfoWindowAdapter(@Nullable InfoWindowAdapter infoWindowAdapter) {
        this.annotationManager.getInfoWindowManager().setInfoWindowAdapter(infoWindowAdapter);
    }

    @Deprecated
    @Nullable
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.annotationManager.getInfoWindowManager().getInfoWindowAdapter();
    }

    @Deprecated
    public void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.annotationManager.getInfoWindowManager().setAllowConcurrentMultipleOpenInfoWindows(allow);
    }

    @Deprecated
    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.annotationManager.getInfoWindowManager().isAllowConcurrentMultipleOpenInfoWindows();
    }

    public void setLatLngBoundsForCameraTarget(@Nullable LatLngBounds latLngBounds) {
        this.nativeMapView.setLatLngBounds(latLngBounds);
    }

    @Nullable
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds) {
        return this.getCameraForLatLngBounds(latLngBounds, new int[]{0, 0, 0, 0});
    }

    @Nullable
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds, @NonNull @Size(value=4L) int[] padding) {
        return this.getCameraForLatLngBounds(latLngBounds, padding, this.transform.getRawBearing(), this.transform.getTilt());
    }

    @Nullable
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.getCameraForLatLngBounds(latLngBounds, new int[]{0, 0, 0, 0}, bearing, tilt);
    }

    @Nullable
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds, @NonNull @Size(value=4L) int[] padding, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.nativeMapView.getCameraForLatLngBounds(latLngBounds, padding, bearing, tilt);
    }

    @Nullable
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry) {
        return this.getCameraForGeometry(geometry, new int[]{0, 0, 0, 0});
    }

    @Nullable
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry, @NonNull @Size(value=4L) int[] padding) {
        return this.getCameraForGeometry(geometry, padding, this.transform.getBearing(), this.transform.getTilt());
    }

    @Nullable
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.getCameraForGeometry(geometry, new int[]{0, 0, 0, 0}, bearing, tilt);
    }

    @Nullable
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry, @NonNull @Size(value=4L) int[] padding, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.nativeMapView.getCameraForGeometry(geometry, padding, bearing, tilt);
    }

    @Deprecated
    public void setPadding(int left, int top, int right, int bottom) {
        this.projection.setContentPadding(new int[]{left, top, right, bottom});
        this.uiSettings.invalidate();
    }

    @Deprecated
    @NonNull
    public int[] getPadding() {
        return this.projection.getContentPadding();
    }

    public void addOnCameraIdleListener(@NonNull OnCameraIdleListener listener) {
        this.cameraChangeDispatcher.addOnCameraIdleListener(listener);
    }

    public void removeOnCameraIdleListener(@NonNull OnCameraIdleListener listener) {
        this.cameraChangeDispatcher.removeOnCameraIdleListener(listener);
    }

    public void addOnCameraMoveCancelListener(@NonNull OnCameraMoveCanceledListener listener) {
        this.cameraChangeDispatcher.addOnCameraMoveCancelListener(listener);
    }

    public void removeOnCameraMoveCancelListener(@NonNull OnCameraMoveCanceledListener listener) {
        this.cameraChangeDispatcher.removeOnCameraMoveCancelListener(listener);
    }

    public void addOnCameraMoveStartedListener(@NonNull OnCameraMoveStartedListener listener) {
        this.cameraChangeDispatcher.addOnCameraMoveStartedListener(listener);
    }

    public void removeOnCameraMoveStartedListener(@NonNull OnCameraMoveStartedListener listener) {
        this.cameraChangeDispatcher.removeOnCameraMoveStartedListener(listener);
    }

    public void addOnCameraMoveListener(@NonNull OnCameraMoveListener listener) {
        this.cameraChangeDispatcher.addOnCameraMoveListener(listener);
    }

    public void removeOnCameraMoveListener(@NonNull OnCameraMoveListener listener) {
        this.cameraChangeDispatcher.removeOnCameraMoveListener(listener);
    }

    public void setOnFpsChangedListener(@Nullable OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
        this.nativeMapView.setOnFpsChangedListener(listener);
    }

    @Nullable
    OnFpsChangedListener getOnFpsChangedListener() {
        return this.onFpsChangedListener;
    }

    public void addOnFlingListener(@NonNull OnFlingListener listener) {
        this.onGesturesManagerInteractionListener.onAddFlingListener(listener);
    }

    public void removeOnFlingListener(@NonNull OnFlingListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveFlingListener(listener);
    }

    public void addOnMoveListener(@NonNull OnMoveListener listener) {
        this.onGesturesManagerInteractionListener.onAddMoveListener(listener);
    }

    public void removeOnMoveListener(@NonNull OnMoveListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveMoveListener(listener);
    }

    public void addOnRotateListener(@NonNull OnRotateListener listener) {
        this.onGesturesManagerInteractionListener.onAddRotateListener(listener);
    }

    public void removeOnRotateListener(@NonNull OnRotateListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveRotateListener(listener);
    }

    public void addOnScaleListener(@NonNull OnScaleListener listener) {
        this.onGesturesManagerInteractionListener.onAddScaleListener(listener);
    }

    public void removeOnScaleListener(@NonNull OnScaleListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveScaleListener(listener);
    }

    public void addOnShoveListener(@NonNull OnShoveListener listener) {
        this.onGesturesManagerInteractionListener.onAddShoveListener(listener);
    }

    public void removeOnShoveListener(@NonNull OnShoveListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveShoveListener(listener);
    }

    public void setGesturesManager(@NonNull AndroidGesturesManager androidGesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
        this.onGesturesManagerInteractionListener.setGesturesManager(androidGesturesManager, attachDefaultListeners, setDefaultMutuallyExclusives);
    }

    @NonNull
    public AndroidGesturesManager getGesturesManager() {
        return this.onGesturesManagerInteractionListener.getGesturesManager();
    }

    public void cancelAllVelocityAnimations() {
        this.onGesturesManagerInteractionListener.cancelAllVelocityAnimations();
    }

    public void addOnMapClickListener(@NonNull OnMapClickListener listener) {
        this.onGesturesManagerInteractionListener.onAddMapClickListener(listener);
    }

    public void removeOnMapClickListener(@NonNull OnMapClickListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveMapClickListener(listener);
    }

    public void addOnMapLongClickListener(@NonNull OnMapLongClickListener listener) {
        this.onGesturesManagerInteractionListener.onAddMapLongClickListener(listener);
    }

    public void removeOnMapLongClickListener(@NonNull OnMapLongClickListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveMapLongClickListener(listener);
    }

    public void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowClickListener(listener);
    }

    @Nullable
    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowClickListener();
    }

    public void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowLongClickListener(listener);
    }

    @Nullable
    public OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowLongClickListener();
    }

    public void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowCloseListener(listener);
    }

    @Nullable
    public OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowCloseListener();
    }

    public void snapshot(@NonNull SnapshotReadyCallback callback) {
        this.nativeMapView.addSnapshotCallback(callback);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, null);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, @Nullable Expression filter, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, filter);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, null);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, @Nullable Expression filter, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, filter);
    }

    void injectLocationComponent(LocationComponent locationComponent) {
        this.locationComponent = locationComponent;
    }

    void injectAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager.bind(this);
    }

    @NonNull
    public LocationComponent getLocationComponent() {
        return this.locationComponent;
    }

    @NonNull
    Transform getTransform() {
        return this.transform;
    }

    private void notifyDeveloperAnimationListeners() {
        for (OnDeveloperAnimationListener listener : this.developerAnimationStartedListeners) {
            listener.onDeveloperAnimationStarted();
        }
    }

    public static interface OnDeveloperAnimationListener {
        public void onDeveloperAnimationStarted();
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(@NonNull Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    @Deprecated
    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(@NonNull Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(@NonNull Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onInfoWindowClick(@NonNull Marker var1);
    }

    @Deprecated
    public static interface OnPolylineClickListener {
        public void onPolylineClick(@NonNull Polyline var1);
    }

    @Deprecated
    public static interface OnPolygonClickListener {
        public void onPolygonClick(@NonNull Polygon var1);
    }

    @Deprecated
    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMapLongClickListener {
        public boolean onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public boolean onMapClick(@NonNull LatLng var1);
    }

    static interface OnGesturesManagerInteractionListener {
        public void onAddMapClickListener(OnMapClickListener var1);

        public void onRemoveMapClickListener(OnMapClickListener var1);

        public void onAddMapLongClickListener(OnMapLongClickListener var1);

        public void onRemoveMapLongClickListener(OnMapLongClickListener var1);

        public void onAddFlingListener(OnFlingListener var1);

        public void onRemoveFlingListener(OnFlingListener var1);

        public void onAddMoveListener(OnMoveListener var1);

        public void onRemoveMoveListener(OnMoveListener var1);

        public void onAddRotateListener(OnRotateListener var1);

        public void onRemoveRotateListener(OnRotateListener var1);

        public void onAddScaleListener(OnScaleListener var1);

        public void onRemoveScaleListener(OnScaleListener var1);

        public void onAddShoveListener(OnShoveListener var1);

        public void onRemoveShoveListener(OnShoveListener var1);

        public AndroidGesturesManager getGesturesManager();

        public void setGesturesManager(AndroidGesturesManager var1, boolean var2, boolean var3);

        public void cancelAllVelocityAnimations();
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnCompassAnimationListener {
        public void onCompassAnimation();

        public void onCompassAnimationFinished();
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_API_GESTURE = 1;
        public static final int REASON_DEVELOPER_ANIMATION = 2;
        public static final int REASON_API_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnShoveListener {
        public void onShoveBegin(@NonNull ShoveGestureDetector var1);

        public void onShove(@NonNull ShoveGestureDetector var1);

        public void onShoveEnd(@NonNull ShoveGestureDetector var1);
    }

    public static interface OnScaleListener {
        public void onScaleBegin(@NonNull StandardScaleGestureDetector var1);

        public void onScale(@NonNull StandardScaleGestureDetector var1);

        public void onScaleEnd(@NonNull StandardScaleGestureDetector var1);
    }

    public static interface OnRotateListener {
        public void onRotateBegin(@NonNull RotateGestureDetector var1);

        public void onRotate(@NonNull RotateGestureDetector var1);

        public void onRotateEnd(@NonNull RotateGestureDetector var1);
    }

    public static interface OnMoveListener {
        public void onMoveBegin(@NonNull MoveGestureDetector var1);

        public void onMove(@NonNull MoveGestureDetector var1);

        public void onMoveEnd(@NonNull MoveGestureDetector var1);
    }

    public static interface OnFlingListener {
        public void onFling();
    }
}

