/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class BackgroundLayer
extends Layer {
    @Keep
    BackgroundLayer(long nativePtr) {
        super(nativePtr);
    }

    public BackgroundLayer(String layerId) {
        this.initialize(layerId);
    }

    @Keep
    protected native void initialize(String var1);

    @NonNull
    public BackgroundLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<String> getBackgroundColor() {
        this.checkThread();
        return new PropertyValue<Object>("background-color", this.nativeGetBackgroundColor());
    }

    @ColorInt
    public int getBackgroundColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getBackgroundColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("background-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getBackgroundColorTransition() {
        this.checkThread();
        return this.nativeGetBackgroundColorTransition();
    }

    public void setBackgroundColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetBackgroundColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getBackgroundPattern() {
        this.checkThread();
        return new PropertyValue<Object>("background-pattern", this.nativeGetBackgroundPattern());
    }

    @NonNull
    public TransitionOptions getBackgroundPatternTransition() {
        this.checkThread();
        return this.nativeGetBackgroundPatternTransition();
    }

    public void setBackgroundPatternTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetBackgroundPatternTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getBackgroundOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("background-opacity", this.nativeGetBackgroundOpacity());
    }

    @NonNull
    public TransitionOptions getBackgroundOpacityTransition() {
        this.checkThread();
        return this.nativeGetBackgroundOpacityTransition();
    }

    public void setBackgroundOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetBackgroundOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    @Keep
    private native Object nativeGetBackgroundColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetBackgroundColorTransition();

    @Keep
    private native void nativeSetBackgroundColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetBackgroundPattern();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetBackgroundPatternTransition();

    @Keep
    private native void nativeSetBackgroundPatternTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetBackgroundOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetBackgroundOpacityTransition();

    @Keep
    private native void nativeSetBackgroundOpacityTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

