/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.util.List;

interface NativeMap {
    public void resizeView(int var1, int var2);

    public void onLowMemory();

    public void destroy();

    public boolean isDestroyed();

    public void jumpTo(@NonNull LatLng var1, double var2, double var4, double var6, double[] var8);

    public void easeTo(@NonNull LatLng var1, double var2, double var4, double var6, double[] var8, long var9, boolean var11);

    public void flyTo(@NonNull LatLng var1, double var2, double var4, double var6, double[] var8, long var9);

    public void moveBy(double var1, double var3, long var5);

    @NonNull
    public CameraPosition getCameraPosition();

    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds var1, int[] var2, double var3, double var5);

    public CameraPosition getCameraForGeometry(@NonNull Geometry var1, int[] var2, double var3, double var5);

    public void resetPosition();

    public void setLatLng(@NonNull LatLng var1, long var2);

    public LatLng getLatLng();

    public void setLatLngBounds(@Nullable LatLngBounds var1);

    public void setVisibleCoordinateBounds(@NonNull LatLng[] var1, @NonNull RectF var2, double var3, long var5);

    public void setPitch(double var1, long var3);

    public double getPitch();

    public void setZoom(double var1, @NonNull PointF var3, long var4);

    public double getZoom();

    public void setMinZoom(double var1);

    public double getMinZoom();

    public void setMaxZoom(double var1);

    public double getMaxZoom();

    public void setMinPitch(double var1);

    public double getMinPitch();

    public void setMaxPitch(double var1);

    public double getMaxPitch();

    public void resetZoom();

    public void rotateBy(double var1, double var3, double var5, double var7, long var9);

    public void setBearing(double var1, long var3);

    public void setBearing(double var1, double var3, double var5, long var7);

    public double getBearing();

    public void resetNorth();

    public void cancelTransitions();

    public void setStyleUri(String var1);

    @NonNull
    public String getStyleUri();

    public void setStyleJson(String var1);

    @NonNull
    public String getStyleJson();

    public boolean isFullyLoaded();

    public void addLayer(@NonNull Layer var1);

    public void addLayerBelow(@NonNull Layer var1, @NonNull String var2);

    public void addLayerAbove(@NonNull Layer var1, @NonNull String var2);

    public void addLayerAt(@NonNull Layer var1, @IntRange(from=0L) int var2);

    @NonNull
    public List<Layer> getLayers();

    public Layer getLayer(String var1);

    public boolean removeLayer(@NonNull String var1);

    public boolean removeLayer(@NonNull Layer var1);

    public boolean removeLayerAt(@IntRange(from=0L) int var1);

    public void addSource(@NonNull Source var1);

    @NonNull
    public List<Source> getSources();

    public Source getSource(@NonNull String var1);

    public boolean removeSource(@NonNull String var1);

    public boolean removeSource(@NonNull Source var1);

    public void setTransitionOptions(@NonNull TransitionOptions var1);

    @NonNull
    public TransitionOptions getTransitionOptions();

    public void addImages(Image[] var1);

    public Bitmap getImage(String var1);

    public void removeImage(String var1);

    public Light getLight();

    public void setContentPadding(double[] var1);

    public double[] getContentPadding();

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF var1, @Nullable String[] var2, @Nullable Expression var3);

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF var1, @Nullable String[] var2, @Nullable Expression var3);

    public double getMetersPerPixelAtLatitude(double var1);

    public ProjectedMeters projectedMetersForLatLng(@NonNull LatLng var1);

    public LatLng latLngForProjectedMeters(@NonNull ProjectedMeters var1);

    @NonNull
    public PointF pixelForLatLng(@NonNull LatLng var1);

    public void pixelsForLatLngs(@NonNull double[] var1, @NonNull double[] var2);

    public void getVisibleCoordinateBounds(@NonNull double[] var1);

    public LatLng latLngForPixel(@NonNull PointF var1);

    public void latLngsForPixels(@NonNull double[] var1, @NonNull double[] var2);

    public void setOnFpsChangedListener(@NonNull MapboxMap.OnFpsChangedListener var1);

    public void setDebug(boolean var1);

    public boolean getDebug();

    public void setReachability(boolean var1);

    public void setApiBaseUrl(String var1);

    public void setPrefetchTiles(boolean var1);

    public boolean getPrefetchTiles();

    public void setPrefetchZoomDelta(@IntRange(from=0L) int var1);

    @IntRange(from=0L)
    public int getPrefetchZoomDelta();

    public void setGestureInProgress(boolean var1);

    public float getPixelRatio();

    public long addMarker(Marker var1);

    @NonNull
    public long[] addMarkers(@NonNull List<Marker> var1);

    public long addPolyline(Polyline var1);

    @NonNull
    public long[] addPolylines(@NonNull List<Polyline> var1);

    public long addPolygon(Polygon var1);

    @NonNull
    public long[] addPolygons(@NonNull List<Polygon> var1);

    public void updateMarker(@NonNull Marker var1);

    public void updatePolygon(@NonNull Polygon var1);

    public void updatePolyline(@NonNull Polyline var1);

    public void removeAnnotation(long var1);

    public void removeAnnotations(long[] var1);

    public double getTopOffsetPixelsForAnnotationSymbol(String var1);

    public void addAnnotationIcon(String var1, int var2, int var3, float var4, byte[] var5);

    public void removeAnnotationIcon(String var1);

    @NonNull
    public long[] queryPointAnnotations(RectF var1);

    @NonNull
    public long[] queryShapeAnnotations(RectF var1);

    @NonNull
    public RectF getDensityDependantRectangle(RectF var1);

    public long getNativePtr();

    public void addSnapshotCallback(@NonNull MapboxMap.SnapshotReadyCallback var1);
}

